/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;

public record NBTTagString(String value) implements PrimitiveTag
{
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final NBTTagType<NBTTagString> TYPE = new NBTTagType.b<NBTTagString>(){

        @Override
        public NBTTagString load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagString.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static String readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(36L);
            String var2 = var0.readUTF();
            var1.accountBytes(2L, var2.length());
            return var2;
        }

        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            NBTTagString.skipString(var0);
        }

        @Override
        public String getName() {
            return "STRING";
        }

        @Override
        public String getPrettyName() {
            return "TAG_String";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private static final NBTTagString EMPTY = new NBTTagString("");
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char NOT_SET = '\u0000';

    public static void skipString(DataInput var0) throws IOException {
        var0.skipBytes(var0.readUnsignedShort());
    }

    public static NBTTagString valueOf(String var0) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return new NBTTagString(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeUTF(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 36 + 2 * this.value.length();
    }

    @Override
    public byte getId() {
        return 8;
    }

    public NBTTagType<NBTTagString> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitString(this);
        return var0.build();
    }

    @Override
    public NBTTagString copy() {
        return this;
    }

    @Override
    public Optional<String> asString() {
        return Optional.of(this.value);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitString(this);
    }

    public static String quoteAndEscape(String var0) {
        StringBuilder var1 = new StringBuilder();
        NBTTagString.quoteAndEscape(var0, var1);
        return var1.toString();
    }

    public static void quoteAndEscape(String var0, StringBuilder var1) {
        int var2 = var1.length();
        var1.append(' ');
        int var3 = 0;
        for (int var4 = 0; var4 < var0.length(); ++var4) {
            int var5 = var0.charAt(var4);
            if (var5 == 92) {
                var1.append("\\\\");
                continue;
            }
            if (var5 == 34 || var5 == 39) {
                if (var3 == 0) {
                    int n2 = var3 = var5 == 34 ? 39 : 34;
                }
                if (var3 == var5) {
                    var1.append('\\');
                }
                var1.append((char)var5);
                continue;
            }
            String var6 = SnbtGrammar.escapeControlCharacters((char)var5);
            if (var6 != null) {
                var1.append('\\');
                var1.append(var6);
                continue;
            }
            var1.append((char)var5);
        }
        if (var3 == 0) {
            var3 = 34;
        }
        var1.setCharAt(var2, (char)var3);
        var1.append((char)var3);
    }

    public static String escapeWithoutQuotes(String var0) {
        StringBuilder var1 = new StringBuilder();
        NBTTagString.escapeWithoutQuotes(var0, var1);
        return var1.toString();
    }

    public static void escapeWithoutQuotes(String var0, StringBuilder var1) {
        block3: for (int var2 = 0; var2 < var0.length(); ++var2) {
            char var3 = var0.charAt(var2);
            switch (var3) {
                case '\"': 
                case '\'': 
                case '\\': {
                    var1.append('\\');
                    var1.append(var3);
                    continue block3;
                }
                default: {
                    String var4 = SnbtGrammar.escapeControlCharacters(var3);
                    if (var4 != null) {
                        var1.append('\\');
                        var1.append(var4);
                        continue block3;
                    }
                    var1.append(var3);
                }
            }
        }
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

