/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCounted;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.LpVec3;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class PacketDataSerializer
extends ByteBuf {
    private final ByteBuf source;
    public static final short MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final int MAX_COMPONENT_STRING_LENGTH = 262144;
    private static final int PUBLIC_KEY_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_HEADER_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_LENGTH = 512;
    private static final Gson GSON = new Gson();

    public PacketDataSerializer(ByteBuf var0) {
        this.source = var0;
    }

    @Deprecated
    public <T> T readWithCodecTrusted(DynamicOps<NBTBase> var0, Codec<T> var1) {
        return this.readWithCodec(var0, var1, NBTReadLimiter.unlimitedHeap());
    }

    @Deprecated
    public <T> T readWithCodec(DynamicOps<NBTBase> var0, Codec<T> var12, NBTReadLimiter var2) {
        NBTBase var3 = this.readNbt(var2);
        return (T)var12.parse(var0, (Object)var3).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var3)));
    }

    @Deprecated
    public <T> PacketDataSerializer writeWithCodec(DynamicOps<NBTBase> var0, Codec<T> var12, T var2) {
        NBTBase var3 = (NBTBase)var12.encodeStart(var0, var2).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var2)));
        this.writeNbt(var3);
        return this;
    }

    public <T> T readLenientJsonWithCodec(Codec<T> var02) {
        JsonElement var1 = LenientJsonParser.parse(this.readUtf());
        DataResult var2 = var02.parse((DynamicOps)JsonOps.INSTANCE, (Object)var1);
        return (T)var2.getOrThrow(var0 -> new DecoderException("Failed to decode JSON: " + var0));
    }

    public <T> void writeJsonWithCodec(Codec<T> var0, T var12) {
        DataResult var2 = var0.encodeStart((DynamicOps)JsonOps.INSTANCE, var12);
        this.writeUtf(GSON.toJson((JsonElement)var2.getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)))));
    }

    public static <T> IntFunction<T> limitValue(IntFunction<T> var0, int var1) {
        return var2 -> {
            if (var2 > var1) {
                throw new DecoderException("Value " + var2 + " is larger than limit " + var1);
            }
            return var0.apply(var2);
        };
    }

    public <T, C extends Collection<T>> C readCollection(IntFunction<C> var0, StreamDecoder<? super PacketDataSerializer, T> var1) {
        int var2 = this.readVarInt();
        Collection var3 = (Collection)var0.apply(var2);
        for (int var4 = 0; var4 < var2; ++var4) {
            var3.add(var1.decode(this));
        }
        return (C)var3;
    }

    public <T> void writeCollection(Collection<T> var0, StreamEncoder<? super PacketDataSerializer, T> var1) {
        this.writeVarInt(var0.size());
        for (T var3 : var0) {
            var1.encode(this, var3);
        }
    }

    public <T> List<T> readList(StreamDecoder<? super PacketDataSerializer, T> var0) {
        return this.readCollection(Lists::newArrayListWithCapacity, var0);
    }

    public IntList readIntIdList() {
        int var0 = this.readVarInt();
        IntArrayList var1 = new IntArrayList();
        for (int var2 = 0; var2 < var0; ++var2) {
            var1.add(this.readVarInt());
        }
        return var1;
    }

    public void writeIntIdList(IntList var0) {
        this.writeVarInt(var0.size());
        var0.forEach(this::writeVarInt);
    }

    public <K, V, M extends Map<K, V>> M readMap(IntFunction<M> var0, StreamDecoder<? super PacketDataSerializer, K> var1, StreamDecoder<? super PacketDataSerializer, V> var2) {
        int var3 = this.readVarInt();
        Map var4 = (Map)var0.apply(var3);
        for (int var5 = 0; var5 < var3; ++var5) {
            K var6 = var1.decode(this);
            V var7 = var2.decode(this);
            var4.put(var6, var7);
        }
        return (M)var4;
    }

    public <K, V> Map<K, V> readMap(StreamDecoder<? super PacketDataSerializer, K> var0, StreamDecoder<? super PacketDataSerializer, V> var1) {
        return this.readMap(Maps::newHashMapWithExpectedSize, var0, var1);
    }

    public <K, V> void writeMap(Map<K, V> var0, StreamEncoder<? super PacketDataSerializer, K> var1, StreamEncoder<? super PacketDataSerializer, V> var22) {
        this.writeVarInt(var0.size());
        var0.forEach((var2, var3) -> {
            var1.encode(this, var2);
            var22.encode(this, var3);
        });
    }

    public void readWithCount(Consumer<PacketDataSerializer> var0) {
        int var1 = this.readVarInt();
        for (int var2 = 0; var2 < var1; ++var2) {
            var0.accept(this);
        }
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> var0, Class<E> var1) {
        Enum[] var2 = (Enum[])var1.getEnumConstants();
        BitSet var3 = new BitSet(var2.length);
        for (int var4 = 0; var4 < var2.length; ++var4) {
            var3.set(var4, var0.contains(var2[var4]));
        }
        this.writeFixedBitSet(var3, var2.length);
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> var0) {
        Enum[] var1 = (Enum[])var0.getEnumConstants();
        BitSet var2 = this.readFixedBitSet(var1.length);
        EnumSet<Enum> var3 = EnumSet.noneOf(var0);
        for (int var4 = 0; var4 < var1.length; ++var4) {
            if (!var2.get(var4)) continue;
            var3.add(var1[var4]);
        }
        return var3;
    }

    public <T> void writeOptional(Optional<T> var0, StreamEncoder<? super PacketDataSerializer, T> var1) {
        if (var0.isPresent()) {
            this.writeBoolean(true);
            var1.encode(this, var0.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> readOptional(StreamDecoder<? super PacketDataSerializer, T> var0) {
        if (this.readBoolean()) {
            return Optional.of(var0.decode(this));
        }
        return Optional.empty();
    }

    public <L, R> void writeEither(Either<L, R> var0, StreamEncoder<? super PacketDataSerializer, L> var12, StreamEncoder<? super PacketDataSerializer, R> var2) {
        var0.ifLeft(var1 -> {
            this.writeBoolean(true);
            var12.encode(this, var1);
        }).ifRight(var1 -> {
            this.writeBoolean(false);
            var2.encode(this, var1);
        });
    }

    public <L, R> Either<L, R> readEither(StreamDecoder<? super PacketDataSerializer, L> var0, StreamDecoder<? super PacketDataSerializer, R> var1) {
        if (this.readBoolean()) {
            return Either.left(var0.decode(this));
        }
        return Either.right(var1.decode(this));
    }

    public <T> @Nullable T readNullable(StreamDecoder<? super PacketDataSerializer, T> var0) {
        return PacketDataSerializer.readNullable(this, var0);
    }

    public static <T, B extends ByteBuf> @Nullable T readNullable(B var0, StreamDecoder<? super B, T> var1) {
        if (var0.readBoolean()) {
            return var1.decode(var0);
        }
        return null;
    }

    public <T> void writeNullable(@Nullable T var0, StreamEncoder<? super PacketDataSerializer, T> var1) {
        PacketDataSerializer.writeNullable(this, var0, var1);
    }

    public static <T, B extends ByteBuf> void writeNullable(B var0, @Nullable T var1, StreamEncoder<? super B, T> var2) {
        if (var1 != null) {
            var0.writeBoolean(true);
            var2.encode(var0, var1);
        } else {
            var0.writeBoolean(false);
        }
    }

    public byte[] readByteArray() {
        return PacketDataSerializer.readByteArray(this);
    }

    public static byte[] readByteArray(ByteBuf var0) {
        return PacketDataSerializer.readByteArray(var0, var0.readableBytes());
    }

    public PacketDataSerializer writeByteArray(byte[] var0) {
        PacketDataSerializer.writeByteArray(this, var0);
        return this;
    }

    public static void writeByteArray(ByteBuf var0, byte[] var1) {
        VarInt.write(var0, var1.length);
        var0.writeBytes(var1);
    }

    public byte[] readByteArray(int var0) {
        return PacketDataSerializer.readByteArray(this, var0);
    }

    public static byte[] readByteArray(ByteBuf var0, int var1) {
        int var2 = VarInt.read(var0);
        if (var2 > var1) {
            throw new DecoderException("ByteArray with size " + var2 + " is bigger than allowed " + var1);
        }
        byte[] var3 = new byte[var2];
        var0.readBytes(var3);
        return var3;
    }

    public PacketDataSerializer writeVarIntArray(int[] var0) {
        this.writeVarInt(var0.length);
        for (int var4 : var0) {
            this.writeVarInt(var4);
        }
        return this;
    }

    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readableBytes());
    }

    public int[] readVarIntArray(int var0) {
        int var1 = this.readVarInt();
        if (var1 > var0) {
            throw new DecoderException("VarIntArray with size " + var1 + " is bigger than allowed " + var0);
        }
        int[] var2 = new int[var1];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var2[var3] = this.readVarInt();
        }
        return var2;
    }

    public PacketDataSerializer writeLongArray(long[] var0) {
        PacketDataSerializer.writeLongArray(this, var0);
        return this;
    }

    public static void writeLongArray(ByteBuf var0, long[] var1) {
        VarInt.write(var0, var1.length);
        PacketDataSerializer.writeFixedSizeLongArray(var0, var1);
    }

    public PacketDataSerializer writeFixedSizeLongArray(long[] var0) {
        PacketDataSerializer.writeFixedSizeLongArray(this, var0);
        return this;
    }

    public static void writeFixedSizeLongArray(ByteBuf var0, long[] var1) {
        for (long var5 : var1) {
            var0.writeLong(var5);
        }
    }

    public long[] readLongArray() {
        return PacketDataSerializer.readLongArray(this);
    }

    public long[] readFixedSizeLongArray(long[] var0) {
        return PacketDataSerializer.readFixedSizeLongArray(this, var0);
    }

    public static long[] readLongArray(ByteBuf var0) {
        int var2;
        int var1 = VarInt.read(var0);
        if (var1 > (var2 = var0.readableBytes() / 8)) {
            throw new DecoderException("LongArray with size " + var1 + " is bigger than allowed " + var2);
        }
        return PacketDataSerializer.readFixedSizeLongArray(var0, new long[var1]);
    }

    public static long[] readFixedSizeLongArray(ByteBuf var0, long[] var1) {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = var0.readLong();
        }
        return var1;
    }

    public BlockPosition readBlockPos() {
        return PacketDataSerializer.readBlockPos(this);
    }

    public static BlockPosition readBlockPos(ByteBuf var0) {
        return BlockPosition.of(var0.readLong());
    }

    public PacketDataSerializer writeBlockPos(BlockPosition var0) {
        PacketDataSerializer.writeBlockPos(this, var0);
        return this;
    }

    public static void writeBlockPos(ByteBuf var0, BlockPosition var1) {
        var0.writeLong(var1.asLong());
    }

    public ChunkCoordIntPair readChunkPos() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer writeChunkPos(ChunkCoordIntPair var0) {
        this.writeLong(var0.toLong());
        return this;
    }

    public static ChunkCoordIntPair readChunkPos(ByteBuf var0) {
        return new ChunkCoordIntPair(var0.readLong());
    }

    public static void writeChunkPos(ByteBuf var0, ChunkCoordIntPair var1) {
        var0.writeLong(var1.toLong());
    }

    public GlobalPos readGlobalPos() {
        ResourceKey<World> var0 = this.readResourceKey(Registries.DIMENSION);
        BlockPosition var1 = this.readBlockPos();
        return GlobalPos.of(var0, var1);
    }

    public void writeGlobalPos(GlobalPos var0) {
        this.writeResourceKey(var0.dimension());
        this.writeBlockPos(var0.pos());
    }

    public Vector3f readVector3f() {
        return PacketDataSerializer.readVector3f(this);
    }

    public static Vector3f readVector3f(ByteBuf var0) {
        return new Vector3f(var0.readFloat(), var0.readFloat(), var0.readFloat());
    }

    public void writeVector3f(Vector3f var0) {
        PacketDataSerializer.writeVector3f(this, (Vector3fc)var0);
    }

    public static void writeVector3f(ByteBuf var0, Vector3fc var1) {
        var0.writeFloat(var1.x());
        var0.writeFloat(var1.y());
        var0.writeFloat(var1.z());
    }

    public Quaternionf readQuaternion() {
        return PacketDataSerializer.readQuaternion(this);
    }

    public static Quaternionf readQuaternion(ByteBuf var0) {
        return new Quaternionf(var0.readFloat(), var0.readFloat(), var0.readFloat(), var0.readFloat());
    }

    public void writeQuaternion(Quaternionf var0) {
        PacketDataSerializer.writeQuaternion(this, (Quaternionfc)var0);
    }

    public static void writeQuaternion(ByteBuf var0, Quaternionfc var1) {
        var0.writeFloat(var1.x());
        var0.writeFloat(var1.y());
        var0.writeFloat(var1.z());
        var0.writeFloat(var1.w());
    }

    public static Vec3D readVec3(ByteBuf var0) {
        return new Vec3D(var0.readDouble(), var0.readDouble(), var0.readDouble());
    }

    public Vec3D readVec3() {
        return PacketDataSerializer.readVec3(this);
    }

    public static void writeVec3(ByteBuf var0, Vec3D var1) {
        var0.writeDouble(var1.x());
        var0.writeDouble(var1.y());
        var0.writeDouble(var1.z());
    }

    public void writeVec3(Vec3D var0) {
        PacketDataSerializer.writeVec3(this, var0);
    }

    public Vec3D readLpVec3() {
        return LpVec3.read(this);
    }

    public void writeLpVec3(Vec3D var0) {
        LpVec3.write(this, var0);
    }

    public <T extends Enum<T>> T readEnum(Class<T> var0) {
        return (T)((Enum[])var0.getEnumConstants())[this.readVarInt()];
    }

    public PacketDataSerializer writeEnum(Enum<?> var0) {
        return this.writeVarInt(var0.ordinal());
    }

    public <T> T readById(IntFunction<T> var0) {
        int var1 = this.readVarInt();
        return var0.apply(var1);
    }

    public <T> PacketDataSerializer writeById(ToIntFunction<T> var0, T var1) {
        int var2 = var0.applyAsInt(var1);
        return this.writeVarInt(var2);
    }

    public int readVarInt() {
        return VarInt.read(this.source);
    }

    public long readVarLong() {
        return VarLong.read(this.source);
    }

    public PacketDataSerializer writeUUID(UUID var0) {
        PacketDataSerializer.writeUUID(this, var0);
        return this;
    }

    public static void writeUUID(ByteBuf var0, UUID var1) {
        var0.writeLong(var1.getMostSignificantBits());
        var0.writeLong(var1.getLeastSignificantBits());
    }

    public UUID readUUID() {
        return PacketDataSerializer.readUUID(this);
    }

    public static UUID readUUID(ByteBuf var0) {
        return new UUID(var0.readLong(), var0.readLong());
    }

    public PacketDataSerializer writeVarInt(int var0) {
        VarInt.write(this.source, var0);
        return this;
    }

    public PacketDataSerializer writeVarLong(long var0) {
        VarLong.write(this.source, var0);
        return this;
    }

    public PacketDataSerializer writeNbt(@Nullable NBTBase var0) {
        PacketDataSerializer.writeNbt(this, var0);
        return this;
    }

    public static void writeNbt(ByteBuf var0, @Nullable NBTBase var1) {
        if (var1 == null) {
            var1 = NBTTagEnd.INSTANCE;
        }
        try {
            NBTCompressedStreamTools.writeAnyTag(var1, (DataOutput)new ByteBufOutputStream(var0));
        }
        catch (IOException var2) {
            throw new EncoderException((Throwable)var2);
        }
    }

    public @Nullable NBTTagCompound readNbt() {
        return PacketDataSerializer.readNbt(this);
    }

    public static @Nullable NBTTagCompound readNbt(ByteBuf var0) {
        NBTBase var1 = PacketDataSerializer.readNbt(var0, NBTReadLimiter.defaultQuota());
        if (var1 == null || var1 instanceof NBTTagCompound) {
            return (NBTTagCompound)var1;
        }
        throw new DecoderException("Not a compound tag: " + String.valueOf(var1));
    }

    public static @Nullable NBTBase readNbt(ByteBuf var0, NBTReadLimiter var1) {
        try {
            NBTBase var2 = NBTCompressedStreamTools.readAnyTag((DataInput)new ByteBufInputStream(var0), var1);
            if (var2.getId() == 0) {
                return null;
            }
            return var2;
        }
        catch (IOException var2) {
            throw new EncoderException((Throwable)var2);
        }
    }

    public @Nullable NBTBase readNbt(NBTReadLimiter var0) {
        return PacketDataSerializer.readNbt(this, var0);
    }

    public String readUtf() {
        return this.readUtf(Short.MAX_VALUE);
    }

    public String readUtf(int var0) {
        return Utf8String.read(this.source, var0);
    }

    public PacketDataSerializer writeUtf(String var0) {
        return this.writeUtf(var0, Short.MAX_VALUE);
    }

    public PacketDataSerializer writeUtf(String var0, int var1) {
        Utf8String.write(this.source, var0, var1);
        return this;
    }

    public MinecraftKey readIdentifier() {
        return MinecraftKey.parse(this.readUtf(Short.MAX_VALUE));
    }

    public PacketDataSerializer writeIdentifier(MinecraftKey var0) {
        this.writeUtf(var0.toString());
        return this;
    }

    public <T> ResourceKey<T> readResourceKey(ResourceKey<? extends IRegistry<T>> var0) {
        MinecraftKey var1 = this.readIdentifier();
        return ResourceKey.create(var0, var1);
    }

    public void writeResourceKey(ResourceKey<?> var0) {
        this.writeIdentifier(var0.identifier());
    }

    public <T> ResourceKey<? extends IRegistry<T>> readRegistryKey() {
        MinecraftKey var0 = this.readIdentifier();
        return ResourceKey.createRegistryKey(var0);
    }

    public Instant readInstant() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeInstant(Instant var0) {
        this.writeLong(var0.toEpochMilli());
    }

    public PublicKey readPublicKey() {
        try {
            return MinecraftEncryption.byteToPublicKey(this.readByteArray(512));
        }
        catch (CryptographyException var0) {
            throw new DecoderException("Malformed public key bytes", (Throwable)var0);
        }
    }

    public PacketDataSerializer writePublicKey(PublicKey var0) {
        this.writeByteArray(var0.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock readBlockHitResult() {
        BlockPosition var0 = this.readBlockPos();
        EnumDirection var1 = this.readEnum(EnumDirection.class);
        float var2 = this.readFloat();
        float var3 = this.readFloat();
        float var4 = this.readFloat();
        boolean var5 = this.readBoolean();
        boolean var6 = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)var0.getX() + (double)var2, (double)var0.getY() + (double)var3, (double)var0.getZ() + (double)var4), var1, var0, var5, var6);
    }

    public void writeBlockHitResult(MovingObjectPositionBlock var0) {
        BlockPosition var1 = var0.getBlockPos();
        this.writeBlockPos(var1);
        this.writeEnum(var0.getDirection());
        Vec3D var2 = var0.getLocation();
        this.writeFloat((float)(var2.x - (double)var1.getX()));
        this.writeFloat((float)(var2.y - (double)var1.getY()));
        this.writeFloat((float)(var2.z - (double)var1.getZ()));
        this.writeBoolean(var0.isInside());
        this.writeBoolean(var0.isWorldBorderHit());
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet var0) {
        this.writeLongArray(var0.toLongArray());
    }

    public BitSet readFixedBitSet(int var0) {
        byte[] var1 = new byte[MathHelper.positiveCeilDiv(var0, 8)];
        this.readBytes(var1);
        return BitSet.valueOf(var1);
    }

    public void writeFixedBitSet(BitSet var0, int var1) {
        if (var0.length() > var1) {
            throw new EncoderException("BitSet is larger than expected size (" + var0.length() + ">" + var1 + ")");
        }
        byte[] var2 = var0.toByteArray();
        this.writeBytes(Arrays.copyOf(var2, MathHelper.positiveCeilDiv(var1, 8)));
    }

    public static int readContainerId(ByteBuf var0) {
        return VarInt.read(var0);
    }

    public int readContainerId() {
        return PacketDataSerializer.readContainerId(this.source);
    }

    public static void writeContainerId(ByteBuf var0, int var1) {
        VarInt.write(var0, var1);
    }

    public void writeContainerId(int var0) {
        PacketDataSerializer.writeContainerId(this.source, var0);
    }

    public boolean isContiguous() {
        return this.source.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.source.maxFastWritableBytes();
    }

    public int capacity() {
        return this.source.capacity();
    }

    public PacketDataSerializer capacity(int var0) {
        this.source.capacity(var0);
        return this;
    }

    public int maxCapacity() {
        return this.source.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.source.alloc();
    }

    public ByteOrder order() {
        return this.source.order();
    }

    public ByteBuf order(ByteOrder var0) {
        return this.source.order(var0);
    }

    public ByteBuf unwrap() {
        return this.source;
    }

    public boolean isDirect() {
        return this.source.isDirect();
    }

    public boolean isReadOnly() {
        return this.source.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.source.asReadOnly();
    }

    public int readerIndex() {
        return this.source.readerIndex();
    }

    public PacketDataSerializer readerIndex(int var0) {
        this.source.readerIndex(var0);
        return this;
    }

    public int writerIndex() {
        return this.source.writerIndex();
    }

    public PacketDataSerializer writerIndex(int var0) {
        this.source.writerIndex(var0);
        return this;
    }

    public PacketDataSerializer setIndex(int var0, int var1) {
        this.source.setIndex(var0, var1);
        return this;
    }

    public int readableBytes() {
        return this.source.readableBytes();
    }

    public int writableBytes() {
        return this.source.writableBytes();
    }

    public int maxWritableBytes() {
        return this.source.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.source.isReadable();
    }

    public boolean isReadable(int var0) {
        return this.source.isReadable(var0);
    }

    public boolean isWritable() {
        return this.source.isWritable();
    }

    public boolean isWritable(int var0) {
        return this.source.isWritable(var0);
    }

    public PacketDataSerializer clear() {
        this.source.clear();
        return this;
    }

    public PacketDataSerializer markReaderIndex() {
        this.source.markReaderIndex();
        return this;
    }

    public PacketDataSerializer resetReaderIndex() {
        this.source.resetReaderIndex();
        return this;
    }

    public PacketDataSerializer markWriterIndex() {
        this.source.markWriterIndex();
        return this;
    }

    public PacketDataSerializer resetWriterIndex() {
        this.source.resetWriterIndex();
        return this;
    }

    public PacketDataSerializer discardReadBytes() {
        this.source.discardReadBytes();
        return this;
    }

    public PacketDataSerializer discardSomeReadBytes() {
        this.source.discardSomeReadBytes();
        return this;
    }

    public PacketDataSerializer ensureWritable(int var0) {
        this.source.ensureWritable(var0);
        return this;
    }

    public int ensureWritable(int var0, boolean var1) {
        return this.source.ensureWritable(var0, var1);
    }

    public boolean getBoolean(int var0) {
        return this.source.getBoolean(var0);
    }

    public byte getByte(int var0) {
        return this.source.getByte(var0);
    }

    public short getUnsignedByte(int var0) {
        return this.source.getUnsignedByte(var0);
    }

    public short getShort(int var0) {
        return this.source.getShort(var0);
    }

    public short getShortLE(int var0) {
        return this.source.getShortLE(var0);
    }

    public int getUnsignedShort(int var0) {
        return this.source.getUnsignedShort(var0);
    }

    public int getUnsignedShortLE(int var0) {
        return this.source.getUnsignedShortLE(var0);
    }

    public int getMedium(int var0) {
        return this.source.getMedium(var0);
    }

    public int getMediumLE(int var0) {
        return this.source.getMediumLE(var0);
    }

    public int getUnsignedMedium(int var0) {
        return this.source.getUnsignedMedium(var0);
    }

    public int getUnsignedMediumLE(int var0) {
        return this.source.getUnsignedMediumLE(var0);
    }

    public int getInt(int var0) {
        return this.source.getInt(var0);
    }

    public int getIntLE(int var0) {
        return this.source.getIntLE(var0);
    }

    public long getUnsignedInt(int var0) {
        return this.source.getUnsignedInt(var0);
    }

    public long getUnsignedIntLE(int var0) {
        return this.source.getUnsignedIntLE(var0);
    }

    public long getLong(int var0) {
        return this.source.getLong(var0);
    }

    public long getLongLE(int var0) {
        return this.source.getLongLE(var0);
    }

    public char getChar(int var0) {
        return this.source.getChar(var0);
    }

    public float getFloat(int var0) {
        return this.source.getFloat(var0);
    }

    public double getDouble(int var0) {
        return this.source.getDouble(var0);
    }

    public PacketDataSerializer getBytes(int var0, ByteBuf var1) {
        this.source.getBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, ByteBuf var1, int var2) {
        this.source.getBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, ByteBuf var1, int var2, int var3) {
        this.source.getBytes(var0, var1, var2, var3);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, byte[] var1) {
        this.source.getBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, byte[] var1, int var2, int var3) {
        this.source.getBytes(var0, var1, var2, var3);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, ByteBuffer var1) {
        this.source.getBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer getBytes(int var0, OutputStream var1, int var2) throws IOException {
        this.source.getBytes(var0, var1, var2);
        return this;
    }

    public int getBytes(int var0, GatheringByteChannel var1, int var2) throws IOException {
        return this.source.getBytes(var0, var1, var2);
    }

    public int getBytes(int var0, FileChannel var1, long var2, int var4) throws IOException {
        return this.source.getBytes(var0, var1, var2, var4);
    }

    public CharSequence getCharSequence(int var0, int var1, Charset var2) {
        return this.source.getCharSequence(var0, var1, var2);
    }

    public PacketDataSerializer setBoolean(int var0, boolean var1) {
        this.source.setBoolean(var0, var1);
        return this;
    }

    public PacketDataSerializer setByte(int var0, int var1) {
        this.source.setByte(var0, var1);
        return this;
    }

    public PacketDataSerializer setShort(int var0, int var1) {
        this.source.setShort(var0, var1);
        return this;
    }

    public PacketDataSerializer setShortLE(int var0, int var1) {
        this.source.setShortLE(var0, var1);
        return this;
    }

    public PacketDataSerializer setMedium(int var0, int var1) {
        this.source.setMedium(var0, var1);
        return this;
    }

    public PacketDataSerializer setMediumLE(int var0, int var1) {
        this.source.setMediumLE(var0, var1);
        return this;
    }

    public PacketDataSerializer setInt(int var0, int var1) {
        this.source.setInt(var0, var1);
        return this;
    }

    public PacketDataSerializer setIntLE(int var0, int var1) {
        this.source.setIntLE(var0, var1);
        return this;
    }

    public PacketDataSerializer setLong(int var0, long var1) {
        this.source.setLong(var0, var1);
        return this;
    }

    public PacketDataSerializer setLongLE(int var0, long var1) {
        this.source.setLongLE(var0, var1);
        return this;
    }

    public PacketDataSerializer setChar(int var0, int var1) {
        this.source.setChar(var0, var1);
        return this;
    }

    public PacketDataSerializer setFloat(int var0, float var1) {
        this.source.setFloat(var0, var1);
        return this;
    }

    public PacketDataSerializer setDouble(int var0, double var1) {
        this.source.setDouble(var0, var1);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, ByteBuf var1) {
        this.source.setBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, ByteBuf var1, int var2) {
        this.source.setBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, ByteBuf var1, int var2, int var3) {
        this.source.setBytes(var0, var1, var2, var3);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, byte[] var1) {
        this.source.setBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, byte[] var1, int var2, int var3) {
        this.source.setBytes(var0, var1, var2, var3);
        return this;
    }

    public PacketDataSerializer setBytes(int var0, ByteBuffer var1) {
        this.source.setBytes(var0, var1);
        return this;
    }

    public int setBytes(int var0, InputStream var1, int var2) throws IOException {
        return this.source.setBytes(var0, var1, var2);
    }

    public int setBytes(int var0, ScatteringByteChannel var1, int var2) throws IOException {
        return this.source.setBytes(var0, var1, var2);
    }

    public int setBytes(int var0, FileChannel var1, long var2, int var4) throws IOException {
        return this.source.setBytes(var0, var1, var2, var4);
    }

    public PacketDataSerializer setZero(int var0, int var1) {
        this.source.setZero(var0, var1);
        return this;
    }

    public int setCharSequence(int var0, CharSequence var1, Charset var2) {
        return this.source.setCharSequence(var0, var1, var2);
    }

    public boolean readBoolean() {
        return this.source.readBoolean();
    }

    public byte readByte() {
        return this.source.readByte();
    }

    public short readUnsignedByte() {
        return this.source.readUnsignedByte();
    }

    public short readShort() {
        return this.source.readShort();
    }

    public short readShortLE() {
        return this.source.readShortLE();
    }

    public int readUnsignedShort() {
        return this.source.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.source.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.source.readMedium();
    }

    public int readMediumLE() {
        return this.source.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.source.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.source.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.source.readInt();
    }

    public int readIntLE() {
        return this.source.readIntLE();
    }

    public long readUnsignedInt() {
        return this.source.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.source.readUnsignedIntLE();
    }

    public long readLong() {
        return this.source.readLong();
    }

    public long readLongLE() {
        return this.source.readLongLE();
    }

    public char readChar() {
        return this.source.readChar();
    }

    public float readFloat() {
        return this.source.readFloat();
    }

    public double readDouble() {
        return this.source.readDouble();
    }

    public ByteBuf readBytes(int var0) {
        return this.source.readBytes(var0);
    }

    public ByteBuf readSlice(int var0) {
        return this.source.readSlice(var0);
    }

    public ByteBuf readRetainedSlice(int var0) {
        return this.source.readRetainedSlice(var0);
    }

    public PacketDataSerializer readBytes(ByteBuf var0) {
        this.source.readBytes(var0);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuf var0, int var1) {
        this.source.readBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuf var0, int var1, int var2) {
        this.source.readBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer readBytes(byte[] var0) {
        this.source.readBytes(var0);
        return this;
    }

    public PacketDataSerializer readBytes(byte[] var0, int var1, int var2) {
        this.source.readBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuffer var0) {
        this.source.readBytes(var0);
        return this;
    }

    public PacketDataSerializer readBytes(OutputStream var0, int var1) throws IOException {
        this.source.readBytes(var0, var1);
        return this;
    }

    public int readBytes(GatheringByteChannel var0, int var1) throws IOException {
        return this.source.readBytes(var0, var1);
    }

    public CharSequence readCharSequence(int var0, Charset var1) {
        return this.source.readCharSequence(var0, var1);
    }

    public String readString(int var0, Charset var1) {
        return this.source.readString(var0, var1);
    }

    public int readBytes(FileChannel var0, long var1, int var3) throws IOException {
        return this.source.readBytes(var0, var1, var3);
    }

    public PacketDataSerializer skipBytes(int var0) {
        this.source.skipBytes(var0);
        return this;
    }

    public PacketDataSerializer writeBoolean(boolean var0) {
        this.source.writeBoolean(var0);
        return this;
    }

    public PacketDataSerializer writeByte(int var0) {
        this.source.writeByte(var0);
        return this;
    }

    public PacketDataSerializer writeShort(int var0) {
        this.source.writeShort(var0);
        return this;
    }

    public PacketDataSerializer writeShortLE(int var0) {
        this.source.writeShortLE(var0);
        return this;
    }

    public PacketDataSerializer writeMedium(int var0) {
        this.source.writeMedium(var0);
        return this;
    }

    public PacketDataSerializer writeMediumLE(int var0) {
        this.source.writeMediumLE(var0);
        return this;
    }

    public PacketDataSerializer writeInt(int var0) {
        this.source.writeInt(var0);
        return this;
    }

    public PacketDataSerializer writeIntLE(int var0) {
        this.source.writeIntLE(var0);
        return this;
    }

    public PacketDataSerializer writeLong(long var0) {
        this.source.writeLong(var0);
        return this;
    }

    public PacketDataSerializer writeLongLE(long var0) {
        this.source.writeLongLE(var0);
        return this;
    }

    public PacketDataSerializer writeChar(int var0) {
        this.source.writeChar(var0);
        return this;
    }

    public PacketDataSerializer writeFloat(float var0) {
        this.source.writeFloat(var0);
        return this;
    }

    public PacketDataSerializer writeDouble(double var0) {
        this.source.writeDouble(var0);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf var0) {
        this.source.writeBytes(var0);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf var0, int var1) {
        this.source.writeBytes(var0, var1);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf var0, int var1, int var2) {
        this.source.writeBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer writeBytes(byte[] var0) {
        this.source.writeBytes(var0);
        return this;
    }

    public PacketDataSerializer writeBytes(byte[] var0, int var1, int var2) {
        this.source.writeBytes(var0, var1, var2);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuffer var0) {
        this.source.writeBytes(var0);
        return this;
    }

    public int writeBytes(InputStream var0, int var1) throws IOException {
        return this.source.writeBytes(var0, var1);
    }

    public int writeBytes(ScatteringByteChannel var0, int var1) throws IOException {
        return this.source.writeBytes(var0, var1);
    }

    public int writeBytes(FileChannel var0, long var1, int var3) throws IOException {
        return this.source.writeBytes(var0, var1, var3);
    }

    public PacketDataSerializer writeZero(int var0) {
        this.source.writeZero(var0);
        return this;
    }

    public int writeCharSequence(CharSequence var0, Charset var1) {
        return this.source.writeCharSequence(var0, var1);
    }

    public int indexOf(int var0, int var1, byte var2) {
        return this.source.indexOf(var0, var1, var2);
    }

    public int bytesBefore(byte var0) {
        return this.source.bytesBefore(var0);
    }

    public int bytesBefore(int var0, byte var1) {
        return this.source.bytesBefore(var0, var1);
    }

    public int bytesBefore(int var0, int var1, byte var2) {
        return this.source.bytesBefore(var0, var1, var2);
    }

    public int forEachByte(ByteProcessor var0) {
        return this.source.forEachByte(var0);
    }

    public int forEachByte(int var0, int var1, ByteProcessor var2) {
        return this.source.forEachByte(var0, var1, var2);
    }

    public int forEachByteDesc(ByteProcessor var0) {
        return this.source.forEachByteDesc(var0);
    }

    public int forEachByteDesc(int var0, int var1, ByteProcessor var2) {
        return this.source.forEachByteDesc(var0, var1, var2);
    }

    public ByteBuf copy() {
        return this.source.copy();
    }

    public ByteBuf copy(int var0, int var1) {
        return this.source.copy(var0, var1);
    }

    public ByteBuf slice() {
        return this.source.slice();
    }

    public ByteBuf retainedSlice() {
        return this.source.retainedSlice();
    }

    public ByteBuf slice(int var0, int var1) {
        return this.source.slice(var0, var1);
    }

    public ByteBuf retainedSlice(int var0, int var1) {
        return this.source.retainedSlice(var0, var1);
    }

    public ByteBuf duplicate() {
        return this.source.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.source.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.source.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.source.nioBuffer();
    }

    public ByteBuffer nioBuffer(int var0, int var1) {
        return this.source.nioBuffer(var0, var1);
    }

    public ByteBuffer internalNioBuffer(int var0, int var1) {
        return this.source.internalNioBuffer(var0, var1);
    }

    public ByteBuffer[] nioBuffers() {
        return this.source.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int var0, int var1) {
        return this.source.nioBuffers(var0, var1);
    }

    public boolean hasArray() {
        return this.source.hasArray();
    }

    public byte[] array() {
        return this.source.array();
    }

    public int arrayOffset() {
        return this.source.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.source.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.source.memoryAddress();
    }

    public String toString(Charset var0) {
        return this.source.toString(var0);
    }

    public String toString(int var0, int var1, Charset var2) {
        return this.source.toString(var0, var1, var2);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object var0) {
        return this.source.equals(var0);
    }

    public int compareTo(ByteBuf var0) {
        return this.source.compareTo(var0);
    }

    public String toString() {
        return this.source.toString();
    }

    public PacketDataSerializer retain(int var0) {
        this.source.retain(var0);
        return this;
    }

    public PacketDataSerializer retain() {
        this.source.retain();
        return this;
    }

    public PacketDataSerializer touch() {
        this.source.touch();
        return this;
    }

    public PacketDataSerializer touch(Object var0) {
        this.source.touch(var0);
        return this;
    }

    public int refCnt() {
        return this.source.refCnt();
    }

    public boolean release() {
        return this.source.release();
    }

    public boolean release(int var0) {
        return this.source.release(var0);
    }

    public /* synthetic */ ByteBuf touch(Object object) {
        return this.touch(object);
    }

    public /* synthetic */ ByteBuf touch() {
        return this.touch();
    }

    public /* synthetic */ ByteBuf retain() {
        return this.retain();
    }

    public /* synthetic */ ByteBuf retain(int n2) {
        return this.retain(n2);
    }

    public /* synthetic */ ByteBuf writeZero(int n2) {
        return this.writeZero(n2);
    }

    public /* synthetic */ ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.writeBytes(byteBuffer);
    }

    public /* synthetic */ ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        return this.writeBytes(byArray, n2, n3);
    }

    public /* synthetic */ ByteBuf writeBytes(byte[] byArray) {
        return this.writeBytes(byArray);
    }

    public /* synthetic */ ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.writeBytes(byteBuf, n2, n3);
    }

    public /* synthetic */ ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        return this.writeBytes(byteBuf, n2);
    }

    public /* synthetic */ ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.writeBytes(byteBuf);
    }

    public /* synthetic */ ByteBuf writeDouble(double d2) {
        return this.writeDouble(d2);
    }

    public /* synthetic */ ByteBuf writeFloat(float f2) {
        return this.writeFloat(f2);
    }

    public /* synthetic */ ByteBuf writeChar(int n2) {
        return this.writeChar(n2);
    }

    public /* synthetic */ ByteBuf writeLongLE(long l2) {
        return this.writeLongLE(l2);
    }

    public /* synthetic */ ByteBuf writeLong(long l2) {
        return this.writeLong(l2);
    }

    public /* synthetic */ ByteBuf writeIntLE(int n2) {
        return this.writeIntLE(n2);
    }

    public /* synthetic */ ByteBuf writeInt(int n2) {
        return this.writeInt(n2);
    }

    public /* synthetic */ ByteBuf writeMediumLE(int n2) {
        return this.writeMediumLE(n2);
    }

    public /* synthetic */ ByteBuf writeMedium(int n2) {
        return this.writeMedium(n2);
    }

    public /* synthetic */ ByteBuf writeShortLE(int n2) {
        return this.writeShortLE(n2);
    }

    public /* synthetic */ ByteBuf writeShort(int n2) {
        return this.writeShort(n2);
    }

    public /* synthetic */ ByteBuf writeByte(int n2) {
        return this.writeByte(n2);
    }

    public /* synthetic */ ByteBuf writeBoolean(boolean bl) {
        return this.writeBoolean(bl);
    }

    public /* synthetic */ ByteBuf skipBytes(int n2) {
        return this.skipBytes(n2);
    }

    public /* synthetic */ ByteBuf readBytes(OutputStream outputStream, int n2) throws IOException {
        return this.readBytes(outputStream, n2);
    }

    public /* synthetic */ ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.readBytes(byteBuffer);
    }

    public /* synthetic */ ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        return this.readBytes(byArray, n2, n3);
    }

    public /* synthetic */ ByteBuf readBytes(byte[] byArray) {
        return this.readBytes(byArray);
    }

    public /* synthetic */ ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.readBytes(byteBuf, n2, n3);
    }

    public /* synthetic */ ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        return this.readBytes(byteBuf, n2);
    }

    public /* synthetic */ ByteBuf readBytes(ByteBuf byteBuf) {
        return this.readBytes(byteBuf);
    }

    public /* synthetic */ ByteBuf setZero(int n2, int n3) {
        return this.setZero(n2, n3);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        return this.setBytes(n2, byteBuffer);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.setBytes(n2, byArray, n3, n4);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, byte[] byArray) {
        return this.setBytes(n2, byArray);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.setBytes(n2, byteBuf, n3, n4);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        return this.setBytes(n2, byteBuf, n3);
    }

    public /* synthetic */ ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        return this.setBytes(n2, byteBuf);
    }

    public /* synthetic */ ByteBuf setDouble(int n2, double d2) {
        return this.setDouble(n2, d2);
    }

    public /* synthetic */ ByteBuf setFloat(int n2, float f2) {
        return this.setFloat(n2, f2);
    }

    public /* synthetic */ ByteBuf setChar(int n2, int n3) {
        return this.setChar(n2, n3);
    }

    public /* synthetic */ ByteBuf setLongLE(int n2, long l2) {
        return this.setLongLE(n2, l2);
    }

    public /* synthetic */ ByteBuf setLong(int n2, long l2) {
        return this.setLong(n2, l2);
    }

    public /* synthetic */ ByteBuf setIntLE(int n2, int n3) {
        return this.setIntLE(n2, n3);
    }

    public /* synthetic */ ByteBuf setInt(int n2, int n3) {
        return this.setInt(n2, n3);
    }

    public /* synthetic */ ByteBuf setMediumLE(int n2, int n3) {
        return this.setMediumLE(n2, n3);
    }

    public /* synthetic */ ByteBuf setMedium(int n2, int n3) {
        return this.setMedium(n2, n3);
    }

    public /* synthetic */ ByteBuf setShortLE(int n2, int n3) {
        return this.setShortLE(n2, n3);
    }

    public /* synthetic */ ByteBuf setShort(int n2, int n3) {
        return this.setShort(n2, n3);
    }

    public /* synthetic */ ByteBuf setByte(int n2, int n3) {
        return this.setByte(n2, n3);
    }

    public /* synthetic */ ByteBuf setBoolean(int n2, boolean bl) {
        return this.setBoolean(n2, bl);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, OutputStream outputStream, int n3) throws IOException {
        return this.getBytes(n2, outputStream, n3);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        return this.getBytes(n2, byteBuffer);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.getBytes(n2, byArray, n3, n4);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, byte[] byArray) {
        return this.getBytes(n2, byArray);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.getBytes(n2, byteBuf, n3, n4);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        return this.getBytes(n2, byteBuf, n3);
    }

    public /* synthetic */ ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        return this.getBytes(n2, byteBuf);
    }

    public /* synthetic */ ByteBuf ensureWritable(int n2) {
        return this.ensureWritable(n2);
    }

    public /* synthetic */ ByteBuf discardSomeReadBytes() {
        return this.discardSomeReadBytes();
    }

    public /* synthetic */ ByteBuf discardReadBytes() {
        return this.discardReadBytes();
    }

    public /* synthetic */ ByteBuf resetWriterIndex() {
        return this.resetWriterIndex();
    }

    public /* synthetic */ ByteBuf markWriterIndex() {
        return this.markWriterIndex();
    }

    public /* synthetic */ ByteBuf resetReaderIndex() {
        return this.resetReaderIndex();
    }

    public /* synthetic */ ByteBuf markReaderIndex() {
        return this.markReaderIndex();
    }

    public /* synthetic */ ByteBuf clear() {
        return this.clear();
    }

    public /* synthetic */ ByteBuf setIndex(int n2, int n3) {
        return this.setIndex(n2, n3);
    }

    public /* synthetic */ ByteBuf writerIndex(int n2) {
        return this.writerIndex(n2);
    }

    public /* synthetic */ ByteBuf readerIndex(int n2) {
        return this.readerIndex(n2);
    }

    public /* synthetic */ ByteBuf capacity(int n2) {
        return this.capacity(n2);
    }

    public /* synthetic */ ReferenceCounted touch(Object object) {
        return this.touch(object);
    }

    public /* synthetic */ ReferenceCounted touch() {
        return this.touch();
    }

    public /* synthetic */ ReferenceCounted retain(int n2) {
        return this.retain(n2);
    }

    public /* synthetic */ ReferenceCounted retain() {
        return this.retain();
    }
}

