/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder<T extends PacketListener>
extends ByteToMessageDecoder
implements ProtocolSwapHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ProtocolInfo<T> protocolInfo;

    public PacketDecoder(ProtocolInfo<T> var0) {
        this.protocolInfo = var0;
    }

    protected void decode(ChannelHandlerContext var0, ByteBuf var1, List<Object> var2) throws Exception {
        Packet var4;
        int var3 = var1.readableBytes();
        try {
            var4 = (Packet)this.protocolInfo.codec().decode(var1);
        }
        catch (Exception var5) {
            if (var5 instanceof SkipEncodeException) {
                var1.skipBytes(var1.readableBytes());
            }
            throw var5;
        }
        PacketType var5 = var4.type();
        JvmProfiler.INSTANCE.onPacketReceived(this.protocolInfo.id(), var5, var0.channel().remoteAddress(), var3);
        if (var1.readableBytes() > 0) {
            throw new IOException("Packet " + this.protocolInfo.id().id() + "/" + String.valueOf(var5) + " (" + var4.getClass().getSimpleName() + ") was larger than I expected, found " + var1.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(var5));
        }
        var2.add(var4);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(NetworkManager.PACKET_RECEIVED_MARKER, " IN: [{}:{}] {} -> {} bytes", new Object[]{this.protocolInfo.id().id(), var5, var4.getClass().getName(), var3});
        }
        ProtocolSwapHandler.handleInboundTerminalPacket(var0, var4);
    }
}

