/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.VarInt;
import org.jspecify.annotations.Nullable;

public class PacketSplitter
extends ByteToMessageDecoder {
    private static final int MAX_VARINT21_BYTES = 3;
    private final ByteBuf helperBuf = Unpooled.directBuffer((int)3);
    private final @Nullable BandwidthDebugMonitor monitor;

    public PacketSplitter(@Nullable BandwidthDebugMonitor var0) {
        this.monitor = var0;
    }

    protected void handlerRemoved0(ChannelHandlerContext var0) {
        this.helperBuf.release();
    }

    private static boolean copyVarint(ByteBuf var0, ByteBuf var1) {
        for (int var2 = 0; var2 < 3; ++var2) {
            if (!var0.isReadable()) {
                return false;
            }
            byte var3 = var0.readByte();
            var1.writeByte((int)var3);
            if (VarInt.hasContinuationBit(var3)) continue;
            return true;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }

    protected void decode(ChannelHandlerContext var0, ByteBuf var1, List<Object> var2) {
        var1.markReaderIndex();
        this.helperBuf.clear();
        if (!PacketSplitter.copyVarint(var1, this.helperBuf)) {
            var1.resetReaderIndex();
            return;
        }
        int var3 = VarInt.read(this.helperBuf);
        if (var3 == 0) {
            throw new CorruptedFrameException("Frame length cannot be zero");
        }
        if (var1.readableBytes() < var3) {
            var1.resetReaderIndex();
            return;
        }
        if (this.monitor != null) {
            this.monitor.onReceive(var3 + VarInt.getByteSize(var3));
        }
        var2.add(var1.readBytes(var3));
    }
}

