/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenTrackedEntry;
import net.minecraft.network.chat.MessageSignature;
import org.jspecify.annotations.Nullable;

public class LastSeenMessagesValidator {
    private final int lastSeenCount;
    private final ObjectList<LastSeenTrackedEntry> trackedMessages = new ObjectArrayList();
    private @Nullable MessageSignature lastPendingMessage;

    public LastSeenMessagesValidator(int var0) {
        this.lastSeenCount = var0;
        for (int var1 = 0; var1 < var0; ++var1) {
            this.trackedMessages.add(null);
        }
    }

    public void addPending(MessageSignature var0) {
        if (!var0.equals(this.lastPendingMessage)) {
            this.trackedMessages.add((Object)new LastSeenTrackedEntry(var0, true));
            this.lastPendingMessage = var0;
        }
    }

    public int trackedMessagesCount() {
        return this.trackedMessages.size();
    }

    public void applyOffset(int var0) throws a {
        int var1 = this.trackedMessages.size() - this.lastSeenCount;
        if (var0 < 0 || var0 > var1) {
            throw new a("Advanced last seen window by " + var0 + " messages, but expected at most " + var1);
        }
        this.trackedMessages.removeElements(0, var0);
    }

    public LastSeenMessages applyUpdate(LastSeenMessages.b var0) throws a {
        this.applyOffset(var0.offset());
        ObjectArrayList var1 = new ObjectArrayList(var0.acknowledged().cardinality());
        if (var0.acknowledged().length() > this.lastSeenCount) {
            throw new a("Last seen update contained " + var0.acknowledged().length() + " messages, but maximum window size is " + this.lastSeenCount);
        }
        for (int var2 = 0; var2 < this.lastSeenCount; ++var2) {
            boolean var3 = var0.acknowledged().get(var2);
            LastSeenTrackedEntry var4 = (LastSeenTrackedEntry)this.trackedMessages.get(var2);
            if (var3) {
                if (var4 == null) {
                    throw new a("Last seen update acknowledged unknown or previously ignored message at index " + var2);
                }
                this.trackedMessages.set(var2, (Object)var4.acknowledge());
                var1.add((Object)var4.signature());
                continue;
            }
            if (var4 != null && !var4.pending()) {
                throw new a("Last seen update ignored previously acknowledged message at index " + var2 + " and signature " + String.valueOf(var4.signature()));
            }
            this.trackedMessages.set(var2, null);
        }
        LastSeenMessages var2 = new LastSeenMessages((List<MessageSignature>)var1);
        if (!var0.verifyChecksum(var2)) {
            throw new a("Checksum mismatch on last seen update: the client and server must have desynced");
        }
        return var2;
    }

    public static class a
    extends Exception {
        public a(String var0) {
            super(var0);
        }
    }
}

