/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import org.jspecify.annotations.Nullable;

public class ClientboundLevelChunkPacketData {
    private static final StreamCodec<ByteBuf, Map<HeightMap.Type, long[]>> HEIGHTMAPS_STREAM_CODEC = ByteBufCodecs.map(var0 -> new EnumMap(HeightMap.Type.class), HeightMap.Type.STREAM_CODEC, ByteBufCodecs.LONG_ARRAY);
    private static final int TWO_MEGABYTES = 0x200000;
    private final Map<HeightMap.Type, long[]> heightmaps;
    private final byte[] buffer;
    private final List<a> blockEntitiesData;

    public ClientboundLevelChunkPacketData(Chunk var02) {
        this.heightmaps = var02.getHeightmaps().stream().filter(var0 -> ((HeightMap.Type)var0.getKey()).sendToClient()).collect(Collectors.toMap(Map.Entry::getKey, var0 -> (long[])((HeightMap)var0.getValue()).getRawData().clone()));
        this.buffer = new byte[ClientboundLevelChunkPacketData.calculateChunkSize(var02)];
        ClientboundLevelChunkPacketData.extractChunkData(new PacketDataSerializer(this.getWriteBuffer()), var02);
        this.blockEntitiesData = Lists.newArrayList();
        for (Map.Entry<BlockPosition, TileEntity> var2 : var02.getBlockEntities().entrySet()) {
            this.blockEntitiesData.add(a.create(var2.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf var0, int var1, int var2) {
        this.heightmaps = (Map)HEIGHTMAPS_STREAM_CODEC.decode(var0);
        int var3 = var0.readVarInt();
        if (var3 > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[var3];
        var0.readBytes(this.buffer);
        this.blockEntitiesData = (List)a.LIST_STREAM_CODEC.decode(var0);
    }

    public void write(RegistryFriendlyByteBuf var0) {
        HEIGHTMAPS_STREAM_CODEC.encode(var0, this.heightmaps);
        var0.writeVarInt(this.buffer.length);
        var0.writeBytes(this.buffer);
        a.LIST_STREAM_CODEC.encode(var0, this.blockEntitiesData);
    }

    private static int calculateChunkSize(Chunk var0) {
        int var1 = 0;
        for (ChunkSection var5 : var0.getSections()) {
            var1 += var5.getSerializedSize();
        }
        return var1;
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf var0 = Unpooled.wrappedBuffer((byte[])this.buffer);
        var0.writerIndex(0);
        return var0;
    }

    public static void extractChunkData(PacketDataSerializer var0, Chunk var1) {
        for (ChunkSection var5 : var1.getSections()) {
            var5.write(var0);
        }
        if (var0.writerIndex() != var0.capacity()) {
            throw new IllegalStateException("Didn't fill chunk buffer: expected " + var0.capacity() + " bytes, got " + var0.writerIndex());
        }
    }

    public Consumer<b> getBlockEntitiesTagsConsumer(int var0, int var1) {
        return var2 -> this.getBlockEntitiesTags((b)var2, var0, var1);
    }

    private void getBlockEntitiesTags(b var0, int var1, int var2) {
        int var3 = 16 * var1;
        int var4 = 16 * var2;
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (a var7 : this.blockEntitiesData) {
            int var8 = var3 + SectionPosition.sectionRelative(var7.packedXZ >> 4);
            int var9 = var4 + SectionPosition.sectionRelative(var7.packedXZ);
            var5.set(var8, var7.y, var9);
            var0.accept(var5, var7.type, var7.tag);
        }
    }

    public PacketDataSerializer getReadBuffer() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    public Map<HeightMap.Type, long[]> getHeightmaps() {
        return this.heightmaps;
    }

    static class a {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.ofMember(a::write, a::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<a>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        final int packedXZ;
        final int y;
        final TileEntityTypes<?> type;
        final @Nullable NBTTagCompound tag;

        private a(int var0, int var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3) {
            this.packedXZ = var0;
            this.y = var1;
            this.type = var2;
            this.tag = var3;
        }

        private a(RegistryFriendlyByteBuf var0) {
            this.packedXZ = var0.readByte();
            this.y = var0.readShort();
            this.type = (TileEntityTypes)ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).decode(var0);
            this.tag = var0.readNbt();
        }

        private void write(RegistryFriendlyByteBuf var0) {
            var0.writeByte(this.packedXZ);
            var0.writeShort(this.y);
            ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).encode(var0, this.type);
            var0.writeNbt(this.tag);
        }

        static a create(TileEntity var0) {
            NBTTagCompound var1 = var0.getUpdateTag(var0.getLevel().registryAccess());
            BlockPosition var2 = var0.getBlockPos();
            int var3 = SectionPosition.sectionRelative(var2.getX()) << 4 | SectionPosition.sectionRelative(var2.getZ());
            return new a(var3, var2.getY(), var0.getType(), var1.isEmpty() ? null : var1);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

