/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.EnumHand;

public class PacketPlayInBlockPlace
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInBlockPlace> STREAM_CODEC = Packet.codec(PacketPlayInBlockPlace::write, PacketPlayInBlockPlace::new);
    private final EnumHand hand;
    private final int sequence;
    private final float yRot;
    private final float xRot;

    public PacketPlayInBlockPlace(EnumHand var0, int var1, float var2, float var3) {
        this.hand = var0;
        this.sequence = var1;
        this.yRot = var2;
        this.xRot = var3;
    }

    private PacketPlayInBlockPlace(PacketDataSerializer var0) {
        this.hand = var0.readEnum(EnumHand.class);
        this.sequence = var0.readVarInt();
        this.yRot = var0.readFloat();
        this.xRot = var0.readFloat();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeEnum(this.hand);
        var0.writeVarInt(this.sequence);
        var0.writeFloat(this.yRot);
        var0.writeFloat(this.xRot);
    }

    @Override
    public PacketType<PacketPlayInBlockPlace> type() {
        return GamePacketTypes.SERVERBOUND_USE_ITEM;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleUseItem(this);
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public int getSequence() {
        return this.sequence;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }
}

