/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.phys.Vec3D;

public abstract class PacketPlayInFlying
implements Packet<PacketListenerPlayIn> {
    private static final int FLAG_ON_GROUND = 1;
    private static final int FLAG_HORIZONTAL_COLLISION = 2;
    public final double x;
    public final double y;
    public final double z;
    public final float yRot;
    public final float xRot;
    protected final boolean onGround;
    protected final boolean horizontalCollision;
    public final boolean hasPos;
    public final boolean hasRot;

    static int packFlags(boolean var0, boolean var1) {
        int var2 = 0;
        if (var0) {
            var2 |= 1;
        }
        if (var1) {
            var2 |= 2;
        }
        return var2;
    }

    static boolean unpackOnGround(int var0) {
        return (var0 & 1) != 0;
    }

    static boolean unpackHorizontalCollision(int var0) {
        return (var0 & 2) != 0;
    }

    protected PacketPlayInFlying(double var0, double var2, double var4, float var6, float var7, boolean var8, boolean var9, boolean var10, boolean var11) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.yRot = var6;
        this.xRot = var7;
        this.onGround = var8;
        this.horizontalCollision = var9;
        this.hasPos = var10;
        this.hasRot = var11;
    }

    @Override
    public abstract PacketType<? extends PacketPlayInFlying> type();

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleMovePlayer(this);
    }

    public double getX(double var0) {
        return this.hasPos ? this.x : var0;
    }

    public double getY(double var0) {
        return this.hasPos ? this.y : var0;
    }

    public double getZ(double var0) {
        return this.hasPos ? this.z : var0;
    }

    public float getYRot(float var0) {
        return this.hasRot ? this.yRot : var0;
    }

    public float getXRot(float var0) {
        return this.hasRot ? this.xRot : var0;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean horizontalCollision() {
        return this.horizontalCollision;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class d
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, d> STREAM_CODEC = Packet.codec(d::write, d::read);

        public d(boolean var0, boolean var1) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, var0, var1, false, false);
        }

        private static d read(PacketDataSerializer var0) {
            short var1 = var0.readUnsignedByte();
            boolean var2 = PacketPlayInFlying.unpackOnGround(var1);
            boolean var3 = PacketPlayInFlying.unpackHorizontalCollision(var1);
            return new d(var2, var3);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeByte(PacketPlayInFlying.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<d> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class PacketPlayInLook
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInLook> STREAM_CODEC = Packet.codec(PacketPlayInLook::write, PacketPlayInLook::read);

        public PacketPlayInLook(float var0, float var1, boolean var2, boolean var3) {
            super(0.0, 0.0, 0.0, var0, var1, var2, var3, false, true);
        }

        private static PacketPlayInLook read(PacketDataSerializer var0) {
            float var1 = var0.readFloat();
            float var2 = var0.readFloat();
            short var3 = var0.readUnsignedByte();
            boolean var4 = PacketPlayInFlying.unpackOnGround(var3);
            boolean var5 = PacketPlayInFlying.unpackHorizontalCollision(var3);
            return new PacketPlayInLook(var1, var2, var4, var5);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(PacketPlayInFlying.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<PacketPlayInLook> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class PacketPlayInPosition
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInPosition> STREAM_CODEC = Packet.codec(PacketPlayInPosition::write, PacketPlayInPosition::read);

        public PacketPlayInPosition(Vec3D var0, boolean var1, boolean var2) {
            super(var0.x, var0.y, var0.z, 0.0f, 0.0f, var1, var2, true, false);
        }

        public PacketPlayInPosition(double var0, double var2, double var4, boolean var6, boolean var7) {
            super(var0, var2, var4, 0.0f, 0.0f, var6, var7, true, false);
        }

        private static PacketPlayInPosition read(PacketDataSerializer var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            short var7 = var0.readUnsignedByte();
            boolean var8 = PacketPlayInFlying.unpackOnGround(var7);
            boolean var9 = PacketPlayInFlying.unpackHorizontalCollision(var7);
            return new PacketPlayInPosition(var1, var3, var5, var8, var9);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeByte(PacketPlayInFlying.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<PacketPlayInPosition> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PacketPlayInPositionLook
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInPositionLook> STREAM_CODEC = Packet.codec(PacketPlayInPositionLook::write, PacketPlayInPositionLook::read);

        public PacketPlayInPositionLook(Vec3D var0, float var1, float var2, boolean var3, boolean var4) {
            super(var0.x, var0.y, var0.z, var1, var2, var3, var4, true, true);
        }

        public PacketPlayInPositionLook(double var0, double var2, double var4, float var6, float var7, boolean var8, boolean var9) {
            super(var0, var2, var4, var6, var7, var8, var9, true, true);
        }

        private static PacketPlayInPositionLook read(PacketDataSerializer var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            float var7 = var0.readFloat();
            float var8 = var0.readFloat();
            short var9 = var0.readUnsignedByte();
            boolean var10 = PacketPlayInFlying.unpackOnGround(var9);
            boolean var11 = PacketPlayInFlying.unpackHorizontalCollision(var9);
            return new PacketPlayInPositionLook(var1, var3, var5, var7, var8, var10, var11);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(PacketPlayInFlying.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<PacketPlayInPositionLook> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

