/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public abstract class PacketPlayOutEntity
implements Packet<PacketListenerPlayOut> {
    protected final int entityId;
    protected final short xa;
    protected final short ya;
    protected final short za;
    protected final byte yRot;
    protected final byte xRot;
    protected final boolean onGround;
    protected final boolean hasRot;
    protected final boolean hasPos;

    protected PacketPlayOutEntity(int var0, short var1, short var2, short var3, byte var4, byte var5, boolean var6, boolean var7, boolean var8) {
        this.entityId = var0;
        this.xa = var1;
        this.ya = var2;
        this.za = var3;
        this.yRot = var4;
        this.xRot = var5;
        this.onGround = var6;
        this.hasRot = var7;
        this.hasPos = var8;
    }

    @Override
    public abstract PacketType<? extends PacketPlayOutEntity> type();

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMoveEntity(this);
    }

    public String toString() {
        return "Entity_" + super.toString();
    }

    public @Nullable Entity getEntity(World var0) {
        return var0.getEntity(this.entityId);
    }

    public short getXa() {
        return this.xa;
    }

    public short getYa() {
        return this.ya;
    }

    public short getZa() {
        return this.za;
    }

    public float getYRot() {
        return MathHelper.unpackDegrees(this.yRot);
    }

    public float getXRot() {
        return MathHelper.unpackDegrees(this.xRot);
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public static class PacketPlayOutEntityLook
    extends PacketPlayOutEntity {
        public static final StreamCodec<PacketDataSerializer, PacketPlayOutEntityLook> STREAM_CODEC = Packet.codec(PacketPlayOutEntityLook::write, PacketPlayOutEntityLook::read);

        public PacketPlayOutEntityLook(int var0, byte var1, byte var2, boolean var3) {
            super(var0, (short)0, (short)0, (short)0, var1, var2, var3, true, false);
        }

        private static PacketPlayOutEntityLook read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            byte var2 = var0.readByte();
            byte var3 = var0.readByte();
            boolean var4 = var0.readBoolean();
            return new PacketPlayOutEntityLook(var1, var2, var3, var4);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeByte(this.yRot);
            var0.writeByte(this.xRot);
            var0.writeBoolean(this.onGround);
        }

        @Override
        public PacketType<PacketPlayOutEntityLook> type() {
            return GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_ROT;
        }
    }

    public static class PacketPlayOutRelEntityMove
    extends PacketPlayOutEntity {
        public static final StreamCodec<PacketDataSerializer, PacketPlayOutRelEntityMove> STREAM_CODEC = Packet.codec(PacketPlayOutRelEntityMove::write, PacketPlayOutRelEntityMove::read);

        public PacketPlayOutRelEntityMove(int var0, short var1, short var2, short var3, boolean var4) {
            super(var0, var1, var2, var3, (byte)0, (byte)0, var4, false, true);
        }

        private static PacketPlayOutRelEntityMove read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            short var2 = var0.readShort();
            short var3 = var0.readShort();
            short var4 = var0.readShort();
            boolean var5 = var0.readBoolean();
            return new PacketPlayOutRelEntityMove(var1, var2, var3, var4, var5);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeShort(this.xa);
            var0.writeShort(this.ya);
            var0.writeShort(this.za);
            var0.writeBoolean(this.onGround);
        }

        @Override
        public PacketType<PacketPlayOutRelEntityMove> type() {
            return GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_POS;
        }
    }

    public static class PacketPlayOutRelEntityMoveLook
    extends PacketPlayOutEntity {
        public static final StreamCodec<PacketDataSerializer, PacketPlayOutRelEntityMoveLook> STREAM_CODEC = Packet.codec(PacketPlayOutRelEntityMoveLook::write, PacketPlayOutRelEntityMoveLook::read);

        public PacketPlayOutRelEntityMoveLook(int var0, short var1, short var2, short var3, byte var4, byte var5, boolean var6) {
            super(var0, var1, var2, var3, var4, var5, var6, true, true);
        }

        private static PacketPlayOutRelEntityMoveLook read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            short var2 = var0.readShort();
            short var3 = var0.readShort();
            short var4 = var0.readShort();
            byte var5 = var0.readByte();
            byte var6 = var0.readByte();
            boolean var7 = var0.readBoolean();
            return new PacketPlayOutRelEntityMoveLook(var1, var2, var3, var4, var5, var6, var7);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.entityId);
            var0.writeShort(this.xa);
            var0.writeShort(this.ya);
            var0.writeShort(this.za);
            var0.writeByte(this.yRot);
            var0.writeByte(this.xRot);
            var0.writeBoolean(this.onGround);
        }

        @Override
        public PacketType<PacketPlayOutRelEntityMoveLook> type() {
            return GamePacketTypes.CLIENTBOUND_MOVE_ENTITY_POS_ROT;
        }
    }
}

