/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public class PacketPlayOutEntityEquipment
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutEntityEquipment> STREAM_CODEC = Packet.codec(PacketPlayOutEntityEquipment::write, PacketPlayOutEntityEquipment::new);
    private static final byte CONTINUE_MASK = -128;
    private final int entity;
    private final List<Pair<EnumItemSlot, ItemStack>> slots;

    public PacketPlayOutEntityEquipment(int var0, List<Pair<EnumItemSlot, ItemStack>> var1) {
        this.entity = var0;
        this.slots = var1;
    }

    private PacketPlayOutEntityEquipment(RegistryFriendlyByteBuf var0) {
        byte var1;
        this.entity = var0.readVarInt();
        this.slots = Lists.newArrayList();
        do {
            var1 = var0.readByte();
            EnumItemSlot var2 = EnumItemSlot.VALUES.get(var1 & 0x7F);
            ItemStack var3 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(var0);
            this.slots.add((Pair<EnumItemSlot, ItemStack>)Pair.of((Object)var2, (Object)var3));
        } while ((var1 & 0xFFFFFF80) != 0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.entity);
        int var1 = this.slots.size();
        for (int var2 = 0; var2 < var1; ++var2) {
            Pair<EnumItemSlot, ItemStack> var3 = this.slots.get(var2);
            EnumItemSlot var4 = (EnumItemSlot)var3.getFirst();
            boolean var5 = var2 != var1 - 1;
            int var6 = var4.ordinal();
            var0.writeByte(var5 ? var6 | 0xFFFFFF80 : var6);
            ItemStack.OPTIONAL_STREAM_CODEC.encode(var0, (ItemStack)var3.getSecond());
        }
    }

    @Override
    public PacketType<PacketPlayOutEntityEquipment> type() {
        return GamePacketTypes.CLIENTBOUND_SET_EQUIPMENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetEquipment(this);
    }

    public int getEntity() {
        return this.entity;
    }

    public List<Pair<EnumItemSlot, ItemStack>> getSlots() {
        return this.slots;
    }
}

