/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.BitSet;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutLightUpdate
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutLightUpdate> STREAM_CODEC = Packet.codec(PacketPlayOutLightUpdate::write, PacketPlayOutLightUpdate::new);
    private final int x;
    private final int z;
    private final ClientboundLightUpdatePacketData lightData;

    public PacketPlayOutLightUpdate(ChunkCoordIntPair var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        this.x = var0.x;
        this.z = var0.z;
        this.lightData = new ClientboundLightUpdatePacketData(var0, var1, var2, var3);
    }

    private PacketPlayOutLightUpdate(PacketDataSerializer var0) {
        this.x = var0.readVarInt();
        this.z = var0.readVarInt();
        this.lightData = new ClientboundLightUpdatePacketData(var0, this.x, this.z);
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.x);
        var0.writeVarInt(this.z);
        this.lightData.write(var0);
    }

    @Override
    public PacketType<PacketPlayOutLightUpdate> type() {
        return GamePacketTypes.CLIENTBOUND_LIGHT_UPDATE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLightUpdatePacket(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ClientboundLightUpdatePacketData getLightData() {
        return this.lightData;
    }
}

