/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutNBTQuery
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutNBTQuery> STREAM_CODEC = Packet.codec(PacketPlayOutNBTQuery::write, PacketPlayOutNBTQuery::new);
    private final int transactionId;
    private final @Nullable NBTTagCompound tag;

    public PacketPlayOutNBTQuery(int var0, @Nullable NBTTagCompound var1) {
        this.transactionId = var0;
        this.tag = var1;
    }

    private PacketPlayOutNBTQuery(PacketDataSerializer var0) {
        this.transactionId = var0.readVarInt();
        this.tag = var0.readNbt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.transactionId);
        var0.writeNbt(this.tag);
    }

    @Override
    public PacketType<PacketPlayOutNBTQuery> type() {
        return GamePacketTypes.CLIENTBOUND_TAG_QUERY;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleTagQueryPacket(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public @Nullable NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }
}

