/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;

public class PacketPlayOutNamedSoundEffect
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutNamedSoundEffect> STREAM_CODEC = Packet.codec(PacketPlayOutNamedSoundEffect::write, PacketPlayOutNamedSoundEffect::new);
    public static final float LOCATION_ACCURACY = 8.0f;
    private final Holder<SoundEffect> sound;
    private final SoundCategory source;
    private final int x;
    private final int y;
    private final int z;
    private final float volume;
    private final float pitch;
    private final long seed;

    public PacketPlayOutNamedSoundEffect(Holder<SoundEffect> var0, SoundCategory var1, double var2, double var4, double var6, float var8, float var9, long var10) {
        this.sound = var0;
        this.source = var1;
        this.x = (int)(var2 * 8.0);
        this.y = (int)(var4 * 8.0);
        this.z = (int)(var6 * 8.0);
        this.volume = var8;
        this.pitch = var9;
        this.seed = var10;
    }

    private PacketPlayOutNamedSoundEffect(RegistryFriendlyByteBuf var0) {
        this.sound = (Holder)SoundEffect.STREAM_CODEC.decode(var0);
        this.source = var0.readEnum(SoundCategory.class);
        this.x = var0.readInt();
        this.y = var0.readInt();
        this.z = var0.readInt();
        this.volume = var0.readFloat();
        this.pitch = var0.readFloat();
        this.seed = var0.readLong();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        SoundEffect.STREAM_CODEC.encode(var0, this.sound);
        var0.writeEnum(this.source);
        var0.writeInt(this.x);
        var0.writeInt(this.y);
        var0.writeInt(this.z);
        var0.writeFloat(this.volume);
        var0.writeFloat(this.pitch);
        var0.writeLong(this.seed);
    }

    @Override
    public PacketType<PacketPlayOutNamedSoundEffect> type() {
        return GamePacketTypes.CLIENTBOUND_SOUND;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSoundEvent(this);
    }

    public Holder<SoundEffect> getSound() {
        return this.sound;
    }

    public SoundCategory getSource() {
        return this.source;
    }

    public double getX() {
        return (float)this.x / 8.0f;
    }

    public double getY() {
        return (float)this.y / 8.0f;
    }

    public double getZ() {
        return (float)this.z / 8.0f;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }
}

