/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.world.phys.Vec3D;

public class VecDeltaCodec {
    private static final double TRUNCATION_STEPS = 4096.0;
    private Vec3D base = Vec3D.ZERO;

    @VisibleForTesting
    static long encode(double var0) {
        return Math.round(var0 * 4096.0);
    }

    @VisibleForTesting
    static double decode(long var0) {
        return (double)var0 / 4096.0;
    }

    public Vec3D decode(long var0, long var2, long var4) {
        if (var0 == 0L && var2 == 0L && var4 == 0L) {
            return this.base;
        }
        double var6 = var0 == 0L ? this.base.x : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.x) + var0);
        double var8 = var2 == 0L ? this.base.y : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.y) + var2);
        double var10 = var4 == 0L ? this.base.z : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.z) + var4);
        return new Vec3D(var6, var8, var10);
    }

    public long encodeX(Vec3D var0) {
        return VecDeltaCodec.encode(var0.x) - VecDeltaCodec.encode(this.base.x);
    }

    public long encodeY(Vec3D var0) {
        return VecDeltaCodec.encode(var0.y) - VecDeltaCodec.encode(this.base.y);
    }

    public long encodeZ(Vec3D var0) {
        return VecDeltaCodec.encode(var0.z) - VecDeltaCodec.encode(this.base.z);
    }

    public Vec3D delta(Vec3D var0) {
        return var0.subtract(this.base);
    }

    public void setBase(Vec3D var0) {
        this.base = var0;
    }

    public Vec3D getBase() {
        return this.base;
    }
}

