/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryPayload;
import net.minecraft.resources.MinecraftKey;

public record PacketLoginOutCustomPayload(int transactionId, CustomQueryPayload payload) implements Packet<PacketLoginOutListener>
{
    public static final StreamCodec<PacketDataSerializer, PacketLoginOutCustomPayload> STREAM_CODEC = Packet.codec(PacketLoginOutCustomPayload::write, PacketLoginOutCustomPayload::new);
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private PacketLoginOutCustomPayload(PacketDataSerializer var0) {
        this(var0.readVarInt(), PacketLoginOutCustomPayload.readPayload(var0.readIdentifier(), var0));
    }

    private static CustomQueryPayload readPayload(MinecraftKey var0, PacketDataSerializer var1) {
        return PacketLoginOutCustomPayload.readUnknownPayload(var0, var1);
    }

    private static DiscardedQueryPayload readUnknownPayload(MinecraftKey var0, PacketDataSerializer var1) {
        int var2 = var1.readableBytes();
        if (var2 < 0 || var2 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        var1.skipBytes(var2);
        return new DiscardedQueryPayload(var0);
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.transactionId);
        var0.writeIdentifier(this.payload.id());
        this.payload.write(var0);
    }

    @Override
    public PacketType<PacketLoginOutCustomPayload> type() {
        return LoginPacketTypes.CLIENTBOUND_CUSTOM_QUERY;
    }

    @Override
    public void handle(PacketLoginOutListener var0) {
        var0.handleCustomQuery(this);
    }
}

