/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BossBattleCustomData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<MinecraftKey, BossBattleCustom.a>> EVENTS_CODEC = Codec.unboundedMap(MinecraftKey.CODEC, BossBattleCustom.a.CODEC);
    private final Map<MinecraftKey, BossBattleCustom> events = Maps.newHashMap();

    public @Nullable BossBattleCustom get(MinecraftKey var0) {
        return this.events.get(var0);
    }

    public BossBattleCustom create(MinecraftKey var0, IChatBaseComponent var1) {
        BossBattleCustom var2 = new BossBattleCustom(var0, var1);
        this.events.put(var0, var2);
        return var2;
    }

    public void remove(BossBattleCustom var0) {
        this.events.remove(var0.getTextId());
    }

    public Collection<MinecraftKey> getIds() {
        return this.events.keySet();
    }

    public Collection<BossBattleCustom> getEvents() {
        return this.events.values();
    }

    public NBTTagCompound save(HolderLookup.a var0) {
        Map<MinecraftKey, BossBattleCustom.a> var1 = SystemUtils.mapValues(this.events, BossBattleCustom::pack);
        return (NBTTagCompound)EVENTS_CODEC.encodeStart(var0.createSerializationContext(DynamicOpsNBT.INSTANCE), var1).getOrThrow();
    }

    public void load(NBTTagCompound var02, HolderLookup.a var12) {
        Map<MinecraftKey, BossBattleCustom.a> var2 = EVENTS_CODEC.parse(var12.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var02).resultOrPartial(var0 -> LOGGER.error("Failed to parse boss bar events: {}", var0)).orElse(Map.of());
        var2.forEach((var0, var1) -> this.events.put((MinecraftKey)var0, BossBattleCustom.load(var0, var1)));
    }

    public void onPlayerConnect(EntityPlayer var0) {
        for (BossBattleCustom var2 : this.events.values()) {
            var2.onPlayerConnect(var0);
        }
    }

    public void onPlayerDisconnect(EntityPlayer var0) {
        for (BossBattleCustom var2 : this.events.values()) {
            var2.onPlayerDisconnect(var0);
        }
    }
}

