/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.phys.Vec3D;

public class CommandParticle {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.particle.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("particle").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("name", ArgumentParticle.particle(var1)).executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ((CommandListenerWrapper)var0.getSource()).getPosition(), Vec3D.ZERO, 0.0f, 0, false, ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), Vec3D.ZERO, 0.0f, 0, false, ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(net.minecraft.commands.CommandDispatcher.argument("delta", ArgumentVec3.vec3(false)).then(net.minecraft.commands.CommandDispatcher.argument("speed", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("force").executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true, ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(net.minecraft.commands.CommandDispatcher.argument("viewers", ArgumentEntity.players()).executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true, ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "viewers")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("normal").executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(net.minecraft.commands.CommandDispatcher.argument("viewers", ArgumentEntity.players()).executes(var0 -> CommandParticle.sendParticles((CommandListenerWrapper)var0.getSource(), ArgumentParticle.getParticle((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "viewers")))))))))));
    }

    private static int sendParticles(CommandListenerWrapper var0, ParticleParam var1, Vec3D var2, Vec3D var3, float var4, int var5, boolean var6, Collection<EntityPlayer> var7) throws CommandSyntaxException {
        int var8 = 0;
        for (EntityPlayer var10 : var7) {
            if (!var0.getLevel().sendParticles(var10, var1, var6, false, var2.x, var2.y, var2.z, var5, var3.x, var3.y, var3.z, var4)) continue;
            ++var8;
        }
        if (var8 == 0) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.particle.success", BuiltInRegistries.PARTICLE_TYPE.getKey(var1.getType()).toString()), true);
        return var8;
    }
}

