/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.common.ClientboundClearDialogPacket;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;

public class DialogCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("dialog").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("show").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.argument("dialog", ResourceOrIdArgument.dialog(var1)).executes(var0 -> DialogCommand.showDialog((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceOrIdArgument.getDialog((CommandContext<CommandListenerWrapper>)var0, "dialog"))))))).then(net.minecraft.commands.CommandDispatcher.literal("clear").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var0 -> DialogCommand.clearDialog((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"))))));
    }

    private static int showDialog(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Holder<Dialog> var2) {
        for (EntityPlayer var4 : var1) {
            var4.openDialog(var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.dialog.show.single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.dialog.show.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int clearDialog(CommandListenerWrapper var0, Collection<EntityPlayer> var1) {
        for (EntityPlayer var3 : var1) {
            var3.connection.send(ClientboundClearDialogPacket.INSTANCE);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.dialog.clear.single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.dialog.clear.multiple", var1.size()), true);
        }
        return var1.size();
    }
}

