/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.component.ResolvableProfile;

public class FetchProfileCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("fetchprofile").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("name").then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.greedyString()).executes(var0 -> FetchProfileCommand.resolveName((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.literal("id").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentUUID.uuid()).executes(var0 -> FetchProfileCommand.resolveId((CommandListenerWrapper)var0.getSource(), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "id"))))));
    }

    private static void reportResolvedProfile(CommandListenerWrapper var0, GameProfile var12, String var2, IChatBaseComponent var3) {
        ResolvableProfile var42 = ResolvableProfile.createResolved(var12);
        ResolvableProfile.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var42).ifSuccess(var4 -> {
            String var52 = var4.toString();
            IChatMutableComponent var6 = IChatBaseComponent.object(new PlayerSprite(var42, true));
            ComponentSerialization.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var6).ifSuccess(var5 -> {
                String var6 = var5.toString();
                var0.sendSuccess(() -> {
                    Object var5 = ChatComponentUtils.formatList(List.of(IChatBaseComponent.translatable("commands.fetchprofile.copy_component").withStyle(var1 -> var1.withClickEvent(new ChatClickable.CopyToClipboard(var52))), IChatBaseComponent.translatable("commands.fetchprofile.give_item").withStyle(var1 -> var1.withClickEvent(new ChatClickable.RunCommand("give @s minecraft:player_head[profile=" + var52 + "]"))), IChatBaseComponent.translatable("commands.fetchprofile.summon_mannequin").withStyle(var1 -> var1.withClickEvent(new ChatClickable.RunCommand("summon minecraft:mannequin ~ ~ ~ {profile:" + var52 + "}"))), IChatBaseComponent.translatable("commands.fetchprofile.copy_text", var6.withStyle(EnumChatFormat.WHITE)).withStyle(var1 -> var1.withClickEvent(new ChatClickable.CopyToClipboard(var6)))), CommonComponents.SPACE, var0 -> ChatComponentUtils.wrapInSquareBrackets(var0.withStyle(EnumChatFormat.GREEN)));
                    return IChatBaseComponent.translatable(var2, var3, var5);
                }, false);
            }).ifError(var1 -> var0.sendFailure(IChatBaseComponent.translatable("commands.fetchprofile.failed_to_serialize", var1.message())));
        }).ifError(var1 -> var0.sendFailure(IChatBaseComponent.translatable("commands.fetchprofile.failed_to_serialize", var1.message())));
    }

    private static int resolveName(CommandListenerWrapper var0, String var1) {
        MinecraftServer var2 = var0.getServer();
        ProfileResolver var3 = var2.services().profileResolver();
        SystemUtils.nonCriticalIoPool().execute(() -> {
            IChatMutableComponent var4 = IChatBaseComponent.literal(var1);
            Optional<GameProfile> var5 = var3.fetchByName(var1);
            var2.execute(() -> var5.ifPresentOrElse(var2 -> FetchProfileCommand.reportResolvedProfile(var0, var2, "commands.fetchprofile.name.success", var4), () -> var0.sendFailure(IChatBaseComponent.translatable("commands.fetchprofile.name.failure", var4))));
        });
        return 1;
    }

    private static int resolveId(CommandListenerWrapper var0, UUID var1) {
        MinecraftServer var2 = var0.getServer();
        ProfileResolver var3 = var2.services().profileResolver();
        SystemUtils.nonCriticalIoPool().execute(() -> {
            IChatBaseComponent var4 = IChatBaseComponent.translationArg(var1);
            Optional<GameProfile> var5 = var3.fetchById(var1);
            var2.execute(() -> var5.ifPresentOrElse(var2 -> FetchProfileCommand.reportResolvedProfile(var0, var2, "commands.fetchprofile.id.success", var4), () -> var0.sendFailure(IChatBaseComponent.translatable("commands.fetchprofile.id.failure", var4))));
        });
        return 1;
    }
}

