/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;

public class WardenSpawnTrackerCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("warden_spawn_tracker").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("clear").executes(var0 -> WardenSpawnTrackerCommand.resetTracker((CommandListenerWrapper)var0.getSource(), (Collection<? extends EntityHuman>)ImmutableList.of((Object)((CommandListenerWrapper)var0.getSource()).getPlayerOrException()))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("warning_level", IntegerArgumentType.integer((int)0, (int)4)).executes(var0 -> WardenSpawnTrackerCommand.setWarningLevel((CommandListenerWrapper)var0.getSource(), (Collection<? extends EntityHuman>)ImmutableList.of((Object)((CommandListenerWrapper)var0.getSource()).getPlayerOrException()), IntegerArgumentType.getInteger((CommandContext)var0, (String)"warning_level"))))));
    }

    private static int setWarningLevel(CommandListenerWrapper var0, Collection<? extends EntityHuman> var12, int var2) {
        for (EntityHuman entityHuman : var12) {
            entityHuman.getWardenSpawnTracker().ifPresent(var1 -> var1.setWarningLevel(var2));
        }
        if (var12.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.warden_spawn_tracker.set.success.single", ((EntityHuman)var12.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.warden_spawn_tracker.set.success.multiple", var12.size()), true);
        }
        return var12.size();
    }

    private static int resetTracker(CommandListenerWrapper var0, Collection<? extends EntityHuman> var1) {
        for (EntityHuman entityHuman : var1) {
            entityHuman.getWardenSpawnTracker().ifPresent(WardenSpawnTracker::reset);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.warden_spawn_tracker.clear.success.single", ((EntityHuman)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.warden_spawn_tracker.clear.success.multiple", var1.size()), true);
        }
        return var1.size();
    }
}

