/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;

public record NumberRangeInput(int width, IChatBaseComponent label, String labelFormat, a rangeInfo) implements InputControl
{
    public static final MapCodec<NumberRangeInput> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(NumberRangeInput::width), (App)ComponentSerialization.CODEC.fieldOf("label").forGetter(NumberRangeInput::label), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeInput::labelFormat), (App)a.MAP_CODEC.forGetter(NumberRangeInput::rangeInfo)).apply((Applicative)var0, NumberRangeInput::new));

    public MapCodec<NumberRangeInput> mapCodec() {
        return MAP_CODEC;
    }

    public IChatBaseComponent computeLabel(String var0) {
        return IChatBaseComponent.translatable(this.labelFormat, this.label, var0);
    }

    public record a(float start, float end, Optional<Float> initial, Optional<Float> step) {
        public static final MapCodec<a> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("start").forGetter(a::start), (App)Codec.FLOAT.fieldOf("end").forGetter(a::end), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(a::initial), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("step").forGetter(a::step)).apply((Applicative)var0, a::new)).validate(var0 -> {
            if (var0.initial.isPresent()) {
                double var1 = var0.initial.get().floatValue();
                double var3 = Math.min(var0.start, var0.end);
                double var5 = Math.max(var0.start, var0.end);
                if (var1 < var3 || var1 > var5) {
                    return DataResult.error(() -> "Initial value " + var1 + " is outside of range [" + var3 + ", " + var5 + "]");
                }
            }
            return DataResult.success((Object)var0);
        });

        public float computeScaledValue(float var0) {
            float var4;
            int var5;
            float var1 = MathHelper.lerp(var0, this.start, this.end);
            if (this.step.isEmpty()) {
                return var1;
            }
            float var2 = this.step.get().floatValue();
            float var3 = this.initialScaledValue();
            float var6 = var3 + (float)(var5 = Math.round((var4 = var1 - var3) / var2)) * var2;
            if (!this.isOutOfRange(var6)) {
                return var6;
            }
            int var7 = var5 - MathHelper.sign(var5);
            return var3 + (float)var7 * var2;
        }

        private boolean isOutOfRange(float var0) {
            float var1 = this.scaledValueToSlider(var0);
            return (double)var1 < 0.0 || (double)var1 > 1.0;
        }

        private float initialScaledValue() {
            if (this.initial.isPresent()) {
                return this.initial.get().floatValue();
            }
            return (this.start + this.end) / 2.0f;
        }

        public float initialSliderValue() {
            float var0 = this.initialScaledValue();
            return this.scaledValueToSlider(var0);
        }

        private float scaledValueToSlider(float var0) {
            if (this.start == this.end) {
                return 0.5f;
            }
            return MathHelper.inverseLerp(var0, this.start, this.end);
        }
    }
}

