/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import net.minecraft.core.Holder;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.OutgoingRpcMethods;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.BanlistService;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.IpBanlistService;
import net.minecraft.server.jsonrpc.methods.OperatorService;
import net.minecraft.server.jsonrpc.methods.ServerStateService;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.world.level.gamerules.GameRule;

public class JsonRpcNotificationService
implements NotificationService {
    private final ManagementServer managementServer;
    private final MinecraftApi minecraftApi;

    public JsonRpcNotificationService(MinecraftApi var0, ManagementServer var1) {
        this.minecraftApi = var0;
        this.managementServer = var1;
    }

    @Override
    public void playerJoined(EntityPlayer var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_JOINED, PlayerDto.from(var0));
    }

    @Override
    public void playerLeft(EntityPlayer var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_LEFT, PlayerDto.from(var0));
    }

    @Override
    public void serverStarted() {
        this.broadcastNotification(OutgoingRpcMethods.SERVER_STARTED);
    }

    @Override
    public void serverShuttingDown() {
        this.broadcastNotification(OutgoingRpcMethods.SERVER_SHUTTING_DOWN);
    }

    @Override
    public void serverSaveStarted() {
        this.broadcastNotification(OutgoingRpcMethods.SERVER_SAVE_STARTED);
    }

    @Override
    public void serverSaveCompleted() {
        this.broadcastNotification(OutgoingRpcMethods.SERVER_SAVE_COMPLETED);
    }

    @Override
    public void serverActivityOccured() {
        this.broadcastNotification(OutgoingRpcMethods.SERVER_ACTIVITY_OCCURRED);
    }

    @Override
    public void playerOped(OpListEntry var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_OPED, OperatorService.b.from(var0));
    }

    @Override
    public void playerDeoped(OpListEntry var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_DEOPED, OperatorService.b.from(var0));
    }

    @Override
    public void playerAddedToAllowlist(NameAndId var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_ADDED_TO_ALLOWLIST, PlayerDto.from(var0));
    }

    @Override
    public void playerRemovedFromAllowlist(NameAndId var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_REMOVED_FROM_ALLOWLIST, PlayerDto.from(var0));
    }

    @Override
    public void ipBanned(IpBanEntry var0) {
        this.broadcastNotification(OutgoingRpcMethods.IP_BANNED, IpBanlistService.c.from(var0));
    }

    @Override
    public void ipUnbanned(String var0) {
        this.broadcastNotification(OutgoingRpcMethods.IP_UNBANNED, var0);
    }

    @Override
    public void playerBanned(GameProfileBanEntry var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_BANNED, BanlistService.b.from(var0));
    }

    @Override
    public void playerUnbanned(NameAndId var0) {
        this.broadcastNotification(OutgoingRpcMethods.PLAYER_UNBANNED, PlayerDto.from(var0));
    }

    @Override
    public <T> void onGameRuleChanged(GameRule<T> var0, T var1) {
        this.broadcastNotification(OutgoingRpcMethods.GAMERULE_CHANGED, GameRulesService.getTypedRule(this.minecraftApi, var0, var1));
    }

    @Override
    public void statusHeartbeat() {
        this.broadcastNotification(OutgoingRpcMethods.STATUS_HEARTBEAT, ServerStateService.status(this.minecraftApi));
    }

    private void broadcastNotification(Holder.c<? extends OutgoingRpcMethod<Void, ?>> var0) {
        this.managementServer.forEachConnection(var1 -> var1.sendNotification(var0));
    }

    private <Params> void broadcastNotification(Holder.c<? extends OutgoingRpcMethod<Params, ?>> var0, Params var1) {
        this.managementServer.forEachConnection(var2 -> var2.sendNotification(var0, var1));
    }
}

