/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import org.jspecify.annotations.Nullable;

public interface OutgoingRpcMethod<Params, Result> {
    public static final String NOTIFICATION_PREFIX = "notification/";

    public MethodInfo<Params, Result> info();

    public a attributes();

    default public @Nullable JsonElement encodeParams(Params var0) {
        return null;
    }

    default public @Nullable Result decodeResult(JsonElement var0) {
        return null;
    }

    public static e<Void, Void> notification() {
        return new e<Void, Void>(g::new);
    }

    public static <Params> e<Params, Void> notificationWithParams() {
        return new e(d::new);
    }

    public static <Result> e<Void, Result> request() {
        return new e(f::new);
    }

    public static <Params, Result> e<Params, Result> requestWithParams() {
        return new e(c::new);
    }

    public static class e<Params, Result> {
        public static final a DEFAULT_ATTRIBUTES = new a(true);
        private final b<Params, Result> method;
        private String description = "";
        private @Nullable ParamInfo<Params> paramInfo;
        private @Nullable ResultInfo<Result> resultInfo;

        public e(b<Params, Result> var0) {
            this.method = var0;
        }

        public e<Params, Result> description(String var0) {
            this.description = var0;
            return this;
        }

        public e<Params, Result> response(String var0, Schema<Result> var1) {
            this.resultInfo = new ResultInfo<Result>(var0, var1);
            return this;
        }

        public e<Params, Result> param(String var0, Schema<Params> var1) {
            this.paramInfo = new ParamInfo<Params>(var0, var1);
            return this;
        }

        private OutgoingRpcMethod<Params, Result> build() {
            MethodInfo<Params, Result> var0 = new MethodInfo<Params, Result>(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(var0, DEFAULT_ATTRIBUTES);
        }

        public Holder.c<OutgoingRpcMethod<Params, Result>> register(String var0) {
            return this.register(MinecraftKey.withDefaultNamespace(OutgoingRpcMethod.NOTIFICATION_PREFIX + var0));
        }

        private Holder.c<OutgoingRpcMethod<Params, Result>> register(MinecraftKey var0) {
            return IRegistry.registerForHolder(BuiltInRegistries.OUTGOING_RPC_METHOD, var0, this.build());
        }
    }

    @FunctionalInterface
    public static interface b<Params, Result> {
        public OutgoingRpcMethod<Params, Result> create(MethodInfo<Params, Result> var1, a var2);
    }

    public record c<Params, Result>(MethodInfo<Params, Result> info, a attributes) implements OutgoingRpcMethod<Params, Result>
    {
        @Override
        public @Nullable JsonElement encodeParams(Params var0) {
            if (this.info.params().isEmpty()) {
                throw new IllegalStateException("Method defined as having no parameters");
            }
            return (JsonElement)this.info.params().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }

        @Override
        public Result decodeResult(JsonElement var0) {
            if (this.info.result().isEmpty()) {
                throw new IllegalStateException("Method defined as having no result");
            }
            return (Result)this.info.result().get().schema().codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record f<Result>(MethodInfo<Void, Result> info, a attributes) implements OutgoingRpcMethod<Void, Result>
    {
        @Override
        public Result decodeResult(JsonElement var0) {
            if (this.info.result().isEmpty()) {
                throw new IllegalStateException("Method defined as having no result");
            }
            return (Result)this.info.result().get().schema().codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record d<Params>(MethodInfo<Params, Void> info, a attributes) implements OutgoingRpcMethod<Params, Void>
    {
        @Override
        public @Nullable JsonElement encodeParams(Params var0) {
            if (this.info.params().isEmpty()) {
                throw new IllegalStateException("Method defined as having no parameters");
            }
            return (JsonElement)this.info.params().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }
    }

    public record g(MethodInfo<Void, Void> info, a attributes) implements OutgoingRpcMethod<Void, Void>
    {
    }

    public record a(boolean discoverable) {
    }
}

