/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import org.jspecify.annotations.Nullable;

public record MethodInfo<Params, Result>(String description, Optional<ParamInfo<Params>> params, Optional<ResultInfo<Result>> result) {
    public MethodInfo(String var0, @Nullable ParamInfo<Params> var1, @Nullable ResultInfo<Result> var2) {
        this(var0, Optional.ofNullable(var1), Optional.ofNullable(var2));
    }

    private static <Params> Optional<ParamInfo<Params>> toOptional(List<ParamInfo<Params>> var0) {
        return var0.isEmpty() ? Optional.empty() : Optional.of(var0.getFirst());
    }

    private static <Params> List<ParamInfo<Params>> toList(Optional<ParamInfo<Params>> var0) {
        if (var0.isPresent()) {
            return List.of(var0.get());
        }
        return List.of();
    }

    private static <Params> Codec<Optional<ParamInfo<Params>>> paramsTypedCodec() {
        return ParamInfo.typedCodec().codec().listOf().xmap(MethodInfo::toOptional, MethodInfo::toList);
    }

    static <Params, Result> MapCodec<MethodInfo<Params, Result>> typedCodec() {
        return RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("description").forGetter(MethodInfo::description), (App)MethodInfo.paramsTypedCodec().fieldOf("params").forGetter(MethodInfo::params), (App)ResultInfo.typedCodec().optionalFieldOf("result").forGetter(MethodInfo::result)).apply((Applicative)var0, MethodInfo::new));
    }

    public a<Params, Result> named(MinecraftKey var0) {
        return new a(var0, this);
    }

    public record a<Params, Result>(MinecraftKey name, MethodInfo<Params, Result> contents) {
        public static final Codec<a<?, ?>> CODEC = a.typedCodec();

        public static <Params, Result> Codec<a<Params, Result>> typedCodec() {
            return RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("name").forGetter(a::name), (App)MethodInfo.typedCodec().forGetter(a::contents)).apply((Applicative)var0, a::new));
        }
    }
}

