/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerSettingsService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;

public class MinecraftServerSettingsServiceImpl
implements MinecraftServerSettingsService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftServerSettingsServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public boolean isAutoSave() {
        return this.server.isAutoSave();
    }

    @Override
    public boolean setAutoSave(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update autosave from {} to {}", this.isAutoSave(), var0);
        this.server.setAutoSave(var0);
        return this.isAutoSave();
    }

    @Override
    public EnumDifficulty getDifficulty() {
        return this.server.getWorldData().getDifficulty();
    }

    @Override
    public EnumDifficulty setDifficulty(EnumDifficulty var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update difficulty from '{}' to '{}'", this.getDifficulty(), var0);
        this.server.setDifficulty(var0);
        return this.getDifficulty();
    }

    @Override
    public boolean isEnforceWhitelist() {
        return this.server.isEnforceWhitelist();
    }

    @Override
    public boolean setEnforceWhitelist(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update enforce allowlist from {} to {}", this.isEnforceWhitelist(), var0);
        this.server.setEnforceWhitelist(var0);
        this.server.kickUnlistedPlayers();
        return this.isEnforceWhitelist();
    }

    @Override
    public boolean isUsingWhitelist() {
        return this.server.isUsingWhitelist();
    }

    @Override
    public boolean setUsingWhitelist(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update using allowlist from {} to {}", this.isUsingWhitelist(), var0);
        this.server.setUsingWhitelist(var0);
        this.server.kickUnlistedPlayers();
        return this.isUsingWhitelist();
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    @Override
    public int setMaxPlayers(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update max players from {} to {}", this.getMaxPlayers(), var0);
        this.server.setMaxPlayers(var0);
        return this.getMaxPlayers();
    }

    @Override
    public int getPauseWhenEmptySeconds() {
        return this.server.pauseWhenEmptySeconds();
    }

    @Override
    public int setPauseWhenEmptySeconds(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update pause when empty from {} seconds to {} seconds", this.getPauseWhenEmptySeconds(), var0);
        this.server.setPauseWhenEmptySeconds(var0);
        return this.getPauseWhenEmptySeconds();
    }

    @Override
    public int getPlayerIdleTimeout() {
        return this.server.playerIdleTimeout();
    }

    @Override
    public int setPlayerIdleTimeout(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update player idle timeout from {} minutes to {} minutes", this.getPlayerIdleTimeout(), var0);
        this.server.setPlayerIdleTimeout(var0);
        return this.getPlayerIdleTimeout();
    }

    @Override
    public boolean allowFlight() {
        return this.server.allowFlight();
    }

    @Override
    public boolean setAllowFlight(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update allow flight from {} to {}", this.allowFlight(), var0);
        this.server.setAllowFlight(var0);
        return this.allowFlight();
    }

    @Override
    public int getSpawnProtectionRadius() {
        return this.server.spawnProtectionRadius();
    }

    @Override
    public int setSpawnProtectionRadius(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update spawn protection radius from {} to {}", this.getSpawnProtectionRadius(), var0);
        this.server.setSpawnProtectionRadius(var0);
        return this.getSpawnProtectionRadius();
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public String setMotd(String var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update MOTD from '{}' to '{}'", this.getMotd(), var0);
        this.server.setMotd(var0);
        return this.getMotd();
    }

    @Override
    public boolean forceGameMode() {
        return this.server.forceGameMode();
    }

    @Override
    public boolean setForceGameMode(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update force game mode from {} to {}", this.forceGameMode(), var0);
        this.server.setForceGameMode(var0);
        return this.forceGameMode();
    }

    @Override
    public EnumGamemode getGameMode() {
        return this.server.gameMode();
    }

    @Override
    public EnumGamemode setGameMode(EnumGamemode var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update game mode from '{}' to '{}'", this.getGameMode(), var0);
        this.server.setGameMode(var0);
        return this.getGameMode();
    }

    @Override
    public int getViewDistance() {
        return this.server.viewDistance();
    }

    @Override
    public int setViewDistance(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update view distance from {} to {}", this.getViewDistance(), var0);
        this.server.setViewDistance(var0);
        return this.getViewDistance();
    }

    @Override
    public int getSimulationDistance() {
        return this.server.simulationDistance();
    }

    @Override
    public int setSimulationDistance(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update simulation distance from {} to {}", this.getSimulationDistance(), var0);
        this.server.setSimulationDistance(var0);
        return this.getSimulationDistance();
    }

    @Override
    public boolean acceptsTransfers() {
        return this.server.acceptsTransfers();
    }

    @Override
    public boolean setAcceptsTransfers(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update accepts transfers from {} to {}", this.acceptsTransfers(), var0);
        this.server.setAcceptsTransfers(var0);
        return this.acceptsTransfers();
    }

    @Override
    public int getStatusHeartbeatInterval() {
        return this.server.statusHeartbeatInterval();
    }

    @Override
    public int setStatusHeartbeatInterval(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update status heartbeat interval from {} to {}", this.getStatusHeartbeatInterval(), var0);
        this.server.setStatusHeartbeatInterval(var0);
        return this.getStatusHeartbeatInterval();
    }

    @Override
    public LevelBasedPermissionSet getOperatorUserPermissions() {
        return this.server.operatorUserPermissions();
    }

    @Override
    public LevelBasedPermissionSet setOperatorUserPermissions(LevelBasedPermissionSet var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update operator user permission level from {} to {}", this.getOperatorUserPermissions(), var0.level());
        this.server.setOperatorUserPermissions(var0);
        return this.getOperatorUserPermissions();
    }

    @Override
    public boolean hidesOnlinePlayers() {
        return this.server.hidesOnlinePlayers();
    }

    @Override
    public boolean setHidesOnlinePlayers(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update hides online players from {} to {}", this.hidesOnlinePlayers(), var0);
        this.server.setHidesOnlinePlayers(var0);
        return this.hidesOnlinePlayers();
    }

    @Override
    public boolean repliesToStatus() {
        return this.server.repliesToStatus();
    }

    @Override
    public boolean setRepliesToStatus(boolean var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update replies to status from {} to {}", this.repliesToStatus(), var0);
        this.server.setRepliesToStatus(var0);
        return this.repliesToStatus();
    }

    @Override
    public int getEntityBroadcastRangePercentage() {
        return this.server.entityBroadcastRangePercentage();
    }

    @Override
    public int setEntityBroadcastRangePercentage(int var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Update entity broadcast range percentage from {}% to {}%", this.getEntityBroadcastRangePercentage(), var0);
        this.server.setEntityBroadcastRangePercentage(var0);
        return this.getEntityBroadcastRangePercentage();
    }
}

