/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.jspecify.annotations.Nullable;

public class ChunkTaskQueue {
    public static final int PRIORITY_LEVEL_COUNT = ChunkLevel.MAX_LEVEL + 2;
    private final List<Long2ObjectLinkedOpenHashMap<List<Runnable>>> queuesPerPriority = IntStream.range(0, PRIORITY_LEVEL_COUNT).mapToObj(var0 -> new Long2ObjectLinkedOpenHashMap()).toList();
    private volatile int topPriorityQueueIndex = PRIORITY_LEVEL_COUNT;
    private final String name;

    public ChunkTaskQueue(String var02) {
        this.name = var02;
    }

    protected void resortChunkTasks(int var02, ChunkCoordIntPair var1, int var2) {
        if (var02 >= PRIORITY_LEVEL_COUNT) {
            return;
        }
        Long2ObjectLinkedOpenHashMap<List<Runnable>> var3 = this.queuesPerPriority.get(var02);
        List var4 = (List)var3.remove(var1.toLong());
        if (var02 == this.topPriorityQueueIndex) {
            while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
                ++this.topPriorityQueueIndex;
            }
        }
        if (var4 != null && !var4.isEmpty()) {
            ((List)this.queuesPerPriority.get(var2).computeIfAbsent(var1.toLong(), var0 -> Lists.newArrayList())).addAll(var4);
            this.topPriorityQueueIndex = Math.min(this.topPriorityQueueIndex, var2);
        }
    }

    protected void submit(Runnable var02, long var1, int var3) {
        ((List)this.queuesPerPriority.get(var3).computeIfAbsent(var1, var0 -> Lists.newArrayList())).add(var02);
        this.topPriorityQueueIndex = Math.min(this.topPriorityQueueIndex, var3);
    }

    protected void release(long var0, boolean var2) {
        for (Long2ObjectLinkedOpenHashMap<List<Runnable>> var4 : this.queuesPerPriority) {
            List var5 = (List)var4.get(var0);
            if (var5 == null) continue;
            if (var2) {
                var5.clear();
            }
            if (!var5.isEmpty()) continue;
            var4.remove(var0);
        }
        while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
            ++this.topPriorityQueueIndex;
        }
    }

    public @Nullable a pop() {
        if (!this.hasWork()) {
            return null;
        }
        int var0 = this.topPriorityQueueIndex;
        Long2ObjectLinkedOpenHashMap<List<Runnable>> var1 = this.queuesPerPriority.get(var0);
        long var2 = var1.firstLongKey();
        List var4 = (List)var1.removeFirst();
        while (this.hasWork() && this.queuesPerPriority.get(this.topPriorityQueueIndex).isEmpty()) {
            ++this.topPriorityQueueIndex;
        }
        return new a(var2, var4);
    }

    public boolean hasWork() {
        return this.topPriorityQueueIndex < PRIORITY_LEVEL_COUNT;
    }

    public String toString() {
        return this.name + " " + this.topPriorityQueueIndex + "...";
    }

    public record a(long chunkPos, List<Runnable> tasks) {
    }
}

