/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.attribute.BedRule;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.pig.EntityPig;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.NautilusInventoryMenu;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityPlayer
extends EntityHuman {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public static final double BLOCK_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 1.0;
    public static final double ENTITY_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 3.0;
    public static final int ENDER_PEARL_TICKET_RADIUS = 2;
    public static final String ENDER_PEARLS_TAG = "ender_pearls";
    public static final String ENDER_PEARL_DIMENSION_TAG = "ender_pearl_dimension";
    public static final String TAG_DIMENSION = "Dimension";
    private static final AttributeModifier CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER = new AttributeModifier(MinecraftKey.withDefaultNamespace("creative_mode_block_range"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER = new AttributeModifier(MinecraftKey.withDefaultNamespace("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    private static final IChatBaseComponent SPAWN_SET_MESSAGE = IChatBaseComponent.translatable("block.minecraft.set_spawn");
    private static final AttributeModifier WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER = new AttributeModifier(MinecraftKey.withDefaultNamespace("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final boolean DEFAULT_SEEN_CREDITS = false;
    private static final boolean DEFAULT_SPAWN_EXTRA_PARTICLES_ON_FALL = false;
    public PlayerConnection connection;
    public final MinecraftServer server;
    public final PlayerInteractManager gameMode;
    private final AdvancementDataPlayer advancements;
    private final ServerStatisticManager stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    public int lastSentExp = -99999999;
    private EnumChatVisibility chatVisibility = EnumChatVisibility.FULL;
    private ParticleStatus particleStatus = ParticleStatus.ALL;
    private boolean canChatColor = true;
    private long lastActionTime = SystemUtils.getMillis();
    private @Nullable Entity camera;
    public boolean isChangingDimension;
    public boolean seenCredits = false;
    private final RecipeBookServer recipeBook;
    private @Nullable Vec3D levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    public String language = "en_us";
    private @Nullable Vec3D startingToFallPosition;
    private @Nullable Vec3D enteredNetherPosition;
    private @Nullable Vec3D enteredLavaOnVehiclePosition;
    private SectionPosition lastSectionPos = SectionPosition.of(0, 0, 0);
    private ChunkTrackingView chunkTrackingView = ChunkTrackingView.EMPTY;
    private @Nullable RespawnConfig respawnConfig;
    private final ITextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private boolean spawnExtraParticlesOnFall = false;
    private WardenSpawnTracker wardenSpawnTracker = new WardenSpawnTracker();
    private @Nullable BlockPosition raidOmenPosition;
    private Vec3D lastKnownClientMovement = Vec3D.ZERO;
    private Input lastClientInput = Input.EMPTY;
    private final Set<EntityEnderPearl> enderPearls = new HashSet<EntityEnderPearl>();
    private long timeEntitySatOnShoulder;
    private NBTTagCompound shoulderEntityLeft = new NBTTagCompound();
    private NBTTagCompound shoulderEntityRight = new NBTTagCompound();
    private final ContainerSynchronizer containerSynchronizer = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> cache = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> registryHashOps;
            {
                this.registryHashOps = EntityPlayer.this.registryAccess().createSerializationContext(HashOps.CRC32C_INSTANCE);
            }

            public Integer load(TypedDataComponent<?> var0) {
                return ((HashCode)var0.encodeValue(this.registryHashOps).getOrThrow(var1 -> new IllegalArgumentException("Failed to hash " + String.valueOf(var0) + ": " + var1))).asInt();
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((TypedDataComponent)object);
            }
        });

        @Override
        public void sendInitialData(Container var0, List<ItemStack> var1, ItemStack var2, int[] var3) {
            EntityPlayer.this.connection.send(new PacketPlayOutWindowItems(var0.containerId, var0.incrementStateId(), var1, var2));
            for (int var4 = 0; var4 < var3.length; ++var4) {
                this.broadcastDataValue(var0, var4, var3[var4]);
            }
        }

        @Override
        public void sendSlotChange(Container var0, int var1, ItemStack var2) {
            EntityPlayer.this.connection.send(new PacketPlayOutSetSlot(var0.containerId, var0.incrementStateId(), var1, var2));
        }

        @Override
        public void sendCarriedChange(Container var0, ItemStack var1) {
            EntityPlayer.this.connection.send(new ClientboundSetCursorItemPacket(var1));
        }

        @Override
        public void sendDataChange(Container var0, int var1, int var2) {
            this.broadcastDataValue(var0, var1, var2);
        }

        private void broadcastDataValue(Container var0, int var1, int var2) {
            EntityPlayer.this.connection.send(new PacketPlayOutWindowData(var0.containerId, var1, var2));
        }

        @Override
        public RemoteSlot createSlot() {
            return new RemoteSlot.a(arg_0 -> this.cache.getUnchecked(arg_0));
        }
    };
    private final ICrafting containerListener = new ICrafting(){

        @Override
        public void slotChanged(Container var0, int var1, ItemStack var2) {
            Slot var3 = var0.getSlot(var1);
            if (var3 instanceof SlotResult) {
                return;
            }
            if (var3.container == EntityPlayer.this.getInventory()) {
                CriterionTriggers.INVENTORY_CHANGED.trigger(EntityPlayer.this, EntityPlayer.this.getInventory(), var2);
            }
        }

        @Override
        public void dataChanged(Container var0, int var1, int var2) {
        }
    };
    private @Nullable RemoteChatSession chatSession;
    public final @Nullable Object object;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public boolean acceptsSuccess() {
            return EntityPlayer.this.level().getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return true;
        }

        @Override
        public void sendSystemMessage(IChatBaseComponent var0) {
            EntityPlayer.this.sendSystemMessage(var0);
        }
    };
    private Set<DebugSubscription<?>> requestedDebugSubscriptions = Set.of();
    private int containerCounter;
    public boolean wonGame;

    public EntityPlayer(MinecraftServer var0, WorldServer var12, GameProfile var22, ClientInformation var3) {
        super(var12, var22);
        this.server = var0;
        this.textFilter = var0.createTextFilterForPlayer(this);
        this.gameMode = var0.createGameModeForPlayer(this);
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(null), null);
        this.recipeBook = new RecipeBookServer((var1, var2) -> var0.getRecipeManager().listDisplaysForRecipe(var1, var2));
        this.stats = var0.getPlayerList().getPlayerStats(this);
        this.advancements = var0.getPlayerList().getPlayerAdvancements(this);
        this.updateOptions(var3);
        this.object = null;
    }

    @Override
    public BlockPosition adjustSpawnLocation(WorldServer var0, BlockPosition var1) {
        CompletableFuture<Vec3D> var2 = PlayerSpawnFinder.findSpawn(var0, var1);
        this.server.managedBlock(var2::isDone);
        return BlockPosition.containing(var2.join());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.wardenSpawnTracker = var0.read("warden_spawn_tracker", WardenSpawnTracker.CODEC).orElseGet(WardenSpawnTracker::new);
        this.enteredNetherPosition = var0.read("entered_nether_pos", Vec3D.CODEC).orElse(null);
        this.seenCredits = var0.getBooleanOr("seenCredits", false);
        var0.read("recipeBook", RecipeBookServer.b.CODEC).ifPresent(var02 -> this.recipeBook.loadUntrusted((RecipeBookServer.b)var02, var0 -> this.server.getRecipeManager().byKey((ResourceKey<IRecipe<?>>)var0).isPresent()));
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.respawnConfig = var0.read("respawn", RespawnConfig.CODEC).orElse(null);
        this.spawnExtraParticlesOnFall = var0.getBooleanOr("spawn_extra_particles_on_fall", false);
        this.raidOmenPosition = var0.read("raid_omen_position", BlockPosition.CODEC).orElse(null);
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(EntityPlayer.readPlayerMode(var0, "playerGameType")), EntityPlayer.readPlayerMode(var0, "previousPlayerGameType"));
        this.setShoulderEntityLeft(var0.read("ShoulderEntityLeft", NBTTagCompound.CODEC).orElseGet(NBTTagCompound::new));
        this.setShoulderEntityRight(var0.read("ShoulderEntityRight", NBTTagCompound.CODEC).orElseGet(NBTTagCompound::new));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store("warden_spawn_tracker", WardenSpawnTracker.CODEC, this.wardenSpawnTracker);
        this.storeGameTypes(var0);
        var0.putBoolean("seenCredits", this.seenCredits);
        var0.storeNullable("entered_nether_pos", Vec3D.CODEC, this.enteredNetherPosition);
        this.saveParentVehicle(var0);
        var0.store("recipeBook", RecipeBookServer.b.CODEC, this.recipeBook.pack());
        var0.putString(TAG_DIMENSION, this.level().dimension().identifier().toString());
        var0.storeNullable("respawn", RespawnConfig.CODEC, this.respawnConfig);
        var0.putBoolean("spawn_extra_particles_on_fall", this.spawnExtraParticlesOnFall);
        var0.storeNullable("raid_omen_position", BlockPosition.CODEC, this.raidOmenPosition);
        this.saveEnderPearls(var0);
        if (!this.getShoulderEntityLeft().isEmpty()) {
            var0.store("ShoulderEntityLeft", NBTTagCompound.CODEC, this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            var0.store("ShoulderEntityRight", NBTTagCompound.CODEC, this.getShoulderEntityRight());
        }
    }

    private void saveParentVehicle(ValueOutput var0) {
        Entity var1 = this.getRootVehicle();
        Entity var2 = this.getVehicle();
        if (var2 != null && var1 != this && var1.hasExactlyOnePlayerPassenger()) {
            ValueOutput var3 = var0.child("RootVehicle");
            var3.store("Attach", UUIDUtil.CODEC, var2.getUUID());
            var1.save(var3.child("Entity"));
        }
    }

    public void loadAndSpawnParentVehicle(ValueInput var0) {
        Optional<ValueInput> var12 = var0.child("RootVehicle");
        if (var12.isEmpty()) {
            return;
        }
        WorldServer var2 = this.level();
        Entity var3 = EntityTypes.loadEntityRecursive(var12.get().childOrEmpty("Entity"), (World)var2, EntitySpawnReason.LOAD, var1 -> {
            if (!var2.addWithUUID(var1)) {
                return null;
            }
            return var1;
        });
        if (var3 == null) {
            return;
        }
        UUID var4 = var12.get().read("Attach", UUIDUtil.CODEC).orElse(null);
        if (var3.getUUID().equals(var4)) {
            this.startRiding(var3, true, false);
        } else {
            for (Entity var6 : var3.getIndirectPassengers()) {
                if (!var6.getUUID().equals(var4)) continue;
                this.startRiding(var6, true, false);
                break;
            }
        }
        if (!this.isPassenger()) {
            LOGGER.warn("Couldn't reattach entity to player");
            var3.discard();
            for (Entity var6 : var3.getIndirectPassengers()) {
                var6.discard();
            }
        }
    }

    private void saveEnderPearls(ValueOutput var0) {
        if (!this.enderPearls.isEmpty()) {
            ValueOutput.b var1 = var0.childrenList(ENDER_PEARLS_TAG);
            for (EntityEnderPearl var3 : this.enderPearls) {
                if (var3.isRemoved()) {
                    LOGGER.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput var4 = var1.addChild();
                var3.save(var4);
                var4.store(ENDER_PEARL_DIMENSION_TAG, World.RESOURCE_KEY_CODEC, var3.level().dimension());
            }
        }
    }

    public void loadAndSpawnEnderPearls(ValueInput var0) {
        var0.childrenListOrEmpty(ENDER_PEARLS_TAG).forEach(this::loadAndSpawnEnderPearl);
    }

    private void loadAndSpawnEnderPearl(ValueInput var0) {
        Optional<ResourceKey<World>> var12 = var0.read(ENDER_PEARL_DIMENSION_TAG, World.RESOURCE_KEY_CODEC);
        if (var12.isEmpty()) {
            return;
        }
        WorldServer var2 = this.level().getServer().getLevel(var12.get());
        if (var2 != null) {
            Entity var3 = EntityTypes.loadEntityRecursive(var0, (World)var2, EntitySpawnReason.LOAD, var1 -> {
                if (!var2.addWithUUID(var1)) {
                    return null;
                }
                return var1;
            });
            if (var3 != null) {
                EntityPlayer.placeEnderPearlTicket(var2, var3.chunkPosition());
            } else {
                LOGGER.warn("Failed to spawn player ender pearl in level ({}), skipping", var12.get());
            }
        } else {
            LOGGER.warn("Trying to load ender pearl without level ({}) being loaded, skipping", var12.get());
        }
    }

    public void setExperiencePoints(int var0) {
        float var2;
        float var1 = this.getXpNeededForNextLevel();
        float var3 = MathHelper.clamp((float)var0 / var1, 0.0f, var2 = (var1 - 1.0f) / var1);
        if (var3 == this.experienceProgress) {
            return;
        }
        this.experienceProgress = var3;
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int var0) {
        if (var0 == this.experienceLevel) {
            return;
        }
        this.experienceLevel = var0;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int var0) {
        if (var0 == 0) {
            return;
        }
        super.giveExperienceLevels(var0);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack var0, int var1) {
        super.onEnchantmentPerformed(var0, var1);
        this.lastSentExp = -1;
    }

    public void initMenu(Container var0) {
        var0.addSlotListener(this.containerListener);
        var0.setSynchronizer(this.containerSynchronizer);
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(ClientboundPlayerCombatEnterPacket.INSTANCE);
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    public void onInsideBlock(IBlockData var0) {
        CriterionTriggers.ENTER_BLOCK.trigger(this, var0);
    }

    @Override
    protected ItemCooldown createItemCooldowns() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void tick() {
        Entity var0;
        this.connection.tickClientLoadTimeout();
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.containerMenu.broadcastChanges();
        if (!this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        if ((var0 = this.getCamera()) != this) {
            if (var0.isAlive()) {
                this.absSnapTo(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot());
                this.level().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriterionTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriterionTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.updatePlayerAttributes();
        this.advancements.flushDirty(this, true);
    }

    private void updatePlayerAttributes() {
        AttributeModifiable var2;
        AttributeModifiable var1;
        AttributeModifiable var0 = this.getAttribute(GenericAttributes.BLOCK_INTERACTION_RANGE);
        if (var0 != null) {
            if (this.isCreative()) {
                var0.addOrUpdateTransientModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            } else {
                var0.removeModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((var1 = this.getAttribute(GenericAttributes.ENTITY_INTERACTION_RANGE)) != null) {
            if (this.isCreative()) {
                var1.addOrUpdateTransientModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            } else {
                var1.removeModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((var2 = this.getAttribute(GenericAttributes.WAYPOINT_TRANSMIT_RANGE)) != null) {
            if (this.isCrouching()) {
                var2.addOrUpdateTransientModifier(WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER);
            } else {
                var2.removeModifier(WAYPOINT_TRANSMIT_RANGE_CROUCH_MODIFIER);
            }
        }
    }

    public void doTick() {
        try {
            if (!this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
                if (!this.containerMenu.stillValid(this)) {
                    this.closeContainer();
                    this.containerMenu = this.inventoryMenu;
                }
                this.foodData.tick(this);
                this.awardStat(StatisticList.PLAY_TIME);
                this.awardStat(StatisticList.TOTAL_WORLD_TIME);
                if (this.isAlive()) {
                    this.awardStat(StatisticList.TIME_SINCE_DEATH);
                }
                if (this.isDiscrete()) {
                    this.awardStat(StatisticList.CROUCH_TIME);
                }
                if (!this.isSleeping()) {
                    this.awardStat(StatisticList.TIME_SINCE_REST);
                }
            }
            for (int var0 = 0; var0 < this.getInventory().getContainerSize(); ++var0) {
                ItemStack var1 = this.getInventory().getItem(var0);
                if (var1.isEmpty()) continue;
                this.synchronizeSpecialItemUpdates(var1);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new PacketPlayOutUpdateHealth(this.getHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(IScoreboardCriteria.HEALTH, MathHelper.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(IScoreboardCriteria.FOOD, MathHelper.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(IScoreboardCriteria.AIR, MathHelper.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(IScoreboardCriteria.ARMOR, MathHelper.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(IScoreboardCriteria.EXPERIENCE, MathHelper.ceil(this.lastRecordedExperience));
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(IScoreboardCriteria.LEVEL, MathHelper.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new PacketPlayOutExperience(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriterionTriggers.LOCATION.trigger(this);
            }
        }
        catch (Throwable var0) {
            CrashReport var1 = CrashReport.forThrowable(var0, "Ticking player");
            CrashReportSystemDetails var2 = var1.addCategory("Player being ticked");
            this.fillCrashReportCategory(var2);
            throw new ReportedException(var1);
        }
    }

    private void synchronizeSpecialItemUpdates(ItemStack var0) {
        Packet<?> var3;
        MapId var1 = var0.get(DataComponents.MAP_ID);
        WorldMap var2 = ItemWorldMap.getSavedData(var1, (World)this.level());
        if (var2 != null && (var3 = var2.getUpdatePacket(var1, this)) != null) {
            this.connection.send(var3);
        }
    }

    @Override
    protected void tickRegeneration() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.level().getGameRules().get(GameRules.NATURAL_HEALTH_REGENERATION).booleanValue()) {
            if (this.tickCount % 20 == 0) {
                float var0;
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(1.0f);
                }
                if ((var0 = this.foodData.getSaturationLevel()) < 20.0f) {
                    this.foodData.setSaturation(var0 + 1.0f);
                }
            }
            if (this.tickCount % 10 == 0 && this.foodData.needsFood()) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
    }

    @Override
    public void handleShoulderEntities() {
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (this.fallDistance > 0.5 || this.isInWater() || this.getAbilities().flying || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    private void playShoulderEntityAmbientSound(NBTTagCompound var0) {
        EntityTypes var1;
        if (var0.isEmpty() || var0.getBooleanOr("Silent", false)) {
            return;
        }
        if (this.random.nextInt(200) == 0 && (var1 = (EntityTypes)var0.read("id", EntityTypes.CODEC).orElse(null)) == EntityTypes.PARROT && !EntityParrot.imitateNearbyMobs(this.level(), this)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), EntityParrot.getAmbient(this.level(), this.random), this.getSoundSource(), 1.0f, EntityParrot.getPitch(this.random));
        }
    }

    public boolean setEntityOnShoulder(NBTTagCompound var0) {
        if (this.isPassenger() || !this.onGround() || this.isInWater() || this.isInPowderSnow) {
            return false;
        }
        if (this.getShoulderEntityLeft().isEmpty()) {
            this.setShoulderEntityLeft(var0);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        if (this.getShoulderEntityRight().isEmpty()) {
            this.setShoulderEntityRight(var0);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        return false;
    }

    @Override
    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            this.respawnEntityOnShoulder(this.getShoulderEntityLeft());
            this.setShoulderEntityLeft(new NBTTagCompound());
            this.respawnEntityOnShoulder(this.getShoulderEntityRight());
            this.setShoulderEntityRight(new NBTTagCompound());
        }
    }

    private void respawnEntityOnShoulder(NBTTagCompound var0) {
        WorldServer worldServer = this.level();
        if (worldServer instanceof WorldServer) {
            WorldServer var12 = worldServer;
            if (!var0.isEmpty()) {
                try (ProblemReporter.j var2 = new ProblemReporter.j(this.problemPath(), LOGGER);){
                    EntityTypes.create(TagValueInput.create(var2.forChild(() -> ".shoulder"), (HolderLookup.a)var12.registryAccess(), var0), var12, EntitySpawnReason.LOAD).ifPresent(var1 -> {
                        if (var1 instanceof EntityTameableAnimal) {
                            EntityTameableAnimal var2 = (EntityTameableAnimal)var1;
                            var2.setOwner(this);
                        }
                        var1.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                        var12.addWithUUID((Entity)var1);
                    });
                }
            }
        }
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriterionTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0 && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
            if (this.currentImpulseImpactPos != null && this.currentImpulseImpactPos.y <= this.startingToFallPosition.y) {
                CriterionTriggers.FALL_AFTER_EXPLOSION.trigger(this, this.currentImpulseImpactPos, this.currentExplosionCause);
            }
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriterionTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(IScoreboardCriteria var0, int var12) {
        this.level().getScoreboard().forAllObjectives(var0, this, var1 -> var1.set(var12));
    }

    @Override
    public void die(DamageSource var0) {
        Object var2;
        this.gameEvent(GameEvent.ENTITY_DIE);
        boolean var1 = this.level().getGameRules().get(GameRules.SHOW_DEATH_MESSAGES);
        if (var1) {
            var2 = this.getCombatTracker().getDeathMessage();
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), (IChatBaseComponent)var2), PacketSendListener.exceptionallySend(() -> this.d((IChatBaseComponent)var2)));
            ScoreboardTeam var3 = this.getTeam();
            if (var3 == null || ((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS) {
                this.server.getPlayerList().broadcastSystemMessage((IChatBaseComponent)var2, false);
            } else if (((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS) {
                this.server.getPlayerList().broadcastSystemToTeam(this, (IChatBaseComponent)var2);
            } else if (((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM) {
                this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, (IChatBaseComponent)var2);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.level().getGameRules().get(GameRules.FORGIVE_DEAD_PLAYERS).booleanValue()) {
            this.tellNeutralMobsThatIDied();
        }
        if (!this.isSpectator()) {
            this.dropAllDeathLoot(this.level(), var0);
        }
        this.level().getScoreboard().forAllObjectives(IScoreboardCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        var2 = this.getKillCredit();
        if (var2 != null) {
            this.awardStat(StatisticList.ENTITY_KILLED_BY.get(((Entity)var2).getType()));
            ((Entity)var2).awardKillScore(this, var0);
            this.createWitherRose((EntityLiving)var2);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(StatisticList.DEATHS);
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_DEATH));
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
        this.connection.markClientUnloadedAfterDeath();
    }

    private void tellNeutralMobsThatIDied() {
        AxisAlignedBB var02 = new AxisAlignedBB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(EntityInsentient.class, var02, IEntitySelector.NO_SPECTATORS).stream().filter(var0 -> var0 instanceof IEntityAngerable).forEach(var0 -> ((IEntityAngerable)((Object)var0)).playerDied(this.level(), this));
    }

    @Override
    public void awardKillScore(Entity var0, DamageSource var1) {
        if (var0 == this) {
            return;
        }
        super.awardKillScore(var0, var1);
        ScoreboardServer var2 = this.level().getScoreboard();
        var2.forAllObjectives(IScoreboardCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
        if (var0 instanceof EntityHuman) {
            this.awardStat(StatisticList.PLAYER_KILLS);
            var2.forAllObjectives(IScoreboardCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
        } else {
            this.awardStat(StatisticList.MOB_KILLS);
        }
        this.handleTeamKill(this, var0, IScoreboardCriteria.TEAM_KILL);
        this.handleTeamKill(var0, this, IScoreboardCriteria.KILLED_BY_TEAM);
        CriterionTriggers.PLAYER_KILLED_ENTITY.trigger(this, var0, var1);
    }

    private void handleTeamKill(ScoreHolder var0, ScoreHolder var1, IScoreboardCriteria[] var2) {
        int var5;
        ScoreboardServer var3 = this.level().getScoreboard();
        ScoreboardTeam var4 = var3.getPlayersTeam(var1.getScoreboardName());
        if (var4 != null && (var5 = var4.getColor().getId()) >= 0 && var5 < var2.length) {
            var3.forAllObjectives(var2[var5], var0, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        EntityHuman var6;
        Entity var5;
        Entity var4;
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        Entity var3 = var1.getEntity();
        if (var3 instanceof EntityHuman && !this.canHarmPlayer((EntityHuman)(var4 = (EntityHuman)var3))) {
            return false;
        }
        if (var3 instanceof EntityArrow && (var5 = ((IProjectile)(var4 = (EntityArrow)var3)).getOwner()) instanceof EntityHuman && !this.canHarmPlayer(var6 = (EntityHuman)var5)) {
            return false;
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public boolean canHarmPlayer(EntityHuman var0) {
        if (!this.isPvpAllowed()) {
            return false;
        }
        return super.canHarmPlayer(var0);
    }

    private boolean isPvpAllowed() {
        return this.level().isPvpAllowed();
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean var0, TeleportTransition.a var1) {
        RespawnConfig var2 = this.getRespawnConfig();
        WorldServer var3 = this.server.getLevel(RespawnConfig.getDimensionOrDefault(var2));
        if (var3 != null && var2 != null) {
            Optional<RespawnPosAngle> var4 = EntityPlayer.findRespawnAndUseSpawnBlock(var3, var2, var0);
            if (var4.isPresent()) {
                RespawnPosAngle var5 = var4.get();
                return new TeleportTransition(var3, var5.position(), Vec3D.ZERO, var5.yaw(), var5.pitch(), var1);
            }
            return TeleportTransition.missingRespawnBlock(this, var1);
        }
        return TeleportTransition.createDefault(this, var1);
    }

    public boolean isReceivingWaypoints() {
        return this.getAttributeValue(GenericAttributes.WAYPOINT_RECEIVE_RANGE) > 0.0;
    }

    @Override
    protected void onAttributeUpdated(Holder<AttributeBase> var0) {
        if (var0.is(GenericAttributes.WAYPOINT_RECEIVE_RANGE)) {
            ServerWaypointManager var1 = this.level().getWaypointManager();
            if (this.getAttributes().getValue(var0) > 0.0) {
                var1.addPlayer(this);
            } else {
                var1.removePlayer(this);
            }
        }
        super.onAttributeUpdated(var0);
    }

    public static Optional<RespawnPosAngle> findRespawnAndUseSpawnBlock(WorldServer var0, RespawnConfig var12, boolean var2) {
        WorldData.a var3 = var12.respawnData;
        BlockPosition var4 = var3.pos();
        float var5 = var3.yaw();
        float var6 = var3.pitch();
        boolean var7 = var12.forced;
        IBlockData var8 = var0.getBlockState(var4);
        Block var9 = var8.getBlock();
        if (var9 instanceof BlockRespawnAnchor && (var7 || var8.getValue(BlockRespawnAnchor.CHARGE) > 0) && BlockRespawnAnchor.canSetSpawn(var0, var4)) {
            Optional<Vec3D> var10 = BlockRespawnAnchor.findStandUpPosition(EntityTypes.PLAYER, var0, var4);
            if (!var7 && var2 && var10.isPresent()) {
                var0.setBlock(var4, (IBlockData)var8.setValue(BlockRespawnAnchor.CHARGE, var8.getValue(BlockRespawnAnchor.CHARGE) - 1), 3);
            }
            return var10.map(var1 -> RespawnPosAngle.of(var1, var4, 0.0f));
        }
        if (var9 instanceof BlockBed && var0.environmentAttributes().getValue(EnvironmentAttributes.BED_RULE, var4).canSetSpawn(var0)) {
            return BlockBed.findStandUpPosition(EntityTypes.PLAYER, var0, var4, (EnumDirection)var8.getValue(BlockBed.FACING), var5).map(var1 -> RespawnPosAngle.of(var1, var4, 0.0f));
        }
        if (!var7) {
            return Optional.empty();
        }
        boolean var10 = var9.isPossibleToRespawnInThis(var8);
        IBlockData var11 = var0.getBlockState(var4.above());
        boolean var122 = var11.getBlock().isPossibleToRespawnInThis(var11);
        if (var10 && var122) {
            return Optional.of(new RespawnPosAngle(new Vec3D((double)var4.getX() + 0.5, (double)var4.getY() + 0.1, (double)var4.getZ() + 0.5), var5, var6));
        }
        return Optional.empty();
    }

    public void showEndCredits() {
        this.unRide();
        this.level().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        if (!this.wonGame) {
            this.wonGame = true;
            this.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.WIN_GAME, 0.0f));
            this.seenCredits = true;
        }
    }

    @Override
    public @Nullable EntityPlayer teleport(TeleportTransition var0) {
        if (this.isRemoved()) {
            return null;
        }
        if (var0.missingRespawnBlock()) {
            this.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        WorldServer var1 = var0.newLevel();
        WorldServer var2 = this.level();
        ResourceKey<World> var3 = var2.dimension();
        if (!var0.asPassenger()) {
            this.removeVehicle();
        }
        if (var1.dimension() == var3) {
            this.connection.teleport(PositionMoveRotation.of(var0), var0.relatives());
            this.connection.resetPosition();
            var0.postTeleportTransition().onTransition(this);
            return this;
        }
        this.isChangingDimension = true;
        WorldData var4 = var1.getLevelData();
        this.connection.send(new PacketPlayOutRespawn(this.createCommonSpawnInfo(var1), 3));
        this.connection.send(new PacketPlayOutServerDifficulty(var4.getDifficulty(), var4.isDifficultyLocked()));
        PlayerList var5 = this.server.getPlayerList();
        var5.sendPlayerPermissionLevel(this);
        var2.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        GameProfilerFiller var6 = Profiler.get();
        var6.push("moving");
        if (var3 == World.OVERWORLD && var1.dimension() == World.NETHER) {
            this.enteredNetherPosition = this.position();
        }
        var6.pop();
        var6.push("placing");
        this.setServerLevel(var1);
        this.connection.teleport(PositionMoveRotation.of(var0), var0.relatives());
        this.connection.resetPosition();
        var1.addDuringTeleport(this);
        var6.pop();
        this.triggerDimensionChangeTriggers(var2);
        this.stopUsingItem();
        this.connection.send(new PacketPlayOutAbilities(this.getAbilities()));
        var5.sendLevelInfo(this, var1);
        var5.sendAllPlayerInfo(this);
        var5.sendActivePlayerEffects(this);
        var0.postTeleportTransition().onTransition(this);
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.teleportSpectators(var0, var2);
        return this;
    }

    @Override
    public void forceSetRotation(float var0, boolean var1, float var2, boolean var3) {
        super.forceSetRotation(var0, var1, var2, var3);
        this.connection.send(new ClientboundPlayerRotationPacket(var0, var1, var2, var3));
    }

    public void triggerDimensionChangeTriggers(WorldServer var0) {
        ResourceKey<World> var1 = var0.dimension();
        ResourceKey<World> var2 = this.level().dimension();
        CriterionTriggers.CHANGED_DIMENSION.trigger(this, var1, var2);
        if (var1 == World.NETHER && var2 == World.OVERWORLD && this.enteredNetherPosition != null) {
            CriterionTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if (var2 != World.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(EntityPlayer var0) {
        if (var0.isSpectator()) {
            return this.getCamera() == this;
        }
        if (this.isSpectator()) {
            return false;
        }
        return super.broadcastToPlayer(var0);
    }

    @Override
    public void take(Entity var0, int var1) {
        super.take(var0, var1);
        this.containerMenu.broadcastChanges();
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition var02) {
        EnumDirection var1 = this.level().getBlockState(var02).getValue(BlockFacingHorizontal.FACING);
        if (this.isSleeping() || !this.isAlive()) {
            return Either.left((Object)EntityHuman.EnumBedResult.OTHER_PROBLEM);
        }
        BedRule var2 = this.level().environmentAttributes().getValue(EnvironmentAttributes.BED_RULE, var02);
        boolean var3 = var2.canSleep(this.level());
        boolean var4 = var2.canSetSpawn(this.level());
        if (!var4 && !var3) {
            return Either.left((Object)var2.asProblem());
        }
        if (!this.bedInRange(var02, var1)) {
            return Either.left((Object)EntityHuman.EnumBedResult.TOO_FAR_AWAY);
        }
        if (this.bedBlocked(var02, var1)) {
            return Either.left((Object)EntityHuman.EnumBedResult.OBSTRUCTED);
        }
        if (var4) {
            this.setRespawnPosition(new RespawnConfig(WorldData.a.of(this.level().dimension(), var02, this.getYRot(), this.getXRot()), false), true);
        }
        if (!var3) {
            return Either.left((Object)var2.asProblem());
        }
        if (!this.isCreative()) {
            double var5 = 8.0;
            double var7 = 5.0;
            Vec3D var9 = Vec3D.atBottomCenterOf(var02);
            List<EntityMonster> var10 = this.level().getEntitiesOfClass(EntityMonster.class, new AxisAlignedBB(var9.x() - 8.0, var9.y() - 5.0, var9.z() - 8.0, var9.x() + 8.0, var9.y() + 5.0, var9.z() + 8.0), var0 -> var0.isPreventingPlayerRest(this.level(), this));
            if (!var10.isEmpty()) {
                return Either.left((Object)EntityHuman.EnumBedResult.NOT_SAFE);
            }
        }
        Either var5 = super.startSleepInBed(var02).ifRight(var0 -> {
            this.awardStat(StatisticList.SLEEP_IN_BED);
            CriterionTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.level().canSleepThroughNights()) {
            this.displayClientMessage(IChatBaseComponent.translatable("sleep.not_possible"), true);
        }
        this.level().updateSleepingPlayerList();
        return var5;
    }

    @Override
    public void startSleeping(BlockPosition var0) {
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        super.startSleeping(var0);
    }

    private boolean bedInRange(BlockPosition var0, EnumDirection var1) {
        return this.isReachableBedBlock(var0) || this.isReachableBedBlock(var0.relative(var1.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPosition var0) {
        Vec3D var1 = Vec3D.atBottomCenterOf(var0);
        return Math.abs(this.getX() - var1.x()) <= 3.0 && Math.abs(this.getY() - var1.y()) <= 2.0 && Math.abs(this.getZ() - var1.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPosition var0, EnumDirection var1) {
        BlockPosition var2 = var0.above();
        return !this.freeAt(var2) || !this.freeAt(var2.relative(var1.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean var0, boolean var1) {
        if (this.isSleeping()) {
            this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new PacketPlayOutAnimation(this, 2));
        }
        super.stopSleepInBed(var0, var1);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    @Override
    public boolean isInvulnerableTo(WorldServer var0, DamageSource var1) {
        return super.isInvulnerableTo(var0, var1) || this.isChangingDimension() && !var1.is(DamageTypes.ENDER_PEARL) || !this.connection.hasClientLoaded();
    }

    @Override
    protected void onChangedBlock(WorldServer var0, BlockPosition var1) {
        if (!this.isSpectator()) {
            super.onChangedBlock(var0, var1);
        }
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        if (this.spawnExtraParticlesOnFall && var2 && this.fallDistance > 0.0) {
            Vec3D var5 = var4.getCenter().add(0.0, 0.5, 0.0);
            int var6 = (int)MathHelper.clamp(50.0 * this.fallDistance, 0.0, 200.0);
            this.level().sendParticles(new ParticleParamBlock(Particles.BLOCK, var3), var5.x, var5.y, var5.z, var6, 0.3f, 0.3f, 0.3f, 0.15f);
            this.spawnExtraParticlesOnFall = false;
        }
        super.checkFallDamage(var0, var2, var3, var4);
    }

    @Override
    public void onExplosionHit(@Nullable Entity var0) {
        super.onExplosionHit(var0);
        this.currentImpulseImpactPos = this.position();
        this.currentExplosionCause = var0;
        this.setIgnoreFallDamageFromCurrentImpulse(var0 != null && var0.getType() == EntityTypes.WIND_CHARGE);
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(TileEntitySign var0, boolean var1) {
        this.connection.send(new PacketPlayOutBlockChange(this.level(), var0.getBlockPos()));
        this.connection.send(new PacketPlayOutOpenSignEditor(var0.getBlockPos(), var1));
    }

    @Override
    public void openDialog(Holder<Dialog> var0) {
        this.connection.send(new ClientboundShowDialogPacket(var0));
    }

    public void nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
    }

    @Override
    public OptionalInt openMenu(@Nullable ITileInventory var0) {
        if (var0 == null) {
            return OptionalInt.empty();
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        Container var1 = var0.createMenu(this.containerCounter, this.getInventory(), this);
        if (var1 == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(IChatBaseComponent.translatable("container.spectatorCantOpen").withStyle(EnumChatFormat.RED), true);
            }
            return OptionalInt.empty();
        }
        this.connection.send(new PacketPlayOutOpenWindow(var1.containerId, var1.getType(), var0.getDisplayName()));
        this.initMenu(var1);
        this.containerMenu = var1;
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int var0, MerchantRecipeList var1, int var2, int var3, boolean var4, boolean var5) {
        this.connection.send(new PacketPlayOutOpenWindowMerchant(var0, var1, var2, var3, var4, var5));
    }

    @Override
    public void openHorseInventory(EntityHorseAbstract var0, IInventory var1) {
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        int var2 = var0.getInventoryColumns();
        this.connection.send(new PacketPlayOutOpenWindowHorse(this.containerCounter, var2, var0.getId()));
        this.containerMenu = new ContainerHorse(this.containerCounter, this.getInventory(), var1, var0, var2);
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openNautilusInventory(AbstractNautilus var0, IInventory var1) {
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        int var2 = var0.getInventoryColumns();
        this.connection.send(new PacketPlayOutOpenWindowHorse(this.containerCounter, var2, var0.getId()));
        this.containerMenu = new NautilusInventoryMenu(this.containerCounter, this.getInventory(), var1, var0, var2);
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack var0, EnumHand var1) {
        if (var0.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            if (WrittenBookContent.resolveForItem(var0, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new PacketPlayOutOpenBook(var1));
        }
    }

    @Override
    public void openCommandBlock(TileEntityCommand var0) {
        this.connection.send(PacketPlayOutTileEntityData.create(var0, TileEntity::saveCustomOnly));
    }

    @Override
    public void closeContainer() {
        this.connection.send(new PacketPlayOutCloseWindow(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void rideTick() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - var0, this.getY() - var2, this.getZ() - var4);
    }

    public void checkMovementStatistics(double var0, double var2, double var4) {
        if (this.isPassenger() || EntityPlayer.didNotMove(var0, var2, var4)) {
            return;
        }
        if (this.isSwimming()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.SWIM_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.isEyeInFluid(TagsFluid.WATER)) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.WALK_UNDER_WATER_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.isInWater()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.WALK_ON_WATER_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.onClimbable()) {
            if (var2 > 0.0) {
                this.awardStat(StatisticList.CLIMB_ONE_CM, (int)Math.round(var2 * 100.0));
            }
        } else if (this.onGround()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                if (this.isSprinting()) {
                    this.awardStat(StatisticList.SPRINT_ONE_CM, var6);
                    this.causeFoodExhaustion(0.1f * (float)var6 * 0.01f);
                } else if (this.isCrouching()) {
                    this.awardStat(StatisticList.CROUCH_ONE_CM, var6);
                    this.causeFoodExhaustion(0.0f * (float)var6 * 0.01f);
                } else {
                    this.awardStat(StatisticList.WALK_ONE_CM, var6);
                    this.causeFoodExhaustion(0.0f * (float)var6 * 0.01f);
                }
            }
        } else if (this.isFallFlying()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            this.awardStat(StatisticList.AVIATE_ONE_CM, var6);
        } else {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 25) {
                this.awardStat(StatisticList.FLY_ONE_CM, var6);
            }
        }
    }

    private void checkRidingStatistics(double var0, double var2, double var4) {
        if (!this.isPassenger() || EntityPlayer.didNotMove(var0, var2, var4)) {
            return;
        }
        int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
        Entity var7 = this.getVehicle();
        if (var7 instanceof EntityMinecartAbstract) {
            this.awardStat(StatisticList.MINECART_ONE_CM, var6);
        } else if (var7 instanceof AbstractBoat) {
            this.awardStat(StatisticList.BOAT_ONE_CM, var6);
        } else if (var7 instanceof EntityPig) {
            this.awardStat(StatisticList.PIG_ONE_CM, var6);
        } else if (var7 instanceof EntityHorseAbstract) {
            this.awardStat(StatisticList.HORSE_ONE_CM, var6);
        } else if (var7 instanceof EntityStrider) {
            this.awardStat(StatisticList.STRIDER_ONE_CM, var6);
        } else if (var7 instanceof HappyGhast) {
            this.awardStat(StatisticList.HAPPY_GHAST_ONE_CM, var6);
        } else if (var7 instanceof AbstractNautilus) {
            this.awardStat(StatisticList.NAUTILUS_ONE_CM, var6);
        }
    }

    private static boolean didNotMove(double var0, double var2, double var4) {
        return var0 == 0.0 && var2 == 0.0 && var4 == 0.0;
    }

    @Override
    public void awardStat(Statistic<?> var0, int var12) {
        this.stats.increment(this, var0, var12);
        this.level().getScoreboard().forAllObjectives(var0, this, var1 -> var1.add(var12));
    }

    @Override
    public void resetStat(Statistic<?> var0) {
        this.stats.setValue(this, var0, 0);
        this.level().getScoreboard().forAllObjectives(var0, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> var0) {
        return this.recipeBook.addRecipes(var0, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> var0, List<ItemStack> var1) {
        CriterionTriggers.RECIPE_CRAFTED.trigger(this, var0.id(), var1);
    }

    @Override
    public void awardRecipesByKey(List<ResourceKey<IRecipe<?>>> var02) {
        List<RecipeHolder<?>> var1 = var02.stream().flatMap(var0 -> this.server.getRecipeManager().byKey((ResourceKey<IRecipe<?>>)var0).stream()).collect(Collectors.toList());
        this.awardRecipes(var1);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> var0) {
        return this.recipeBook.removeRecipes(var0, this);
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(StatisticList.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(0.2f);
        } else {
            this.causeFoodExhaustion(0.05f);
        }
    }

    @Override
    public void giveExperiencePoints(int var0) {
        if (var0 == 0) {
            return;
        }
        super.giveExperiencePoints(var0);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
    }

    @Override
    public void displayClientMessage(IChatBaseComponent var0, boolean var1) {
        this.sendSystemMessage(var0, var1);
    }

    @Override
    protected void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new PacketPlayOutEntityStatus(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        super.lookAt(var0, var1);
        this.connection.send(new PacketPlayOutLookAt(var0, var1.x, var1.y, var1.z));
    }

    public void lookAt(ArgumentAnchor.Anchor var0, Entity var1, ArgumentAnchor.Anchor var2) {
        Vec3D var3 = var2.apply(var1);
        super.lookAt(var0, var3);
        this.connection.send(new PacketPlayOutLookAt(var0, var1, var2));
    }

    public void restoreFrom(EntityPlayer var0, boolean var1) {
        this.wardenSpawnTracker = var0.wardenSpawnTracker;
        this.chatSession = var0.chatSession;
        this.gameMode.setGameModeForPlayer(var0.gameMode.getGameModeForPlayer(), var0.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        this.getAttributes().assignBaseValues(var0.getAttributes());
        if (var1) {
            this.getAttributes().assignPermanentModifiers(var0.getAttributes());
            this.setHealth(var0.getHealth());
            this.foodData = var0.foodData;
            for (MobEffect var3 : var0.getActiveEffects()) {
                this.addEffect(new MobEffect(var3));
            }
            this.transferInventoryXpAndScore(var0);
            this.portalProcess = var0.portalProcess;
        } else {
            this.setHealth(this.getMaxHealth());
            if (this.level().getGameRules().get(GameRules.KEEP_INVENTORY).booleanValue() || var0.isSpectator()) {
                this.transferInventoryXpAndScore(var0);
            }
        }
        this.enchantmentSeed = var0.enchantmentSeed;
        this.enderChestInventory = var0.enderChestInventory;
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Byte)var0.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.recipeBook.copyOverData(var0.recipeBook);
        this.seenCredits = var0.seenCredits;
        this.enteredNetherPosition = var0.enteredNetherPosition;
        this.chunkTrackingView = var0.chunkTrackingView;
        this.requestedDebugSubscriptions = var0.requestedDebugSubscriptions;
        this.setShoulderEntityLeft(var0.getShoulderEntityLeft());
        this.setShoulderEntityRight(var0.getShoulderEntityRight());
        this.setLastDeathLocation(var0.getLastDeathLocation());
        this.waypointIcon().copyFrom(var0.waypointIcon());
    }

    private void transferInventoryXpAndScore(EntityHuman var0) {
        this.getInventory().replaceWith(var0.getInventory());
        this.experienceLevel = var0.experienceLevel;
        this.totalExperience = var0.totalExperience;
        this.experienceProgress = var0.experienceProgress;
        this.setScore(var0.getScore());
    }

    @Override
    protected void onEffectAdded(MobEffect var0, @Nullable Entity var1) {
        super.onEffectAdded(var0, var1);
        this.connection.send(new PacketPlayOutEntityEffect(this.getId(), var0, true));
        if (var0.is(MobEffects.LEVITATION)) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, var1);
    }

    @Override
    protected void onEffectUpdated(MobEffect var0, boolean var1, @Nullable Entity var2) {
        super.onEffectUpdated(var0, var1, var2);
        this.connection.send(new PacketPlayOutEntityEffect(this.getId(), var0, false));
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, var2);
    }

    @Override
    protected void onEffectsRemoved(Collection<MobEffect> var0) {
        super.onEffectsRemoved(var0);
        for (MobEffect var2 : var0) {
            this.connection.send(new PacketPlayOutRemoveEntityEffect(this.getId(), var2.getEffect()));
            if (!var2.is(MobEffects.LEVITATION)) continue;
            this.levitationStartPos = null;
        }
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, (Entity)null);
    }

    @Override
    public void teleportTo(double var0, double var2, double var4) {
        this.connection.teleport(new PositionMoveRotation(new Vec3D(var0, var2, var4), Vec3D.ZERO, 0.0f, 0.0f), Relative.union(Relative.DELTA, Relative.ROTATION));
    }

    @Override
    public void teleportRelative(double var0, double var2, double var4) {
        this.connection.teleport(new PositionMoveRotation(new Vec3D(var0, var2, var4), Vec3D.ZERO, 0.0f, 0.0f), Relative.ALL);
    }

    @Override
    public boolean teleportTo(WorldServer var0, double var1, double var3, double var5, Set<Relative> var7, float var8, float var9, boolean var10) {
        boolean var11;
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (var10) {
            this.setCamera(this);
        }
        if (var11 = super.teleportTo(var0, var1, var3, var5, var7, var8, var9, var10)) {
            this.setYHeadRot(var7.contains((Object)Relative.Y_ROT) ? this.getYHeadRot() + var8 : var8);
            this.connection.resetFlyingTicks();
        }
        return var11;
    }

    @Override
    public void snapTo(double var0, double var2, double var4) {
        super.snapTo(var0, var2, var4);
        this.connection.resetPosition();
    }

    @Override
    public void crit(Entity var0) {
        this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new PacketPlayOutAnimation(var0, 4));
    }

    @Override
    public void magicCrit(Entity var0) {
        this.level().getChunkSource().sendToTrackingPlayersAndSelf(this, new PacketPlayOutAnimation(var0, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection == null) {
            return;
        }
        this.connection.send(new PacketPlayOutAbilities(this.getAbilities()));
        this.updateInvisibilityStatus();
    }

    @Override
    public WorldServer level() {
        return (WorldServer)super.level();
    }

    public boolean setGameMode(EnumGamemode var0) {
        boolean var1 = this.isSpectator();
        if (!this.gameMode.changeGameModeForPlayer(var0)) {
            return false;
        }
        this.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.CHANGE_GAME_MODE, var0.getId()));
        if (var0 == EnumGamemode.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
            this.stopUsingItem();
            EnchantmentManager.stopLocationBasedEffects(this);
        } else {
            this.setCamera(this);
            if (var1) {
                EnchantmentManager.runLocationChangedEffects(this.level(), this);
            }
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return true;
    }

    @Override
    public EnumGamemode gameMode() {
        return this.gameMode.getGameModeForPlayer();
    }

    public ICommandListener commandSource() {
        return this.commandSource;
    }

    public CommandListenerWrapper createCommandSourceStack() {
        return new CommandListenerWrapper(this.commandSource(), this.position(), this.getRotationVector(), this.level(), this.permissions(), this.getPlainTextName(), this.getDisplayName(), this.server, this);
    }

    public void sendSystemMessage(IChatBaseComponent var0) {
        this.sendSystemMessage(var0, false);
    }

    public void sendSystemMessage(IChatBaseComponent var0, boolean var1) {
        if (!this.acceptsSystemMessages(var1)) {
            return;
        }
        this.connection.send(new ClientboundSystemChatPacket(var0, var1), PacketSendListener.exceptionallySend(() -> {
            if (this.acceptsSystemMessages(false)) {
                int var1 = 256;
                String var2 = var0.getString(256);
                IChatMutableComponent var3 = IChatBaseComponent.literal(var2).withStyle(EnumChatFormat.YELLOW);
                return new ClientboundSystemChatPacket(IChatBaseComponent.translatable("multiplayer.message_not_delivered", var3).withStyle(EnumChatFormat.RED), false);
            }
            return null;
        }));
    }

    public void sendChatMessage(OutgoingChatMessage var0, boolean var1, ChatMessageType.a var2) {
        if (this.acceptsChatMessages()) {
            var0.sendToPlayer(this, var1, var2);
        }
    }

    public String getIpAddress() {
        SocketAddress var0 = this.connection.getRemoteAddress();
        if (var0 instanceof InetSocketAddress) {
            InetSocketAddress var1 = (InetSocketAddress)var0;
            return InetAddresses.toAddrString((InetAddress)var1.getAddress());
        }
        return "<unknown>";
    }

    public void updateOptions(ClientInformation var0) {
        this.language = var0.language();
        this.requestedViewDistance = var0.viewDistance();
        this.chatVisibility = var0.chatVisibility();
        this.canChatColor = var0.chatColors();
        this.textFilteringEnabled = var0.textFilteringEnabled();
        this.allowsListing = var0.allowsListing();
        this.particleStatus = var0.particleStatus();
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (byte)var0.modelCustomisation());
        this.getEntityData().set(DATA_PLAYER_MAIN_HAND, var0.mainHand());
    }

    public ClientInformation clientInformation() {
        byte var0 = (Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, var0, this.getMainArm(), this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public EnumChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean var0) {
        if (this.chatVisibility == EnumChatVisibility.HIDDEN) {
            return var0;
        }
        return true;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == EnumChatVisibility.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerPing var0) {
        this.connection.send(new ClientboundServerDataPacket(var0.description(), var0.favicon().map(ServerPing.a::iconBytes)));
    }

    @Override
    public PermissionSet permissions() {
        return this.server.getProfilePermissions(this.nameAndId());
    }

    public void resetLastActionTime() {
        this.lastActionTime = SystemUtils.getMillis();
    }

    public ServerStatisticManager getStats() {
        return this.stats;
    }

    public RecipeBookServer getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable Entity var0) {
        Entity var1 = this.getCamera();
        Entity entity = this.camera = var0 == null ? this : var0;
        if (var1 != this.camera) {
            World world = this.camera.level();
            if (world instanceof WorldServer) {
                WorldServer var2 = (WorldServer)world;
                this.teleportTo(var2, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot(), false);
            }
            if (var0 != null) {
                this.level().getChunkSource().move(this);
            }
            this.connection.send(new PacketPlayOutCamera(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(Entity var0) {
        if (this.isSpectator()) {
            this.setCamera(var0);
        } else {
            super.attack(var0);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    public @Nullable IChatBaseComponent getTabListDisplayName() {
        return null;
    }

    public int getTabListOrder() {
        return 0;
    }

    @Override
    public void swing(EnumHand var0) {
        super.swing(var0);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public AdvancementDataPlayer getAdvancements() {
        return this.advancements;
    }

    public @Nullable RespawnConfig getRespawnConfig() {
        return this.respawnConfig;
    }

    public void copyRespawnPosition(EntityPlayer var0) {
        this.setRespawnPosition(var0.respawnConfig, false);
    }

    public void setRespawnPosition(@Nullable RespawnConfig var0, boolean var1) {
        if (var1 && var0 != null && !var0.isSamePosition(this.respawnConfig)) {
            this.sendSystemMessage(SPAWN_SET_MESSAGE);
        }
        this.respawnConfig = var0;
    }

    public SectionPosition getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPosition var0) {
        this.lastSectionPos = var0;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView var0) {
        this.chunkTrackingView = var0;
    }

    @Override
    public EntityItem drop(ItemStack var0, boolean var1, boolean var2) {
        EntityItem var3 = super.drop(var0, var1, var2);
        if (var2) {
            ItemStack var4;
            ItemStack itemStack = var4 = var3 != null ? var3.getItem() : ItemStack.EMPTY;
            if (!var4.isEmpty()) {
                this.awardStat(StatisticList.ITEM_DROPPED.get(var4.getItem()), var0.getCount());
                this.awardStat(StatisticList.DROP);
            }
        }
        return var3;
    }

    public ITextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(WorldServer var0) {
        this.setLevel(var0);
        this.gameMode.setLevel(var0);
    }

    private static @Nullable EnumGamemode readPlayerMode(ValueInput var0, String var1) {
        return var0.read(var1, EnumGamemode.LEGACY_ID_CODEC).orElse(null);
    }

    private EnumGamemode calculateGameModeForNewPlayer(@Nullable EnumGamemode var0) {
        EnumGamemode var1 = this.server.getForcedGameType();
        if (var1 != null) {
            return var1;
        }
        return var0 != null ? var0 : this.server.getDefaultGameType();
    }

    private void storeGameTypes(ValueOutput var0) {
        var0.store("playerGameType", EnumGamemode.LEGACY_ID_CODEC, this.gameMode.getGameModeForPlayer());
        EnumGamemode var1 = this.gameMode.getPreviousGameModeForPlayer();
        var0.storeNullable("previousPlayerGameType", EnumGamemode.LEGACY_ID_CODEC, var1);
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(EntityPlayer var0) {
        if (var0 == this) {
            return false;
        }
        return this.textFilteringEnabled || var0.textFilteringEnabled;
    }

    @Override
    public boolean mayInteract(WorldServer var0, BlockPosition var1) {
        return super.mayInteract(var0, var1) && var0.mayInteract(this, var1);
    }

    @Override
    protected void updateUsingItem(ItemStack var0) {
        CriterionTriggers.USING_ITEM.trigger(this, var0);
        super.updateUsingItem(var0);
    }

    public void drop(boolean var0) {
        PlayerInventory var12 = this.getInventory();
        ItemStack var2 = var12.removeFromSelected(var0);
        this.containerMenu.findSlot(var12, var12.getSelectedSlot()).ifPresent(var1 -> this.containerMenu.setRemoteSlot(var1, var12.getSelectedItem()));
        if (this.useItem.isEmpty()) {
            this.stopUsingItem();
        }
        this.drop(var2, false, true);
    }

    @Override
    public void handleExtraItemsCreatedOnUse(ItemStack var0) {
        if (!this.getInventory().add(var0)) {
            this.drop(var0, false);
        }
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    public void setSpawnExtraParticlesOnFall(boolean var0) {
        this.spawnExtraParticlesOnFall = var0;
    }

    @Override
    public void onItemPickup(EntityItem var0) {
        super.onItemPickup(var0);
        Entity var1 = var0.getOwner();
        if (var1 != null) {
            CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, var0.getItem(), var1);
        }
    }

    public void setChatSession(RemoteChatSession var0) {
        this.chatSession = var0;
    }

    public @Nullable RemoteChatSession getChatSession() {
        if (this.chatSession != null && this.chatSession.hasExpired()) {
            return null;
        }
        return this.chatSession;
    }

    @Override
    public void indicateDamage(double var0, double var2) {
        this.hurtDir = (float)(MathHelper.atan2(var2, var0) * 57.2957763671875 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1, boolean var2) {
        if (super.startRiding(var0, var1, var2)) {
            var0.positionRider(this);
            this.connection.teleport(new PositionMoveRotation(this.position(), Vec3D.ZERO, 0.0f, 0.0f), Relative.ROTATION);
            if (var0 instanceof EntityLiving) {
                EntityLiving var3 = (EntityLiving)var0;
                this.server.getPlayerList().sendActiveEffects(var3, this.connection);
            }
            this.connection.send(new PacketPlayOutMount(var0));
            return true;
        }
        return false;
    }

    @Override
    public void removeVehicle() {
        Entity var0 = this.getVehicle();
        super.removeVehicle();
        if (var0 instanceof EntityLiving) {
            EntityLiving var1 = (EntityLiving)var0;
            for (MobEffect var3 : var1.getActiveEffects()) {
                this.connection.send(new PacketPlayOutRemoveEntityEffect(var0.getId(), var3.getEffect()));
            }
        }
        if (var0 != null) {
            this.connection.send(new PacketPlayOutMount(var0));
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(WorldServer var0) {
        return new CommonPlayerSpawnInfo(var0.dimensionTypeRegistration(), var0.dimension(), BiomeManager.obfuscateSeed(var0.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), var0.isDebug(), var0.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown(), var0.getSeaLevel());
    }

    public void setRaidOmenPosition(BlockPosition var0) {
        this.raidOmenPosition = var0;
    }

    public void clearRaidOmenPosition() {
        this.raidOmenPosition = null;
    }

    public @Nullable BlockPosition getRaidOmenPosition() {
        return this.raidOmenPosition;
    }

    @Override
    public Vec3D getKnownMovement() {
        Entity var0 = this.getVehicle();
        if (var0 != null && var0.getControllingPassenger() != this) {
            return var0.getKnownMovement();
        }
        return this.lastKnownClientMovement;
    }

    @Override
    public Vec3D getKnownSpeed() {
        Entity var0 = this.getVehicle();
        if (var0 != null && var0.getControllingPassenger() != this) {
            return var0.getKnownSpeed();
        }
        return this.lastKnownClientMovement;
    }

    public void setKnownMovement(Vec3D var0) {
        this.lastKnownClientMovement = var0;
    }

    @Override
    protected float getEnchantedDamage(Entity var0, float var1, DamageSource var2) {
        return EnchantmentManager.modifyDamage(this.level(), this.getWeaponItem(), var0, var2, var1);
    }

    @Override
    public void onEquippedItemBroken(Item var0, EnumItemSlot var1) {
        super.onEquippedItemBroken(var0, var1);
        this.awardStat(StatisticList.ITEM_BROKEN.get(var0));
    }

    public Input getLastClientInput() {
        return this.lastClientInput;
    }

    public void setLastClientInput(Input var0) {
        this.lastClientInput = var0;
    }

    public Vec3D getLastClientMoveIntent() {
        float var0;
        float f2 = this.lastClientInput.left() == this.lastClientInput.right() ? 0.0f : (var0 = this.lastClientInput.left() ? 1.0f : -1.0f);
        float var1 = this.lastClientInput.forward() == this.lastClientInput.backward() ? 0.0f : (this.lastClientInput.forward() ? 1.0f : -1.0f);
        return EntityPlayer.getInputVector(new Vec3D(var0, 0.0, var1), 1.0f, this.getYRot());
    }

    public void registerEnderPearl(EntityEnderPearl var0) {
        this.enderPearls.add(var0);
    }

    public void deregisterEnderPearl(EntityEnderPearl var0) {
        this.enderPearls.remove(var0);
    }

    public Set<EntityEnderPearl> getEnderPearls() {
        return this.enderPearls;
    }

    public NBTTagCompound getShoulderEntityLeft() {
        return this.shoulderEntityLeft;
    }

    public void setShoulderEntityLeft(NBTTagCompound var0) {
        this.shoulderEntityLeft = var0;
        this.setShoulderParrotLeft(EntityPlayer.extractParrotVariant(var0));
    }

    public NBTTagCompound getShoulderEntityRight() {
        return this.shoulderEntityRight;
    }

    public void setShoulderEntityRight(NBTTagCompound var0) {
        this.shoulderEntityRight = var0;
        this.setShoulderParrotRight(EntityPlayer.extractParrotVariant(var0));
    }

    public long registerAndUpdateEnderPearlTicket(EntityEnderPearl var0) {
        World world = var0.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            ChunkCoordIntPair var2 = var0.chunkPosition();
            this.registerEnderPearl(var0);
            var1.resetEmptyTime();
            return EntityPlayer.placeEnderPearlTicket(var1, var2) - 1L;
        }
        return 0L;
    }

    public static long placeEnderPearlTicket(WorldServer var0, ChunkCoordIntPair var1) {
        var0.getChunkSource().addTicketWithRadius(TicketType.ENDER_PEARL, var1, 2);
        return TicketType.ENDER_PEARL.timeout();
    }

    public void requestDebugSubscriptions(Set<DebugSubscription<?>> var0) {
        this.requestedDebugSubscriptions = Set.copyOf(var0);
    }

    public Set<DebugSubscription<?>> debugSubscriptions() {
        if (!this.server.debugSubscribers().hasRequiredPermissions(this)) {
            return Set.of();
        }
        return this.requestedDebugSubscriptions;
    }

    @Override
    public /* synthetic */ World level() {
        return this.level();
    }

    @Override
    public /* synthetic */ @Nullable Entity teleport(TeleportTransition teleportTransition) {
        return this.teleport(teleportTransition);
    }

    private /* synthetic */ Packet d(IChatBaseComponent var0) {
        int var12 = 256;
        String var2 = var0.getString(256);
        IChatMutableComponent var3 = IChatBaseComponent.translatable("death.attack.message_too_long", IChatBaseComponent.literal(var2).withStyle(EnumChatFormat.YELLOW));
        IChatMutableComponent var4 = IChatBaseComponent.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(var1 -> var1.withHoverEvent(new ChatHoverable.e(var3)));
        return new ClientboundPlayerCombatKillPacket(this.getId(), var4);
    }

    public static final class RespawnConfig
    extends Record {
        final WorldData.a respawnData;
        final boolean forced;
        public static final Codec<RespawnConfig> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)WorldData.a.MAP_CODEC.forGetter(RespawnConfig::respawnData), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::forced)).apply((Applicative)var0, RespawnConfig::new));

        public RespawnConfig(WorldData.a var0, boolean var1) {
            this.respawnData = var0;
            this.forced = var1;
        }

        static ResourceKey<World> getDimensionOrDefault(@Nullable RespawnConfig var0) {
            return var0 != null ? var0.respawnData().dimension() : World.OVERWORLD;
        }

        public boolean isSamePosition(@Nullable RespawnConfig var0) {
            return var0 != null && this.respawnData.globalPos().equals(var0.respawnData.globalPos());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "respawnData", "forced"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "respawnData", "forced"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "respawnData", "forced"}, this, var0);
        }

        public WorldData.a respawnData() {
            return this.respawnData;
        }

        public boolean forced() {
            return this.forced;
        }
    }

    public record RespawnPosAngle(Vec3D position, float yaw, float pitch) {
        public static RespawnPosAngle of(Vec3D var0, BlockPosition var1, float var2) {
            return new RespawnPosAngle(var0, RespawnPosAngle.calculateLookAtYaw(var0, var1), var2);
        }

        private static float calculateLookAtYaw(Vec3D var0, BlockPosition var1) {
            Vec3D var2 = Vec3D.atBottomCenterOf(var1).subtract(var0).normalize();
            return (float)MathHelper.wrapDegrees(MathHelper.atan2(var2.z, var2.x) * 57.2957763671875 - 90.0);
        }
    }

    public record c(Optional<ResourceKey<World>> dimension, Optional<Vec3D> position, Optional<Vec2F> rotation) {
        public static final MapCodec<c> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)World.RESOURCE_KEY_CODEC.optionalFieldOf(EntityPlayer.TAG_DIMENSION).forGetter(c::dimension), (App)Vec3D.CODEC.optionalFieldOf("Pos").forGetter(c::position), (App)Vec2F.CODEC.optionalFieldOf("Rotation").forGetter(c::rotation)).apply((Applicative)var0, c::new));
        public static final c EMPTY = new c(Optional.empty(), Optional.empty(), Optional.empty());
    }
}

