/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Locale;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerInfo server;

    public LegacyPingHandler(ServerInfo var0) {
        this.server = var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext var0, Object var1) {
        ByteBuf var2 = (ByteBuf)var1;
        var2.markReaderIndex();
        boolean var3 = true;
        try {
            if (var2.readUnsignedByte() != 254) {
                return;
            }
            SocketAddress var4 = var0.channel().remoteAddress();
            int var5 = var2.readableBytes();
            if (var5 == 0) {
                LOGGER.debug("Ping: (<1.3.x) from {}", (Object)var4);
                String var6 = LegacyPingHandler.createVersion0Response(this.server);
                LegacyPingHandler.sendFlushAndClose(var0, LegacyPingHandler.createLegacyDisconnectPacket(var0.alloc(), var6));
            } else {
                if (var2.readUnsignedByte() != 1) {
                    return;
                }
                if (var2.isReadable()) {
                    if (!LegacyPingHandler.readCustomPayloadPacket(var2)) {
                        return;
                    }
                    LOGGER.debug("Ping: (1.6) from {}", (Object)var4);
                } else {
                    LOGGER.debug("Ping: (1.4-1.5.x) from {}", (Object)var4);
                }
                String var6 = LegacyPingHandler.createVersion1Response(this.server);
                LegacyPingHandler.sendFlushAndClose(var0, LegacyPingHandler.createLegacyDisconnectPacket(var0.alloc(), var6));
            }
            var2.release();
            var3 = false;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (var3) {
                var2.resetReaderIndex();
                var0.channel().pipeline().remove((ChannelHandler)this);
                var0.fireChannelRead(var1);
            }
        }
    }

    private static boolean readCustomPayloadPacket(ByteBuf var0) {
        short var1 = var0.readUnsignedByte();
        if (var1 != 250) {
            return false;
        }
        String var2 = LegacyProtocolUtils.readLegacyString(var0);
        if (!"MC|PingHost".equals(var2)) {
            return false;
        }
        int var3 = var0.readUnsignedShort();
        if (var0.readableBytes() != var3) {
            return false;
        }
        short var4 = var0.readUnsignedByte();
        if (var4 < 73) {
            return false;
        }
        String var5 = LegacyProtocolUtils.readLegacyString(var0);
        int var6 = var0.readInt();
        return var6 <= 65535;
    }

    private static String createVersion0Response(ServerInfo var0) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", var0.getMotd(), var0.getPlayerCount(), var0.getMaxPlayers());
    }

    private static String createVersion1Response(ServerInfo var0) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, var0.getServerVersion(), var0.getMotd(), var0.getPlayerCount(), var0.getMaxPlayers());
    }

    private static void sendFlushAndClose(ChannelHandlerContext var0, ByteBuf var1) {
        var0.pipeline().firstContext().writeAndFlush((Object)var1).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf createLegacyDisconnectPacket(ByteBufAllocator var0, String var1) {
        ByteBuf var2 = var0.buffer();
        var2.writeByte(255);
        LegacyProtocolUtils.writeLegacyString(var2, var1);
        return var2;
    }
}

