/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.util.InclusiveRange;

public final class EnumResourcePackVersion
extends Enum<EnumResourcePackVersion> {
    public static final /* enum */ EnumResourcePackVersion TOO_OLD = new EnumResourcePackVersion("old");
    public static final /* enum */ EnumResourcePackVersion TOO_NEW = new EnumResourcePackVersion("new");
    public static final /* enum */ EnumResourcePackVersion UNKNOWN = new EnumResourcePackVersion("unknown");
    public static final /* enum */ EnumResourcePackVersion COMPATIBLE = new EnumResourcePackVersion("compatible");
    public static final int UNKNOWN_VERSION = Integer.MAX_VALUE;
    private final IChatBaseComponent description;
    private final IChatBaseComponent confirmation;
    private static final /* synthetic */ EnumResourcePackVersion[] h;

    public static EnumResourcePackVersion[] values() {
        return (EnumResourcePackVersion[])h.clone();
    }

    public static EnumResourcePackVersion valueOf(String var0) {
        return Enum.valueOf(EnumResourcePackVersion.class, var0);
    }

    private EnumResourcePackVersion(String var2) {
        this.description = IChatBaseComponent.translatable("pack.incompatible." + var2).withStyle(EnumChatFormat.GRAY);
        this.confirmation = IChatBaseComponent.translatable("pack.incompatible.confirm." + var2);
    }

    public boolean isCompatible() {
        return this == COMPATIBLE;
    }

    public static EnumResourcePackVersion forVersion(InclusiveRange<PackFormat> var0, PackFormat var1) {
        if (var0.minInclusive().major() == Integer.MAX_VALUE) {
            return UNKNOWN;
        }
        if (var0.maxInclusive().compareTo(var1) < 0) {
            return TOO_OLD;
        }
        if (var1.compareTo(var0.minInclusive()) < 0) {
            return TOO_NEW;
        }
        return COMPATIBLE;
    }

    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public IChatBaseComponent getConfirmation() {
        return this.confirmation;
    }

    private static /* synthetic */ EnumResourcePackVersion[] d() {
        return new EnumResourcePackVersion[]{TOO_OLD, TOO_NEW, UNKNOWN, COMPATIBLE};
    }

    static {
        h = EnumResourcePackVersion.d();
    }
}

