/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import org.jspecify.annotations.Nullable;

public record NameAndId(UUID id, String name) {
    public static final Codec<NameAndId> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(NameAndId::id), (App)Codec.STRING.fieldOf("name").forGetter(NameAndId::name)).apply((Applicative)var0, NameAndId::new));

    public NameAndId(GameProfile var0) {
        this(var0.id(), var0.name());
    }

    public NameAndId(com.mojang.authlib.yggdrasil.response.NameAndId var0) {
        this(var0.id(), var0.name());
    }

    public static @Nullable NameAndId fromJson(JsonObject var0) {
        UUID var2;
        if (!var0.has("uuid") || !var0.has("name")) {
            return null;
        }
        String var1 = var0.get("uuid").getAsString();
        try {
            var2 = UUID.fromString(var1);
        }
        catch (Throwable var3) {
            return null;
        }
        return new NameAndId(var2, var0.get("name").getAsString());
    }

    public void appendTo(JsonObject var0) {
        var0.addProperty("uuid", this.id().toString());
        var0.addProperty("name", this.name());
    }

    public static NameAndId createOffline(String var0) {
        UUID var1 = UUIDUtil.createOfflinePlayerUUID(var0);
        return new NameAndId(var1, var0);
    }
}

