/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon;

import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class RemoteControlCommandListener
implements ICommandListener {
    private static final String RCON = "Rcon";
    private static final IChatBaseComponent RCON_COMPONENT = IChatBaseComponent.literal("Rcon");
    private final StringBuffer buffer = new StringBuffer();
    private final MinecraftServer server;

    public RemoteControlCommandListener(MinecraftServer var0) {
        this.server = var0;
    }

    public void prepareForCommand() {
        this.buffer.setLength(0);
    }

    public String getCommandResponse() {
        return this.buffer.toString();
    }

    public CommandListenerWrapper createCommandSourceStack() {
        WorldServer var0 = this.server.overworld();
        return new CommandListenerWrapper(this, Vec3D.atLowerCornerOf(var0.getRespawnData().pos()), Vec2F.ZERO, var0, LevelBasedPermissionSet.OWNER, RCON, RCON_COMPONENT, this.server, null);
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent var0) {
        this.buffer.append(var0.getString());
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.server.shouldRconBroadcast();
    }
}

