/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockUtil {
    public static Rectangle getLargestRectangleAround(BlockPosition var0, EnumDirection.EnumAxis var1, int var2, EnumDirection.EnumAxis var3, int var4, Predicate<BlockPosition> var5) {
        IntBounds var17;
        int var16;
        BlockPosition.MutableBlockPosition var6 = var0.mutable();
        EnumDirection var7 = EnumDirection.get(EnumDirection.EnumAxisDirection.NEGATIVE, var1);
        EnumDirection var8 = var7.getOpposite();
        EnumDirection var9 = EnumDirection.get(EnumDirection.EnumAxisDirection.NEGATIVE, var3);
        EnumDirection var10 = var9.getOpposite();
        int var11 = BlockUtil.getLimit(var5, var6.set(var0), var7, var2);
        int var12 = BlockUtil.getLimit(var5, var6.set(var0), var8, var2);
        int var13 = var11;
        IntBounds[] var14 = new IntBounds[var13 + 1 + var12];
        var14[var13] = new IntBounds(BlockUtil.getLimit(var5, var6.set(var0), var9, var4), BlockUtil.getLimit(var5, var6.set(var0), var10, var4));
        int var15 = var14[var13].min;
        for (var16 = 1; var16 <= var11; ++var16) {
            var17 = var14[var13 - (var16 - 1)];
            var14[var13 - var16] = new IntBounds(BlockUtil.getLimit(var5, var6.set(var0).move(var7, var16), var9, var17.min), BlockUtil.getLimit(var5, var6.set(var0).move(var7, var16), var10, var17.max));
        }
        for (var16 = 1; var16 <= var12; ++var16) {
            var17 = var14[var13 + var16 - 1];
            var14[var13 + var16] = new IntBounds(BlockUtil.getLimit(var5, var6.set(var0).move(var8, var16), var9, var17.min), BlockUtil.getLimit(var5, var6.set(var0).move(var8, var16), var10, var17.max));
        }
        var16 = 0;
        int var172 = 0;
        int var18 = 0;
        int var19 = 0;
        int[] var20 = new int[var14.length];
        for (int var21 = var15; var21 >= 0; --var21) {
            int var25;
            int var24;
            IntBounds var23;
            for (int var22 = 0; var22 < var14.length; ++var22) {
                var23 = var14[var22];
                var24 = var15 - var23.min;
                var25 = var15 + var23.max;
                var20[var22] = var21 >= var24 && var21 <= var25 ? var25 + 1 - var21 : 0;
            }
            Pair<IntBounds, Integer> var22 = BlockUtil.getMaxRectangleLocation(var20);
            var23 = (IntBounds)var22.getFirst();
            var24 = 1 + var23.max - var23.min;
            var25 = (Integer)var22.getSecond();
            if (var24 * var25 <= var18 * var19) continue;
            var16 = var23.min;
            var172 = var21;
            var18 = var24;
            var19 = var25;
        }
        return new Rectangle(var0.relative(var1, var16 - var13).relative(var3, var172 - var15), var18, var19);
    }

    private static int getLimit(Predicate<BlockPosition> var0, BlockPosition.MutableBlockPosition var1, EnumDirection var2, int var3) {
        int var4;
        for (var4 = 0; var4 < var3 && var0.test(var1.move(var2)); ++var4) {
        }
        return var4;
    }

    @VisibleForTesting
    static Pair<IntBounds, Integer> getMaxRectangleLocation(int[] var0) {
        int var1 = 0;
        int var2 = 0;
        int var3 = 0;
        IntArrayList var4 = new IntArrayList();
        var4.push(0);
        for (int var5 = 1; var5 <= var0.length; ++var5) {
            int var6;
            int n2 = var6 = var5 == var0.length ? 0 : var0[var5];
            while (!var4.isEmpty()) {
                int var7 = var0[var4.topInt()];
                if (var6 >= var7) {
                    var4.push(var5);
                    break;
                }
                var4.popInt();
                int var8 = var4.isEmpty() ? 0 : var4.topInt() + 1;
                if (var7 * (var5 - var8) <= var3 * (var2 - var1)) continue;
                var2 = var5;
                var1 = var8;
                var3 = var7;
            }
            if (!var4.isEmpty()) continue;
            var4.push(var5);
        }
        return new Pair((Object)new IntBounds(var1, var2 - 1), (Object)var3);
    }

    public static Optional<BlockPosition> getTopConnectedBlock(IBlockAccess var0, BlockPosition var1, Block var2, EnumDirection var3, Block var4) {
        IBlockData var6;
        BlockPosition.MutableBlockPosition var5 = var1.mutable();
        do {
            var5.move(var3);
        } while ((var6 = var0.getBlockState(var5)).is(var2));
        if (var6.is(var4)) {
            return Optional.of(var5);
        }
        return Optional.empty();
    }

    public static class IntBounds {
        public final int min;
        public final int max;

        public IntBounds(int var0, int var1) {
            this.min = var0;
            this.max = var1;
        }

        public String toString() {
            return "IntBounds{min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static class Rectangle {
        public final BlockPosition minCorner;
        public final int axis1Size;
        public final int axis2Size;

        public Rectangle(BlockPosition var0, int var1, int var2) {
            this.minCorner = var0;
            this.axis1Size = var1;
            this.axis2Size = var2;
        }
    }
}

