/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jspecify.annotations.Nullable;

public class CSVWriter {
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String FIELD_SEPARATOR = ",";
    private final Writer output;
    private final int columnCount;

    CSVWriter(Writer var0, List<String> var1) throws IOException {
        this.output = var0;
        this.columnCount = var1.size();
        this.writeLine(var1.stream());
    }

    public static a builder() {
        return new a();
    }

    public void writeRow(Object ... var0) throws IOException {
        if (var0.length != this.columnCount) {
            throw new IllegalArgumentException("Invalid number of columns, expected " + this.columnCount + ", but got " + var0.length);
        }
        this.writeLine(Stream.of(var0));
    }

    private void writeLine(Stream<? extends @Nullable Object> var0) throws IOException {
        this.output.write(var0.map(CSVWriter::getStringValue).collect(Collectors.joining(FIELD_SEPARATOR)) + LINE_SEPARATOR);
    }

    private static String getStringValue(@Nullable Object var0) {
        return StringEscapeUtils.escapeCsv((String)(var0 != null ? var0.toString() : "[null]"));
    }

    public static class a {
        private final List<String> headers = Lists.newArrayList();

        public a addColumn(String var0) {
            this.headers.add(var0);
            return this;
        }

        public CSVWriter build(Writer var0) throws IOException {
            return new CSVWriter(var0, this.headers);
        }
    }
}

