/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DependencySorter<K, V extends a<K>> {
    private final Map<K, V> contents = new HashMap();

    public DependencySorter<K, V> addEntry(K var0, V var1) {
        this.contents.put(var0, var1);
        return this;
    }

    private void visitDependenciesAndElement(Multimap<K, K> var0, Set<K> var1, K var2, BiConsumer<K, V> var32) {
        if (!var1.add(var2)) {
            return;
        }
        var0.get(var2).forEach(var3 -> this.visitDependenciesAndElement(var0, var1, var3, var32));
        a var4 = (a)this.contents.get(var2);
        if (var4 != null) {
            var32.accept(var2, var4);
        }
    }

    private static <K> boolean isCyclic(Multimap<K, K> var0, K var1, K var22) {
        Collection var3 = var0.get(var22);
        if (var3.contains(var1)) {
            return true;
        }
        return var3.stream().anyMatch(var2 -> DependencySorter.isCyclic(var0, var1, var2));
    }

    private static <K> void addDependencyIfNotCyclic(Multimap<K, K> var0, K var1, K var2) {
        if (!DependencySorter.isCyclic(var0, var1, var2)) {
            var0.put(var1, var2);
        }
    }

    public void orderByDependencies(BiConsumer<K, V> var0) {
        HashMultimap var1 = HashMultimap.create();
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.b((Multimap)var1, arg_0, arg_1));
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.a((Multimap)var1, arg_0, arg_1));
        HashSet var2 = new HashSet();
        this.contents.keySet().forEach(arg_0 -> this.a((Multimap)var1, var2, var0, arg_0));
    }

    private /* synthetic */ void a(Multimap var0, Set var1, BiConsumer var2, Object var3) {
        this.visitDependenciesAndElement(var0, var1, var3, var2);
    }

    private static /* synthetic */ void a(Multimap var0, Object var1, a var22) {
        var22.visitOptionalDependencies(var2 -> DependencySorter.addDependencyIfNotCyclic(var0, var1, var2));
    }

    private static /* synthetic */ void b(Multimap var0, Object var1, a var22) {
        var22.visitRequiredDependencies(var2 -> DependencySorter.addDependencyIfNotCyclic(var0, var1, var2));
    }

    public static interface a<K> {
        public void visitRequiredDependencies(Consumer<K> var1);

        public void visitOptionalDependencies(Consumer<K> var1);
    }
}

