/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.util.Ease;
import net.minecraft.util.ExtraCodecs;

public interface EasingType {
    public static final ExtraCodecs.b<String, EasingType> SIMPLE_REGISTRY = new ExtraCodecs.b();
    public static final Codec<EasingType> CODEC = Codec.either(SIMPLE_REGISTRY.codec((Codec<String>)Codec.STRING), a.CODEC).xmap(Either::unwrap, var0 -> {
        Either either;
        if (var0 instanceof a) {
            a var1 = (a)var0;
            either = Either.right((Object)var1);
        } else {
            either = Either.left((Object)var0);
        }
        return either;
    });
    public static final EasingType CONSTANT = EasingType.registerSimple("constant", var0 -> 0.0f);
    public static final EasingType LINEAR = EasingType.registerSimple("linear", var0 -> var0);
    public static final EasingType IN_BACK = EasingType.registerSimple("in_back", Ease::inBack);
    public static final EasingType IN_BOUNCE = EasingType.registerSimple("in_bounce", Ease::inBounce);
    public static final EasingType IN_CIRC = EasingType.registerSimple("in_circ", Ease::inCirc);
    public static final EasingType IN_CUBIC = EasingType.registerSimple("in_cubic", Ease::inCubic);
    public static final EasingType IN_ELASTIC = EasingType.registerSimple("in_elastic", Ease::inElastic);
    public static final EasingType IN_EXPO = EasingType.registerSimple("in_expo", Ease::inExpo);
    public static final EasingType IN_QUAD = EasingType.registerSimple("in_quad", Ease::inQuad);
    public static final EasingType IN_QUART = EasingType.registerSimple("in_quart", Ease::inQuart);
    public static final EasingType IN_QUINT = EasingType.registerSimple("in_quint", Ease::inQuint);
    public static final EasingType IN_SINE = EasingType.registerSimple("in_sine", Ease::inSine);
    public static final EasingType IN_OUT_BACK = EasingType.registerSimple("in_out_back", Ease::inOutBack);
    public static final EasingType IN_OUT_BOUNCE = EasingType.registerSimple("in_out_bounce", Ease::inOutBounce);
    public static final EasingType IN_OUT_CIRC = EasingType.registerSimple("in_out_circ", Ease::inOutCirc);
    public static final EasingType IN_OUT_CUBIC = EasingType.registerSimple("in_out_cubic", Ease::inOutCubic);
    public static final EasingType IN_OUT_ELASTIC = EasingType.registerSimple("in_out_elastic", Ease::inOutElastic);
    public static final EasingType IN_OUT_EXPO = EasingType.registerSimple("in_out_expo", Ease::inOutExpo);
    public static final EasingType IN_OUT_QUAD = EasingType.registerSimple("in_out_quad", Ease::inOutQuad);
    public static final EasingType IN_OUT_QUART = EasingType.registerSimple("in_out_quart", Ease::inOutQuart);
    public static final EasingType IN_OUT_QUINT = EasingType.registerSimple("in_out_quint", Ease::inOutQuint);
    public static final EasingType IN_OUT_SINE = EasingType.registerSimple("in_out_sine", Ease::inOutSine);
    public static final EasingType OUT_BACK = EasingType.registerSimple("out_back", Ease::outBack);
    public static final EasingType OUT_BOUNCE = EasingType.registerSimple("out_bounce", Ease::outBounce);
    public static final EasingType OUT_CIRC = EasingType.registerSimple("out_circ", Ease::outCirc);
    public static final EasingType OUT_CUBIC = EasingType.registerSimple("out_cubic", Ease::outCubic);
    public static final EasingType OUT_ELASTIC = EasingType.registerSimple("out_elastic", Ease::outElastic);
    public static final EasingType OUT_EXPO = EasingType.registerSimple("out_expo", Ease::outExpo);
    public static final EasingType OUT_QUAD = EasingType.registerSimple("out_quad", Ease::outQuad);
    public static final EasingType OUT_QUART = EasingType.registerSimple("out_quart", Ease::outQuart);
    public static final EasingType OUT_QUINT = EasingType.registerSimple("out_quint", Ease::outQuint);
    public static final EasingType OUT_SINE = EasingType.registerSimple("out_sine", Ease::outSine);

    public static EasingType registerSimple(String var0, EasingType var1) {
        SIMPLE_REGISTRY.put(var0, var1);
        return var1;
    }

    public static EasingType cubicBezier(float var0, float var1, float var2, float var3) {
        return new a(new b(var0, var1, var2, var3));
    }

    public static EasingType symmetricCubicBezier(float var0, float var1) {
        return EasingType.cubicBezier(var0, var1, 1.0f - var0, 1.0f - var1);
    }

    public float apply(float var1);

    public static final class net.minecraft.util.EasingType$a
    implements EasingType {
        public static final Codec<net.minecraft.util.EasingType$a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)b.CODEC.fieldOf("cubic_bezier").forGetter(var0 -> var0.controls)).apply((Applicative)var02, net.minecraft.util.EasingType$a::new));
        private static final int NEWTON_RAPHSON_ITERATIONS = 4;
        private final b controls;
        private final a xCurve;
        private final a yCurve;

        public net.minecraft.util.EasingType$a(b var0) {
            this.controls = var0;
            this.xCurve = net.minecraft.util.EasingType$a.curveFromControls(var0.x1, var0.x2);
            this.yCurve = net.minecraft.util.EasingType$a.curveFromControls(var0.y1, var0.y2);
        }

        private static a curveFromControls(float var0, float var1) {
            return new a(3.0f * var0 - 3.0f * var1 + 1.0f, -6.0f * var0 + 3.0f * var1, 3.0f * var0);
        }

        @Override
        public float apply(float var0) {
            float var3;
            float var1 = var0;
            for (int var2 = 0; var2 < 4 && !((var3 = this.xCurve.sampleGradient(var1)) < 1.0E-5f); ++var2) {
                float var4 = this.xCurve.sample(var1) - var0;
                var1 -= var4 / var3;
            }
            return this.yCurve.sample(var1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object var0) {
            if (!(var0 instanceof net.minecraft.util.EasingType$a)) return false;
            net.minecraft.util.EasingType$a var1 = (net.minecraft.util.EasingType$a)var0;
            if (!this.controls.equals(var1.controls)) return false;
            return true;
        }

        public int hashCode() {
            return this.controls.hashCode();
        }

        public String toString() {
            return "CubicBezier(" + this.controls.x1 + ", " + this.controls.y1 + ", " + this.controls.x2 + ", " + this.controls.y2 + ")";
        }

        record a(float a, float b, float c) {
            public float sample(float var0) {
                return ((this.a * var0 + this.b) * var0 + this.c) * var0;
            }

            public float sampleGradient(float var0) {
                return (3.0f * this.a * var0 + 2.0f * this.b) * var0 + this.c;
            }
        }
    }

    public static final class b
    extends Record {
        final float x1;
        final float y1;
        final float x2;
        final float y2;
        public static final Codec<b> CODEC = Codec.FLOAT.listOf(4, 4).xmap(var0 -> new b(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue(), ((Float)var0.get(3)).floatValue()), var0 -> List.of(Float.valueOf(var0.x1), Float.valueOf(var0.y1), Float.valueOf(var0.x2), Float.valueOf(var0.y2))).validate(b::validate);

        public b(float var0, float var1, float var2, float var3) {
            this.x1 = var0;
            this.y1 = var1;
            this.x2 = var2;
            this.y2 = var3;
        }

        private DataResult<b> validate() {
            if (this.x1 < 0.0f || this.x1 > 1.0f) {
                return DataResult.error(() -> "x1 must be in range [0; 1]");
            }
            if (this.x2 < 0.0f || this.x2 > 1.0f) {
                return DataResult.error(() -> "x2 must be in range [0; 1]");
            }
            return DataResult.success((Object)this);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "x1;y1;x2;y2", "x1", "y1", "x2", "y2"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "x1;y1;x2;y2", "x1", "y1", "x2", "y2"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "x1;y1;x2;y2", "x1", "y1", "x2", "y2"}, this, var0);
        }

        public float x1() {
            return this.x1;
        }

        public float y1() {
            return this.y1;
        }

        public float x2() {
            return this.x2;
        }

        public float y2() {
            return this.y2;
        }
    }
}

