/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.SystemUtils;
import org.slf4j.Logger;

public class FileZipper
implements Closeable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path outputFile;
    private final Path tempFile;
    private final FileSystem fs;

    public FileZipper(Path var0) {
        this.outputFile = var0;
        this.tempFile = var0.resolveSibling(var0.getFileName().toString() + "_tmp");
        try {
            this.fs = SystemUtils.ZIP_FILE_SYSTEM_PROVIDER.newFileSystem(this.tempFile, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));
        }
        catch (IOException var1) {
            throw new UncheckedIOException(var1);
        }
    }

    public void add(Path var0, String var1) {
        try {
            Path var2 = this.fs.getPath(File.separator, new String[0]);
            Path var3 = var2.resolve(var0.toString());
            Files.createDirectories(var3.getParent(), new FileAttribute[0]);
            Files.write(var3, var1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException var2) {
            throw new UncheckedIOException(var2);
        }
    }

    public void add(Path var0, File var1) {
        try {
            Path var2 = this.fs.getPath(File.separator, new String[0]);
            Path var3 = var2.resolve(var0.toString());
            Files.createDirectories(var3.getParent(), new FileAttribute[0]);
            Files.copy(var1.toPath(), var3, new CopyOption[0]);
        }
        catch (IOException var2) {
            throw new UncheckedIOException(var2);
        }
    }

    public void add(Path var02) {
        try {
            Path var12 = this.fs.getPath(File.separator, new String[0]);
            if (Files.isRegularFile(var02, new LinkOption[0])) {
                Path var2 = var12.resolve(var02.getParent().relativize(var02).toString());
                Files.copy(var2, var02, new CopyOption[0]);
                return;
            }
            try (Stream<Path> var2 = Files.find(var02, Integer.MAX_VALUE, (var0, var1) -> var1.isRegularFile(), new FileVisitOption[0]);){
                for (Path var4 : var2.collect(Collectors.toList())) {
                    Path var5 = var12.resolve(var02.relativize(var4).toString());
                    Files.createDirectories(var5.getParent(), new FileAttribute[0]);
                    Files.copy(var4, var5, new CopyOption[0]);
                }
            }
        }
        catch (IOException var13) {
            throw new UncheckedIOException(var13);
        }
    }

    @Override
    public void close() {
        try {
            this.fs.close();
            Files.move(this.tempFile, this.outputFile, new CopyOption[0]);
            LOGGER.info("Compressed to {}", (Object)this.outputFile);
        }
        catch (IOException var0) {
            throw new UncheckedIOException(var0);
        }
    }
}

