/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.world.attribute.LerpFunction;

public class KeyframeTrackSampler<T> {
    private final Optional<Integer> periodTicks;
    private final LerpFunction<T> lerp;
    private final List<a<T>> segments;

    KeyframeTrackSampler(KeyframeTrack<T> var0, Optional<Integer> var1, LerpFunction<T> var2) {
        this.periodTicks = var1;
        this.lerp = var2;
        this.segments = KeyframeTrackSampler.bakeSegments(var0, var1);
    }

    private static <T> List<a<T>> bakeSegments(KeyframeTrack<T> var0, Optional<Integer> var1) {
        List<Keyframe<T>> var2 = var0.keyframes();
        if (var2.size() == 1) {
            T var3 = var2.getFirst().value();
            return List.of(new a<T>(EasingType.CONSTANT, var3, 0, var3, 0));
        }
        ArrayList<a<T>> var3 = new ArrayList<a<T>>();
        if (var1.isPresent()) {
            Keyframe<T> var4 = var2.getFirst();
            Keyframe<T> var5 = var2.getLast();
            var3.add(new a<T>(var0, var5, var5.ticks() - var1.get(), var4, var4.ticks()));
            KeyframeTrackSampler.addSegmentsFromKeyframes(var0, var2, var3);
            var3.add(new a<T>(var0, var5, var5.ticks(), var4, var4.ticks() + var1.get()));
        } else {
            KeyframeTrackSampler.addSegmentsFromKeyframes(var0, var2, var3);
        }
        return List.copyOf(var3);
    }

    private static <T> void addSegmentsFromKeyframes(KeyframeTrack<T> var0, List<Keyframe<T>> var1, List<a<T>> var2) {
        for (int var3 = 0; var3 < var1.size() - 1; ++var3) {
            Keyframe<T> var4 = var1.get(var3);
            Keyframe<T> var5 = var1.get(var3 + 1);
            var2.add(new a<T>(var0, var4, var4.ticks(), var5, var5.ticks()));
        }
    }

    public T sample(long var0) {
        long var2 = this.loopTicks(var0);
        a<T> var4 = this.getSegmentAt(var2);
        if (var2 <= (long)var4.fromTicks) {
            return var4.fromValue;
        }
        if (var2 >= (long)var4.toTicks) {
            return var4.toValue;
        }
        float var5 = (float)(var2 - (long)var4.fromTicks) / (float)(var4.toTicks - var4.fromTicks);
        float var6 = var4.easing.apply(var5);
        return this.lerp.apply(var6, var4.fromValue, var4.toValue);
    }

    private a<T> getSegmentAt(long var0) {
        for (a<T> var3 : this.segments) {
            if (var0 >= (long)var3.toTicks) continue;
            return var3;
        }
        return this.segments.getLast();
    }

    private long loopTicks(long var0) {
        if (this.periodTicks.isPresent()) {
            return Math.floorMod(var0, (int)this.periodTicks.get());
        }
        return var0;
    }

    static final class a<T>
    extends Record {
        final EasingType easing;
        final T fromValue;
        final int fromTicks;
        final T toValue;
        final int toTicks;

        public a(KeyframeTrack<T> var0, Keyframe<T> var1, int var2, Keyframe<T> var3, int var4) {
            this(var0.easingType(), var1.value(), var2, var3.value(), var4);
        }

        a(EasingType var0, T var1, int var2, T var3, int var4) {
            this.easing = var0;
            this.fromValue = var1;
            this.fromTicks = var2;
            this.toValue = var3;
            this.toTicks = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "easing", "fromValue", "fromTicks", "toValue", "toTicks"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "easing", "fromValue", "fromTicks", "toValue", "toTicks"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "easing", "fromValue", "fromTicks", "toValue", "toTicks"}, this, var0);
        }

        public EasingType easing() {
            return this.easing;
        }

        public T fromValue() {
            return this.fromValue;
        }

        public int fromTicks() {
            return this.fromTicks;
        }

        public T toValue() {
            return this.toValue;
        }

        public int toTicks() {
            return this.toTicks;
        }
    }
}

