/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ThreadingDetector {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final Semaphore lock = new Semaphore(1);
    private final Lock stackTraceLock = new ReentrantLock();
    private volatile @Nullable Thread threadThatFailedToAcquire;
    private volatile @Nullable ReportedException fullException;

    public ThreadingDetector(String var0) {
        this.name = var0;
    }

    public void checkAndLock() {
        block6: {
            boolean var0 = false;
            try {
                this.stackTraceLock.lock();
                if (this.lock.tryAcquire()) break block6;
                this.threadThatFailedToAcquire = Thread.currentThread();
                var0 = true;
                this.stackTraceLock.unlock();
                try {
                    this.lock.acquire();
                }
                catch (InterruptedException var1) {
                    Thread.currentThread().interrupt();
                }
                throw this.fullException;
            }
            finally {
                if (!var0) {
                    this.stackTraceLock.unlock();
                }
            }
        }
    }

    public void checkAndUnlock() {
        try {
            this.stackTraceLock.lock();
            Thread var0 = this.threadThatFailedToAcquire;
            if (var0 != null) {
                ReportedException var1;
                this.fullException = var1 = ThreadingDetector.makeThreadingException(this.name, var0);
                this.lock.release();
                throw var1;
            }
            this.lock.release();
        }
        finally {
            this.stackTraceLock.unlock();
        }
    }

    public static ReportedException makeThreadingException(String var0, @Nullable Thread var1) {
        String var2 = Stream.of(Thread.currentThread(), var1).filter(Objects::nonNull).map(ThreadingDetector::stackTrace).collect(Collectors.joining("\n"));
        String var3 = "Accessing " + var0 + " from multiple threads";
        CrashReport var4 = new CrashReport(var3, new IllegalStateException(var3));
        CrashReportSystemDetails var5 = var4.addCategory("Thread dumps");
        var5.setDetail("Thread dumps", var2);
        LOGGER.error("Thread dumps: \n{}", (Object)var2);
        return new ReportedException(var4);
    }

    private static String stackTrace(Thread var0) {
        return var0.getName() + ": \n\tat " + Arrays.stream(var0.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat "));
    }
}

