/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public final class DataFixTypes
extends Enum<DataFixTypes> {
    public static final /* enum */ DataFixTypes LEVEL = new DataFixTypes(DataConverterTypes.LEVEL);
    public static final /* enum */ DataFixTypes LEVEL_SUMMARY = new DataFixTypes(DataConverterTypes.LIGHTWEIGHT_LEVEL);
    public static final /* enum */ DataFixTypes PLAYER = new DataFixTypes(DataConverterTypes.PLAYER);
    public static final /* enum */ DataFixTypes CHUNK = new DataFixTypes(DataConverterTypes.CHUNK);
    public static final /* enum */ DataFixTypes HOTBAR = new DataFixTypes(DataConverterTypes.HOTBAR);
    public static final /* enum */ DataFixTypes OPTIONS = new DataFixTypes(DataConverterTypes.OPTIONS);
    public static final /* enum */ DataFixTypes STRUCTURE = new DataFixTypes(DataConverterTypes.STRUCTURE);
    public static final /* enum */ DataFixTypes STATS = new DataFixTypes(DataConverterTypes.STATS);
    public static final /* enum */ DataFixTypes SAVED_DATA_COMMAND_STORAGE = new DataFixTypes(DataConverterTypes.SAVED_DATA_COMMAND_STORAGE);
    public static final /* enum */ DataFixTypes SAVED_DATA_FORCED_CHUNKS = new DataFixTypes(DataConverterTypes.SAVED_DATA_TICKETS);
    public static final /* enum */ DataFixTypes SAVED_DATA_MAP_DATA = new DataFixTypes(DataConverterTypes.SAVED_DATA_MAP_DATA);
    public static final /* enum */ DataFixTypes SAVED_DATA_MAP_INDEX = new DataFixTypes(DataConverterTypes.SAVED_DATA_MAP_INDEX);
    public static final /* enum */ DataFixTypes SAVED_DATA_RAIDS = new DataFixTypes(DataConverterTypes.SAVED_DATA_RAIDS);
    public static final /* enum */ DataFixTypes SAVED_DATA_RANDOM_SEQUENCES = new DataFixTypes(DataConverterTypes.SAVED_DATA_RANDOM_SEQUENCES);
    public static final /* enum */ DataFixTypes SAVED_DATA_SCOREBOARD = new DataFixTypes(DataConverterTypes.SAVED_DATA_SCOREBOARD);
    public static final /* enum */ DataFixTypes SAVED_DATA_STOPWATCHES = new DataFixTypes(DataConverterTypes.SAVED_DATA_STOPWATCHES);
    public static final /* enum */ DataFixTypes SAVED_DATA_STRUCTURE_FEATURE_INDICES = new DataFixTypes(DataConverterTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    public static final /* enum */ DataFixTypes SAVED_DATA_WORLD_BORDER = new DataFixTypes(DataConverterTypes.SAVED_DATA_WORLD_BORDER);
    public static final /* enum */ DataFixTypes ADVANCEMENTS = new DataFixTypes(DataConverterTypes.ADVANCEMENTS);
    public static final /* enum */ DataFixTypes POI_CHUNK = new DataFixTypes(DataConverterTypes.POI_CHUNK);
    public static final /* enum */ DataFixTypes WORLD_GEN_SETTINGS = new DataFixTypes(DataConverterTypes.WORLD_GEN_SETTINGS);
    public static final /* enum */ DataFixTypes ENTITY_CHUNK = new DataFixTypes(DataConverterTypes.ENTITY_CHUNK);
    public static final /* enum */ DataFixTypes DEBUG_PROFILE = new DataFixTypes(DataConverterTypes.DEBUG_PROFILE);
    public static final Set<DSL.TypeReference> TYPES_FOR_LEVEL_LIST;
    private final DSL.TypeReference type;
    private static final /* synthetic */ DataFixTypes[] z;

    public static DataFixTypes[] values() {
        return (DataFixTypes[])z.clone();
    }

    public static DataFixTypes valueOf(String var0) {
        return Enum.valueOf(DataFixTypes.class, var0);
    }

    private DataFixTypes(DSL.TypeReference var2) {
        this.type = var2;
    }

    static int currentVersion() {
        return SharedConstants.getCurrentVersion().dataVersion().version();
    }

    public <A> Codec<A> wrapCodec(final Codec<A> var0, final DataFixer var1, final int var2) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A var02, DynamicOps<T> var12, T var22) {
                return var0.encode(var02, var12, var22).flatMap(var1 -> var12.mergeToMap(var1, var12.createString("DataVersion"), var12.createInt(DataFixTypes.currentVersion())));
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var02, T var12) {
                int var22 = var02.get(var12, "DataVersion").flatMap(arg_0 -> var02.getNumberValue(arg_0)).map(Number::intValue).result().orElse(var2);
                Dynamic var3 = new Dynamic(var02, var02.remove(var12, "DataVersion"));
                Dynamic var4 = DataFixTypes.this.updateToCurrentVersion(var1, var3, var22);
                return var0.decode(var4);
            }
        };
    }

    public <T> Dynamic<T> update(DataFixer var0, Dynamic<T> var1, int var2, int var3) {
        return var0.update(this.type, var1, var2, var3);
    }

    public <T> Dynamic<T> updateToCurrentVersion(DataFixer var0, Dynamic<T> var1, int var2) {
        return this.update(var0, var1, var2, DataFixTypes.currentVersion());
    }

    public NBTTagCompound update(DataFixer var0, NBTTagCompound var1, int var2, int var3) {
        return (NBTTagCompound)this.update(var0, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var1), var2, var3).getValue();
    }

    public NBTTagCompound updateToCurrentVersion(DataFixer var0, NBTTagCompound var1, int var2) {
        return this.update(var0, var1, var2, DataFixTypes.currentVersion());
    }

    private static /* synthetic */ DataFixTypes[] b() {
        return new DataFixTypes[]{LEVEL, LEVEL_SUMMARY, PLAYER, CHUNK, HOTBAR, OPTIONS, STRUCTURE, STATS, SAVED_DATA_COMMAND_STORAGE, SAVED_DATA_FORCED_CHUNKS, SAVED_DATA_MAP_DATA, SAVED_DATA_MAP_INDEX, SAVED_DATA_RAIDS, SAVED_DATA_RANDOM_SEQUENCES, SAVED_DATA_SCOREBOARD, SAVED_DATA_STOPWATCHES, SAVED_DATA_STRUCTURE_FEATURE_INDICES, SAVED_DATA_WORLD_BORDER, ADVANCEMENTS, POI_CHUNK, WORLD_GEN_SETTINGS, ENTITY_CHUNK, DEBUG_PROFILE};
    }

    static {
        z = DataFixTypes.b();
        TYPES_FOR_LEVEL_LIST = Set.of(DataFixTypes.LEVEL_SUMMARY.type);
    }
}

