/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.function.UnaryOperator;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterAttributes
extends DataFix {
    private final String name;
    private final UnaryOperator<String> renames;

    public DataConverterAttributes(Schema var0, String var1, UnaryOperator<String> var2) {
        super(var0, false);
        this.name = var1;
        this.renames = var2;
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ITEM_STACK);
        OpticFinder var12 = var0.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped(this.name + " (ItemStack)", var0, var1 -> var1.updateTyped(var12, this::fixItemStackTag)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped(this.name + " (Entity)", this.getInputSchema().getType(DataConverterTypes.ENTITY), this::fixEntity), this.fixTypeEverywhereTyped(this.name + " (Player)", this.getInputSchema().getType(DataConverterTypes.PLAYER), this::fixEntity)});
    }

    private Dynamic<?> fixName(Dynamic<?> var0) {
        return (Dynamic)DataFixUtils.orElse(var0.asString().result().map(this.renames).map(arg_0 -> var0.createString(arg_0)), var0);
    }

    private Typed<?> fixItemStackTag(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), var02 -> var02.update("AttributeModifiers", var0 -> (Dynamic)DataFixUtils.orElse(var0.asStreamOpt().result().map(var02 -> var02.map(var0 -> var0.update("AttributeName", this::fixName))).map(arg_0 -> ((Dynamic)var0).createList(arg_0)), (Object)var0)));
    }

    private Typed<?> fixEntity(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), var02 -> var02.update("Attributes", var0 -> (Dynamic)DataFixUtils.orElse(var0.asStreamOpt().result().map(var02 -> var02.map(var0 -> var0.update("Name", this::fixName))).map(arg_0 -> ((Dynamic)var0).createList(arg_0)), (Object)var0)));
    }
}

