/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class EquipmentFormatFix
extends DataFix {
    public EquipmentFormatFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getTypeRaw(DataConverterTypes.ITEM_STACK);
        Type var1 = this.getOutputSchema().getTypeRaw(DataConverterTypes.ITEM_STACK);
        OpticFinder var2 = var0.findField("id");
        return this.fix(var0, var1, var2);
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule fix(Type<ItemStackOld> var0, Type<ItemStackNew> var1, OpticFinder<?> var2) {
        Type var3 = DSL.named((String)DataConverterTypes.ENTITY_EQUIPMENT.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(var0))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(var0))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", var0)), (Type)DSL.optional((Type)DSL.field((String)"saddle", var0))));
        Type var4 = DSL.named((String)DataConverterTypes.ENTITY_EQUIPMENT.typeName(), (Type)DSL.optional((Type)DSL.field((String)"equipment", (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"mainhand", var1)), (Type)DSL.optional((Type)DSL.field((String)"offhand", var1)), (Type)DSL.optional((Type)DSL.field((String)"feet", var1)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"legs", var1)), (Type)DSL.optional((Type)DSL.field((String)"chest", var1)), (Type)DSL.optional((Type)DSL.field((String)"head", var1)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"body", var1)), (Type)DSL.optional((Type)DSL.field((String)"saddle", var1)), (Type)DSL.remainderType()))))));
        if (!var3.equals((Object)this.getInputSchema().getType(DataConverterTypes.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!var4.equals((Object)this.getOutputSchema().getType(DataConverterTypes.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return this.fixTypeEverywhere("EquipmentFormatFix", var3, var4, var22 -> {
            Predicate<Object> var32 = var3 -> {
                Typed var4 = new Typed(var0, var22, var3);
                return var4.getOptional(var2).isEmpty();
            };
            return var2 -> {
                String var3 = (String)var2.getFirst();
                Pair var4 = (Pair)var2.getSecond();
                List var5 = (List)((Either)var4.getFirst()).map(Function.identity(), var0 -> List.of());
                List var6 = (List)((Either)((Pair)var4.getSecond()).getFirst()).map(Function.identity(), var0 -> List.of());
                Either var7 = (Either)((Pair)((Pair)var4.getSecond()).getSecond()).getFirst();
                Either var8 = (Either)((Pair)((Pair)var4.getSecond()).getSecond()).getSecond();
                Either var9 = EquipmentFormatFix.getItemFromList(0, var5, var32);
                Either var10 = EquipmentFormatFix.getItemFromList(1, var5, var32);
                Either var11 = EquipmentFormatFix.getItemFromList(2, var5, var32);
                Either var12 = EquipmentFormatFix.getItemFromList(3, var5, var32);
                Either var13 = EquipmentFormatFix.getItemFromList(0, var6, var32);
                Either var14 = EquipmentFormatFix.getItemFromList(1, var6, var32);
                if (EquipmentFormatFix.areAllEmpty(var7, var8, var9, var10, var11, var12, var13, var14)) {
                    return Pair.of((Object)var3, (Object)Either.right((Object)Unit.INSTANCE));
                }
                return Pair.of((Object)var3, (Object)Either.left((Object)Pair.of(var13, (Object)Pair.of(var14, (Object)Pair.of(var9, (Object)Pair.of(var10, (Object)Pair.of(var11, (Object)Pair.of(var12, (Object)Pair.of((Object)var7, (Object)Pair.of((Object)var8, (Object)new Dynamic(var22)))))))))));
            };
        });
    }

    @SafeVarargs
    private static boolean areAllEmpty(Either<?, Unit> ... var0) {
        for (Either<?, Unit> var4 : var0) {
            if (!var4.right().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <ItemStack> Either<ItemStack, Unit> getItemFromList(int var0, List<ItemStack> var1, Predicate<ItemStack> var2) {
        if (var0 >= var1.size()) {
            return Either.right((Object)Unit.INSTANCE);
        }
        ItemStack var3 = var1.get(var0);
        if (var2.test(var3)) {
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left(var3);
    }
}

