/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class TextComponentStringifiedFlagsFix
extends DataFix {
    public TextComponentStringifiedFlagsFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Type var02 = this.getInputSchema().getType(DataConverterTypes.TEXT_COMPONENT);
        return this.fixTypeEverywhere("TextComponentStringyFlagsFix", var02, var0 -> var02 -> var02.mapSecond(var0 -> var0.mapRight(var02 -> var02.mapSecond(var0 -> var0.mapSecond(var02 -> var02.mapSecond(var0 -> var0.update("bold", TextComponentStringifiedFlagsFix::stringToBool).update("italic", TextComponentStringifiedFlagsFix::stringToBool).update("underlined", TextComponentStringifiedFlagsFix::stringToBool).update("strikethrough", TextComponentStringifiedFlagsFix::stringToBool).update("obfuscated", TextComponentStringifiedFlagsFix::stringToBool)))))));
    }

    private static <T> Dynamic<T> stringToBool(Dynamic<T> var0) {
        Optional var1 = var0.asString().result();
        if (var1.isPresent()) {
            return var0.createBoolean(Boolean.parseBoolean((String)var1.get()));
        }
        return var0;
    }
}

