/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.jtracy.TracyClient;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.TracyZoneFiller;
import org.jspecify.annotations.Nullable;

public final class Profiler {
    private static final ThreadLocal<TracyZoneFiller> TRACY_FILLER = ThreadLocal.withInitial(TracyZoneFiller::new);
    private static final ThreadLocal<@Nullable GameProfilerFiller> ACTIVE = new ThreadLocal();
    private static final AtomicInteger ACTIVE_COUNT = new AtomicInteger();

    private Profiler() {
    }

    public static a use(GameProfilerFiller var0) {
        Profiler.startUsing(var0);
        return Profiler::stopUsing;
    }

    private static void startUsing(GameProfilerFiller var0) {
        if (ACTIVE.get() != null) {
            throw new IllegalStateException("Profiler is already active");
        }
        GameProfilerFiller var1 = Profiler.decorateFiller(var0);
        ACTIVE.set(var1);
        ACTIVE_COUNT.incrementAndGet();
        var1.startTick();
    }

    private static void stopUsing() {
        GameProfilerFiller var0 = ACTIVE.get();
        if (var0 == null) {
            throw new IllegalStateException("Profiler was not active");
        }
        ACTIVE.remove();
        ACTIVE_COUNT.decrementAndGet();
        var0.endTick();
    }

    private static GameProfilerFiller decorateFiller(GameProfilerFiller var0) {
        return GameProfilerFiller.combine(Profiler.getDefaultFiller(), var0);
    }

    public static GameProfilerFiller get() {
        if (ACTIVE_COUNT.get() == 0) {
            return Profiler.getDefaultFiller();
        }
        return Objects.requireNonNullElseGet(ACTIVE.get(), Profiler::getDefaultFiller);
    }

    private static GameProfilerFiller getDefaultFiller() {
        if (TracyClient.isAvailable()) {
            return TRACY_FILLER.get();
        }
        return GameProfilerDisabled.INSTANCE;
    }

    public static interface a
    extends AutoCloseable {
        @Override
        public void close();
    }
}

