/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import org.jspecify.annotations.Nullable;

public class MetricsRegistry {
    public static final MetricsRegistry INSTANCE = new MetricsRegistry();
    private final WeakHashMap<ProfilerMeasured, Void> measuredInstances = new WeakHashMap();

    private MetricsRegistry() {
    }

    public void add(ProfilerMeasured var0) {
        this.measuredInstances.put(var0, null);
    }

    public List<MetricSampler> getRegisteredSamplers() {
        Map<String, List<MetricSampler>> var02 = this.measuredInstances.keySet().stream().flatMap(var0 -> var0.profiledMetrics().stream()).collect(Collectors.groupingBy(MetricSampler::getName));
        return MetricsRegistry.aggregateDuplicates(var02);
    }

    private static List<MetricSampler> aggregateDuplicates(Map<String, List<MetricSampler>> var02) {
        return var02.entrySet().stream().map(var0 -> {
            String var1 = (String)var0.getKey();
            List var2 = (List)var0.getValue();
            return var2.size() > 1 ? new a(var1, var2) : (MetricSampler)var2.get(0);
        }).collect(Collectors.toList());
    }

    static class a
    extends MetricSampler {
        private final List<MetricSampler> delegates;

        a(String var0, List<MetricSampler> var1) {
            super(var0, var1.get(0).getCategory(), () -> a.averageValueFromDelegates(var1), () -> a.beforeTick(var1), a.thresholdTest(var1));
            this.delegates = var1;
        }

        private static MetricSampler.c thresholdTest(List<MetricSampler> var0) {
            return var1 -> var0.stream().anyMatch(var2 -> {
                if (var2.thresholdTest != null) {
                    return var2.thresholdTest.test(var1);
                }
                return false;
            });
        }

        private static void beforeTick(List<MetricSampler> var0) {
            for (MetricSampler var2 : var0) {
                var2.onStartTick();
            }
        }

        private static double averageValueFromDelegates(List<MetricSampler> var0) {
            double var1 = 0.0;
            for (MetricSampler var4 : var0) {
                var1 += var4.getSampler().getAsDouble();
            }
            return var1 / (double)var0.size();
        }

        @Override
        public boolean equals(@Nullable Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            if (!super.equals(var0)) {
                return false;
            }
            a var1 = (a)var0;
            return this.delegates.equals(var1.delegates);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.delegates);
        }
    }
}

