/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String NEW_DIRECTORY_PREFIX = "new_";
    static final IChatBaseComponent STATUS_UPGRADING_POI = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.poi");
    static final IChatBaseComponent STATUS_FINISHED_POI = IChatBaseComponent.translatable("optimizeWorld.stage.finished.poi");
    static final IChatBaseComponent STATUS_UPGRADING_ENTITIES = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.entities");
    static final IChatBaseComponent STATUS_FINISHED_ENTITIES = IChatBaseComponent.translatable("optimizeWorld.stage.finished.entities");
    static final IChatBaseComponent STATUS_UPGRADING_CHUNKS = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.chunks");
    static final IChatBaseComponent STATUS_FINISHED_CHUNKS = IChatBaseComponent.translatable("optimizeWorld.stage.finished.chunks");
    final IRegistry<WorldDimension> dimensions;
    final Set<ResourceKey<World>> levels;
    final boolean eraseCache;
    final boolean recreateRegionFiles;
    final Convertable.ConversionSession levelStorage;
    private final Thread thread;
    final DataFixer dataFixer;
    volatile boolean running = true;
    private volatile boolean finished;
    volatile float progress;
    volatile int totalChunks;
    volatile int totalFiles;
    volatile int converted;
    volatile int skipped;
    final Reference2FloatMap<ResourceKey<World>> progressMap = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile IChatBaseComponent status = IChatBaseComponent.translatable("optimizeWorld.stage.counting");
    static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final WorldPersistentData overworldDataStorage;

    public WorldUpgrader(Convertable.ConversionSession var02, DataFixer var12, SaveData var2, IRegistryCustom var3, boolean var4, boolean var5) {
        this.dimensions = var3.lookupOrThrow(Registries.LEVEL_STEM);
        this.levels = this.dimensions.registryKeySet().stream().map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = var4;
        this.dataFixer = var12;
        this.levelStorage = var02;
        this.overworldDataStorage = new WorldPersistentData(this.levelStorage.getDimensionPath(World.OVERWORLD).resolve("data"), var12, var3);
        this.recreateRegionFiles = var5;
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((var0, var1) -> {
            LOGGER.error("Error upgrading world", var1);
            this.status = IChatBaseComponent.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        long var0 = SystemUtils.getMillis();
        LOGGER.info("Upgrading entities");
        new d(this).upgrade();
        LOGGER.info("Upgrading POIs");
        new f(this).upgrade();
        LOGGER.info("Upgrading blocks");
        new b().upgrade();
        this.overworldDataStorage.saveAndJoin();
        var0 = SystemUtils.getMillis() - var0;
        LOGGER.info("World optimizaton finished after {} seconds", (Object)(var0 / 1000L));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<World>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<World> var0) {
        return this.progressMap.getFloat(var0);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public IChatBaseComponent getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.overworldDataStorage.close();
    }

    static Path resolveRecreateDirectory(Path var0) {
        return var0.resolveSibling(NEW_DIRECTORY_PREFIX + var0.getFileName().toString());
    }

    class d
    extends g {
        d(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.ENTITY_CHUNK, "entities", STATUS_UPGRADING_ENTITIES, STATUS_FINISHED_ENTITIES);
        }

        @Override
        protected NBTTagCompound upgradeTag(SimpleRegionStorage var0, NBTTagCompound var1) {
            return var0.upgradeChunkTag(var1, -1);
        }
    }

    class f
    extends g {
        f(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.POI_CHUNK, "poi", STATUS_UPGRADING_POI, STATUS_FINISHED_POI);
        }

        @Override
        protected NBTTagCompound upgradeTag(SimpleRegionStorage var0, NBTTagCompound var1) {
            return var0.upgradeChunkTag(var1, 1945);
        }
    }

    class b
    extends a {
        b() {
            super(DataFixTypes.CHUNK, "chunk", "region", STATUS_UPGRADING_CHUNKS, STATUS_FINISHED_CHUNKS);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage var0, ChunkCoordIntPair var1, ResourceKey<World> var2) {
            NBTTagCompound var3 = var0.read(var1).join().orElse(null);
            if (var3 != null) {
                boolean var8;
                int var4 = GameProfileSerializer.getDataVersion(var3);
                ChunkGenerator var5 = WorldUpgrader.this.dimensions.getValueOrThrow(Registries.levelToLevelStem(var2)).generator();
                NBTTagCompound var6 = var0.upgradeChunkTag(var3, -1, PlayerChunkMap.getChunkDataFixContextTag(var2, var5.getTypeNameForDataFixer()));
                ChunkCoordIntPair var7 = new ChunkCoordIntPair(var6.getIntOr("xPos", 0), var6.getIntOr("zPos", 0));
                if (!var7.equals(var1)) {
                    LOGGER.warn("Chunk {} has invalid position {}", (Object)var1, (Object)var7);
                }
                boolean bl = var8 = var4 < SharedConstants.getCurrentVersion().dataVersion().version();
                if (WorldUpgrader.this.eraseCache) {
                    var8 = var8 || var6.contains("Heightmaps");
                    var6.remove("Heightmaps");
                    var8 = var8 || var6.contains("isLightOn");
                    var6.remove("isLightOn");
                    NBTTagList var9 = var6.getListOrEmpty("sections");
                    for (int var10 = 0; var10 < var9.size(); ++var10) {
                        Optional<NBTTagCompound> var11 = var9.getCompound(var10);
                        if (var11.isEmpty()) continue;
                        NBTTagCompound var12 = var11.get();
                        var8 = var8 || var12.contains("BlockLight");
                        var12.remove("BlockLight");
                        var8 = var8 || var12.contains("SkyLight");
                        var12.remove("SkyLight");
                    }
                }
                if (var8 || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = var0.write(var1, var6);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo var0, Path var1) {
            Supplier<LegacyTagFixer> var2 = PersistentStructureLegacy.getLegacyTagFixer(var0.dimension(), () -> WorldUpgrader.this.overworldDataStorage, WorldUpgrader.this.dataFixer);
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(var0.withTypeSuffix("source"), var1, var0.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(var1), WorldUpgrader.this.dataFixer, true, DataFixTypes.CHUNK, var2) : new SimpleRegionStorage(var0, var1, WorldUpgrader.this.dataFixer, true, DataFixTypes.CHUNK, var2);
        }
    }

    abstract class g
    extends a {
        g(DataFixTypes var1, String var2, IChatBaseComponent var3, IChatBaseComponent var4) {
            super(var1, var2, var2, var3, var4);
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo var0, Path var1) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(var0.withTypeSuffix("source"), var1, var0.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(var1), WorldUpgrader.this.dataFixer, true, this.dataFixType, LegacyTagFixer.EMPTY) : new SimpleRegionStorage(var0, var1, WorldUpgrader.this.dataFixer, true, this.dataFixType);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage var0, ChunkCoordIntPair var1, ResourceKey<World> var2) {
            NBTTagCompound var3 = var0.read(var1).join().orElse(null);
            if (var3 != null) {
                boolean var6;
                int var4 = GameProfileSerializer.getDataVersion(var3);
                NBTTagCompound var5 = this.upgradeTag(var0, var3);
                boolean bl = var6 = var4 < SharedConstants.getCurrentVersion().dataVersion().version();
                if (var6 || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = var0.write(var1, var5);
                    return true;
                }
            }
            return false;
        }

        protected abstract NBTTagCompound upgradeTag(SimpleRegionStorage var1, NBTTagCompound var2);
    }

    abstract class a {
        private final IChatBaseComponent upgradingStatus;
        private final IChatBaseComponent finishedStatus;
        private final String type;
        private final String folderName;
        protected @Nullable CompletableFuture<Void> previousWriteFuture;
        protected final DataFixTypes dataFixType;

        a(DataFixTypes var1, String var2, String var3, IChatBaseComponent var4, IChatBaseComponent var5) {
            this.dataFixType = var1;
            this.type = var2;
            this.folderName = var3;
            this.upgradingStatus = var4;
            this.finishedStatus = var5;
        }

        public void upgrade() {
            WorldUpgrader.this.totalFiles = 0;
            WorldUpgrader.this.totalChunks = 0;
            WorldUpgrader.this.converted = 0;
            WorldUpgrader.this.skipped = 0;
            List<c> var0 = this.getDimensionsToUpgrade();
            if (WorldUpgrader.this.totalChunks == 0) {
                return;
            }
            float var1 = WorldUpgrader.this.totalFiles;
            WorldUpgrader.this.status = this.upgradingStatus;
            while (WorldUpgrader.this.running) {
                boolean var2 = false;
                float var3 = 0.0f;
                for (c var5 : var0) {
                    ResourceKey<World> var6 = var5.dimensionKey;
                    ListIterator<e> var7 = var5.files;
                    SimpleRegionStorage var8 = var5.storage;
                    if (var7.hasNext()) {
                        e var9 = var7.next();
                        boolean var10 = true;
                        for (ChunkCoordIntPair var12 : var9.chunksToUpgrade) {
                            var10 = var10 && this.processOnePosition(var6, var8, var12);
                            var2 = true;
                        }
                        if (WorldUpgrader.this.recreateRegionFiles) {
                            if (var10) {
                                this.onFileFinished(var9.file);
                            } else {
                                LOGGER.error("Failed to convert region file {}", (Object)var9.file.getPath());
                            }
                        }
                    }
                    float var9 = (float)var7.nextIndex() / var1;
                    WorldUpgrader.this.progressMap.put(var6, var9);
                    var3 += var9;
                }
                WorldUpgrader.this.progress = var3;
                if (var2) continue;
                break;
            }
            WorldUpgrader.this.status = this.finishedStatus;
            for (c var3 : var0) {
                try {
                    var3.storage.close();
                }
                catch (Exception var4) {
                    LOGGER.error("Error upgrading chunk", (Throwable)var4);
                }
            }
        }

        private List<c> getDimensionsToUpgrade() {
            ArrayList var0 = Lists.newArrayList();
            for (ResourceKey<World> var2 : WorldUpgrader.this.levels) {
                RegionStorageInfo var3 = new RegionStorageInfo(WorldUpgrader.this.levelStorage.getLevelId(), var2, this.type);
                Path var4 = WorldUpgrader.this.levelStorage.getDimensionPath(var2).resolve(this.folderName);
                SimpleRegionStorage var5 = this.createStorage(var3, var4);
                ListIterator<e> var6 = this.getFilesToProcess(var3, var4);
                var0.add(new c(var2, var5, var6));
            }
            return var0;
        }

        protected abstract SimpleRegionStorage createStorage(RegionStorageInfo var1, Path var2);

        private ListIterator<e> getFilesToProcess(RegionStorageInfo var02, Path var1) {
            List<e> var2 = a.getAllChunkPositions(var02, var1);
            WorldUpgrader.this.totalFiles += var2.size();
            WorldUpgrader.this.totalChunks += var2.stream().mapToInt(var0 -> var0.chunksToUpgrade.size()).sum();
            return var2.listIterator();
        }

        private static List<e> getAllChunkPositions(RegionStorageInfo var02, Path var12) {
            File[] var2 = var12.toFile().listFiles((var0, var1) -> var1.endsWith(".mca"));
            if (var2 == null) {
                return List.of();
            }
            ArrayList var3 = Lists.newArrayList();
            for (File var7 : var2) {
                Matcher var8 = REGEX.matcher(var7.getName());
                if (!var8.matches()) continue;
                int var9 = Integer.parseInt(var8.group(1)) << 5;
                int var10 = Integer.parseInt(var8.group(2)) << 5;
                ArrayList var11 = Lists.newArrayList();
                try (RegionFile var122 = new RegionFile(var02, var7.toPath(), var12, true);){
                    for (int var13 = 0; var13 < 32; ++var13) {
                        for (int var14 = 0; var14 < 32; ++var14) {
                            ChunkCoordIntPair var15 = new ChunkCoordIntPair(var13 + var9, var14 + var10);
                            if (!var122.doesChunkExist(var15)) continue;
                            var11.add(var15);
                        }
                    }
                    if (var11.isEmpty()) continue;
                    var3.add(new e(var122, var11));
                }
                catch (Throwable var123) {
                    LOGGER.error("Failed to read chunks from region file {}", (Object)var7.toPath(), (Object)var123);
                }
            }
            return var3;
        }

        private boolean processOnePosition(ResourceKey<World> var0, SimpleRegionStorage var1, ChunkCoordIntPair var2) {
            boolean var3 = false;
            try {
                var3 = this.tryProcessOnePosition(var1, var2, var0);
            }
            catch (CompletionException | ReportedException var4) {
                Throwable var5 = var4.getCause();
                if (var5 instanceof IOException) {
                    LOGGER.error("Error upgrading chunk {}", (Object)var2, (Object)var5);
                }
                throw var4;
            }
            if (var3) {
                ++WorldUpgrader.this.converted;
            } else {
                ++WorldUpgrader.this.skipped;
            }
            return var3;
        }

        protected abstract boolean tryProcessOnePosition(SimpleRegionStorage var1, ChunkCoordIntPair var2, ResourceKey<World> var3);

        private void onFileFinished(RegionFile var0) {
            if (!WorldUpgrader.this.recreateRegionFiles) {
                return;
            }
            if (this.previousWriteFuture != null) {
                this.previousWriteFuture.join();
            }
            Path var1 = var0.getPath();
            Path var2 = var1.getParent();
            Path var3 = WorldUpgrader.resolveRecreateDirectory(var2).resolve(var1.getFileName().toString());
            try {
                if (var3.toFile().exists()) {
                    Files.delete(var1);
                    Files.move(var3, var1, new CopyOption[0]);
                } else {
                    LOGGER.error("Failed to replace an old region file. New file {} does not exist.", (Object)var3);
                }
            }
            catch (IOException var4) {
                LOGGER.error("Failed to replace an old region file", (Throwable)var4);
            }
        }
    }

    static final class e
    extends Record {
        final RegionFile file;
        final List<ChunkCoordIntPair> chunksToUpgrade;

        e(RegionFile var0, List<ChunkCoordIntPair> var1) {
            this.file = var0;
            this.chunksToUpgrade = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "file;chunksToUpgrade", "file", "chunksToUpgrade"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "file;chunksToUpgrade", "file", "chunksToUpgrade"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "file;chunksToUpgrade", "file", "chunksToUpgrade"}, this, var0);
        }

        public RegionFile file() {
            return this.file;
        }

        public List<ChunkCoordIntPair> chunksToUpgrade() {
            return this.chunksToUpgrade;
        }
    }

    static final class c
    extends Record {
        final ResourceKey<World> dimensionKey;
        final SimpleRegionStorage storage;
        final ListIterator<e> files;

        c(ResourceKey<World> var0, SimpleRegionStorage var1, ListIterator<e> var2) {
            this.dimensionKey = var0;
            this.storage = var1;
            this.files = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimensionKey;storage;files", "dimensionKey", "storage", "files"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimensionKey;storage;files", "dimensionKey", "storage", "files"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimensionKey;storage;files", "dimensionKey", "storage", "files"}, this, var0);
        }

        public ResourceKey<World> dimensionKey() {
            return this.dimensionKey;
        }

        public SimpleRegionStorage storage() {
            return this.storage;
        }

        public ListIterator<e> files() {
            return this.files;
        }
    }
}

