/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;

public record BedRule(a canSleep, a canSetSpawn, boolean explodes, Optional<IChatBaseComponent> errorMessage) {
    public static final BedRule CAN_SLEEP_WHEN_DARK = new BedRule(a.WHEN_DARK, a.ALWAYS, false, Optional.of(IChatBaseComponent.translatable("block.minecraft.bed.no_sleep")));
    public static final BedRule EXPLODES = new BedRule(a.NEVER, a.NEVER, true, Optional.empty());
    public static final Codec<BedRule> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)a.CODEC.fieldOf("can_sleep").forGetter(BedRule::canSleep), (App)a.CODEC.fieldOf("can_set_spawn").forGetter(BedRule::canSetSpawn), (App)Codec.BOOL.optionalFieldOf("explodes", (Object)false).forGetter(BedRule::explodes), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(BedRule::errorMessage)).apply((Applicative)var0, BedRule::new));

    public boolean canSleep(World var0) {
        return this.canSleep.test(var0);
    }

    public boolean canSetSpawn(World var0) {
        return this.canSetSpawn.test(var0);
    }

    public EntityHuman.EnumBedResult asProblem() {
        return new EntityHuman.EnumBedResult(this.errorMessage.orElse(null));
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a ALWAYS = new a("always");
        public static final /* enum */ a WHEN_DARK = new a("when_dark");
        public static final /* enum */ a NEVER = new a("never");
        public static final Codec<a> CODEC;
        private final String name;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        public boolean test(World var0) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> var0.isDarkOutside();
                case 2 -> false;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{ALWAYS, WHEN_DARK, NEVER};
        }

        static {
            f = a.a();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

