/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.AttributeRange;
import net.minecraft.world.attribute.AttributeType;
import org.jspecify.annotations.Nullable;

public class EnvironmentAttribute<Value> {
    private final AttributeType<Value> type;
    private final Value defaultValue;
    private final AttributeRange<Value> valueRange;
    private final boolean isSyncable;
    private final boolean isPositional;
    private final boolean isSpatiallyInterpolated;

    EnvironmentAttribute(AttributeType<Value> var0, Value var1, AttributeRange<Value> var2, boolean var3, boolean var4, boolean var5) {
        this.type = var0;
        this.defaultValue = var1;
        this.valueRange = var2;
        this.isSyncable = var3;
        this.isPositional = var4;
        this.isSpatiallyInterpolated = var5;
    }

    public static <Value> a<Value> builder(AttributeType<Value> var0) {
        return new a<Value>(var0);
    }

    public AttributeType<Value> type() {
        return this.type;
    }

    public Value defaultValue() {
        return this.defaultValue;
    }

    public Codec<Value> valueCodec() {
        return this.type.valueCodec().validate(this.valueRange::validate);
    }

    public Value sanitizeValue(Value var0) {
        return this.valueRange.sanitize(var0);
    }

    public boolean isSyncable() {
        return this.isSyncable;
    }

    public boolean isPositional() {
        return this.isPositional;
    }

    public boolean isSpatiallyInterpolated() {
        return this.isSpatiallyInterpolated;
    }

    public String toString() {
        return SystemUtils.getRegisteredName(BuiltInRegistries.ENVIRONMENT_ATTRIBUTE, this);
    }

    public static class a<Value> {
        private final AttributeType<Value> type;
        private @Nullable Value defaultValue;
        private AttributeRange<Value> valueRange = AttributeRange.any();
        private boolean isSyncable = false;
        private boolean isPositional = true;
        private boolean isSpatiallyInterpolated = false;

        public a(AttributeType<Value> var0) {
            this.type = var0;
        }

        public a<Value> defaultValue(Value var0) {
            this.defaultValue = var0;
            return this;
        }

        public a<Value> valueRange(AttributeRange<Value> var0) {
            this.valueRange = var0;
            return this;
        }

        public a<Value> syncable() {
            this.isSyncable = true;
            return this;
        }

        public a<Value> notPositional() {
            this.isPositional = false;
            return this;
        }

        public a<Value> spatiallyInterpolated() {
            this.isSpatiallyInterpolated = true;
            return this;
        }

        public EnvironmentAttribute<Value> build() {
            return new EnvironmentAttribute<Value>(this.type, Objects.requireNonNull(this.defaultValue, "Missing default value"), this.valueRange, this.isSyncable, this.isPositional, this.isSpatiallyInterpolated);
        }
    }
}

