/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityWitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class DamageSources {
    private final IRegistry<DamageType> damageTypes;
    private final DamageSource inFire;
    private final DamageSource campfire;
    private final DamageSource lightningBolt;
    private final DamageSource onFire;
    private final DamageSource lava;
    private final DamageSource hotFloor;
    private final DamageSource inWall;
    private final DamageSource cramming;
    private final DamageSource drown;
    private final DamageSource starve;
    private final DamageSource cactus;
    private final DamageSource fall;
    private final DamageSource enderPearl;
    private final DamageSource flyIntoWall;
    private final DamageSource fellOutOfWorld;
    private final DamageSource generic;
    private final DamageSource magic;
    private final DamageSource wither;
    private final DamageSource dragonBreath;
    private final DamageSource dryOut;
    private final DamageSource sweetBerryBush;
    private final DamageSource freeze;
    private final DamageSource stalagmite;
    private final DamageSource outsideBorder;
    private final DamageSource genericKill;

    public DamageSources(IRegistryCustom var0) {
        this.damageTypes = var0.lookupOrThrow(Registries.DAMAGE_TYPE);
        this.inFire = this.source(DamageTypes.IN_FIRE);
        this.campfire = this.source(DamageTypes.CAMPFIRE);
        this.lightningBolt = this.source(DamageTypes.LIGHTNING_BOLT);
        this.onFire = this.source(DamageTypes.ON_FIRE);
        this.lava = this.source(DamageTypes.LAVA);
        this.hotFloor = this.source(DamageTypes.HOT_FLOOR);
        this.inWall = this.source(DamageTypes.IN_WALL);
        this.cramming = this.source(DamageTypes.CRAMMING);
        this.drown = this.source(DamageTypes.DROWN);
        this.starve = this.source(DamageTypes.STARVE);
        this.cactus = this.source(DamageTypes.CACTUS);
        this.fall = this.source(DamageTypes.FALL);
        this.enderPearl = this.source(DamageTypes.ENDER_PEARL);
        this.flyIntoWall = this.source(DamageTypes.FLY_INTO_WALL);
        this.fellOutOfWorld = this.source(DamageTypes.FELL_OUT_OF_WORLD);
        this.generic = this.source(DamageTypes.GENERIC);
        this.magic = this.source(DamageTypes.MAGIC);
        this.wither = this.source(DamageTypes.WITHER);
        this.dragonBreath = this.source(DamageTypes.DRAGON_BREATH);
        this.dryOut = this.source(DamageTypes.DRY_OUT);
        this.sweetBerryBush = this.source(DamageTypes.SWEET_BERRY_BUSH);
        this.freeze = this.source(DamageTypes.FREEZE);
        this.stalagmite = this.source(DamageTypes.STALAGMITE);
        this.outsideBorder = this.source(DamageTypes.OUTSIDE_BORDER);
        this.genericKill = this.source(DamageTypes.GENERIC_KILL);
    }

    private DamageSource source(ResourceKey<DamageType> var0) {
        return new DamageSource(this.damageTypes.getOrThrow(var0));
    }

    private DamageSource source(ResourceKey<DamageType> var0, @Nullable Entity var1) {
        return new DamageSource((Holder<DamageType>)this.damageTypes.getOrThrow(var0), var1);
    }

    private DamageSource source(ResourceKey<DamageType> var0, @Nullable Entity var1, @Nullable Entity var2) {
        return new DamageSource(this.damageTypes.getOrThrow(var0), var1, var2);
    }

    public DamageSource inFire() {
        return this.inFire;
    }

    public DamageSource campfire() {
        return this.campfire;
    }

    public DamageSource lightningBolt() {
        return this.lightningBolt;
    }

    public DamageSource onFire() {
        return this.onFire;
    }

    public DamageSource lava() {
        return this.lava;
    }

    public DamageSource hotFloor() {
        return this.hotFloor;
    }

    public DamageSource inWall() {
        return this.inWall;
    }

    public DamageSource cramming() {
        return this.cramming;
    }

    public DamageSource drown() {
        return this.drown;
    }

    public DamageSource starve() {
        return this.starve;
    }

    public DamageSource cactus() {
        return this.cactus;
    }

    public DamageSource fall() {
        return this.fall;
    }

    public DamageSource enderPearl() {
        return this.enderPearl;
    }

    public DamageSource flyIntoWall() {
        return this.flyIntoWall;
    }

    public DamageSource fellOutOfWorld() {
        return this.fellOutOfWorld;
    }

    public DamageSource generic() {
        return this.generic;
    }

    public DamageSource magic() {
        return this.magic;
    }

    public DamageSource wither() {
        return this.wither;
    }

    public DamageSource dragonBreath() {
        return this.dragonBreath;
    }

    public DamageSource dryOut() {
        return this.dryOut;
    }

    public DamageSource sweetBerryBush() {
        return this.sweetBerryBush;
    }

    public DamageSource freeze() {
        return this.freeze;
    }

    public DamageSource stalagmite() {
        return this.stalagmite;
    }

    public DamageSource fallingBlock(Entity var0) {
        return this.source(DamageTypes.FALLING_BLOCK, var0);
    }

    public DamageSource anvil(Entity var0) {
        return this.source(DamageTypes.FALLING_ANVIL, var0);
    }

    public DamageSource fallingStalactite(Entity var0) {
        return this.source(DamageTypes.FALLING_STALACTITE, var0);
    }

    public DamageSource sting(EntityLiving var0) {
        return this.source(DamageTypes.STING, var0);
    }

    public DamageSource mobAttack(EntityLiving var0) {
        return this.source(DamageTypes.MOB_ATTACK, var0);
    }

    public DamageSource noAggroMobAttack(EntityLiving var0) {
        return this.source(DamageTypes.MOB_ATTACK_NO_AGGRO, var0);
    }

    public DamageSource playerAttack(EntityHuman var0) {
        return this.source(DamageTypes.PLAYER_ATTACK, var0);
    }

    public DamageSource arrow(EntityArrow var0, @Nullable Entity var1) {
        return this.source(DamageTypes.ARROW, var0, var1);
    }

    public DamageSource trident(Entity var0, @Nullable Entity var1) {
        return this.source(DamageTypes.TRIDENT, var0, var1);
    }

    public DamageSource mobProjectile(Entity var0, @Nullable EntityLiving var1) {
        return this.source(DamageTypes.MOB_PROJECTILE, var0, var1);
    }

    public DamageSource spit(Entity var0, @Nullable EntityLiving var1) {
        return this.source(DamageTypes.SPIT, var0, var1);
    }

    public DamageSource windCharge(Entity var0, @Nullable EntityLiving var1) {
        return this.source(DamageTypes.WIND_CHARGE, var0, var1);
    }

    public DamageSource fireworks(EntityFireworks var0, @Nullable Entity var1) {
        return this.source(DamageTypes.FIREWORKS, var0, var1);
    }

    public DamageSource fireball(EntityFireballFireball var0, @Nullable Entity var1) {
        if (var1 == null) {
            return this.source(DamageTypes.UNATTRIBUTED_FIREBALL, var0);
        }
        return this.source(DamageTypes.FIREBALL, var0, var1);
    }

    public DamageSource witherSkull(EntityWitherSkull var0, Entity var1) {
        return this.source(DamageTypes.WITHER_SKULL, var0, var1);
    }

    public DamageSource thrown(Entity var0, @Nullable Entity var1) {
        return this.source(DamageTypes.THROWN, var0, var1);
    }

    public DamageSource indirectMagic(Entity var0, @Nullable Entity var1) {
        return this.source(DamageTypes.INDIRECT_MAGIC, var0, var1);
    }

    public DamageSource thorns(Entity var0) {
        return this.source(DamageTypes.THORNS, var0);
    }

    public DamageSource explosion(@Nullable Explosion var0) {
        return var0 != null ? this.explosion(var0.getDirectSourceEntity(), var0.getIndirectSourceEntity()) : this.explosion(null, null);
    }

    public DamageSource explosion(@Nullable Entity var0, @Nullable Entity var1) {
        return this.source(var1 != null && var0 != null ? DamageTypes.PLAYER_EXPLOSION : DamageTypes.EXPLOSION, var0, var1);
    }

    public DamageSource sonicBoom(Entity var0) {
        return this.source(DamageTypes.SONIC_BOOM, var0);
    }

    public DamageSource badRespawnPointExplosion(Vec3D var0) {
        return new DamageSource((Holder<DamageType>)this.damageTypes.getOrThrow(DamageTypes.BAD_RESPAWN_POINT), var0);
    }

    public DamageSource outOfBorder() {
        return this.outsideBorder;
    }

    public DamageSource genericKill() {
        return this.genericKill;
    }

    public DamageSource mace(Entity var0) {
        return this.source(DamageTypes.MACE_SMASH, var0);
    }
}

