/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EnumItemSlot;

public record DropChances(Map<EnumItemSlot, Float> byEquipment) {
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final float PRESERVE_ITEM_DROP_CHANCE_THRESHOLD = 1.0f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final DropChances DEFAULT = new DropChances(SystemUtils.makeEnumMap(EnumItemSlot.class, var0 -> Float.valueOf(0.085f)));
    public static final Codec<DropChances> CODEC = Codec.unboundedMap(EnumItemSlot.CODEC, ExtraCodecs.NON_NEGATIVE_FLOAT).xmap(DropChances::toEnumMap, DropChances::filterDefaultValues).xmap(DropChances::new, DropChances::byEquipment);

    private static Map<EnumItemSlot, Float> filterDefaultValues(Map<EnumItemSlot, Float> var02) {
        HashMap<EnumItemSlot, Float> var1 = new HashMap<EnumItemSlot, Float>(var02);
        var1.values().removeIf(var0 -> var0.floatValue() == 0.085f);
        return var1;
    }

    private static Map<EnumItemSlot, Float> toEnumMap(Map<EnumItemSlot, Float> var0) {
        return SystemUtils.makeEnumMap(EnumItemSlot.class, var1 -> var0.getOrDefault(var1, Float.valueOf(0.085f)));
    }

    public DropChances withGuaranteedDrop(EnumItemSlot var0) {
        return this.withEquipmentChance(var0, 2.0f);
    }

    public DropChances withEquipmentChance(EnumItemSlot var0, float var1) {
        if (var1 < 0.0f) {
            throw new IllegalArgumentException("Tried to set invalid equipment chance " + var1 + " for " + String.valueOf(var0));
        }
        if (this.byEquipment(var0) == var1) {
            return this;
        }
        return new DropChances(SystemUtils.makeEnumMap(EnumItemSlot.class, var2 -> Float.valueOf(var2 == var0 ? var1 : this.byEquipment((EnumItemSlot)var2))));
    }

    public float byEquipment(EnumItemSlot var0) {
        return this.byEquipment.getOrDefault(var0, Float.valueOf(0.085f)).floatValue();
    }

    public boolean isPreserved(EnumItemSlot var0) {
        return this.byEquipment(var0) > 1.0f;
    }
}

