/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public final class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> CODEC = UUIDUtil.CODEC.xmap(EntityReference::new, EntityReference::getUUID);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(EntityReference::new, EntityReference::getUUID);
    private Either<UUID, StoredEntityType> entity;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> codec() {
        return CODEC;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> streamCodec() {
        return STREAM_CODEC;
    }

    private EntityReference(StoredEntityType var0) {
        this.entity = Either.right(var0);
    }

    private EntityReference(UUID var0) {
        this.entity = Either.left((Object)var0);
    }

    public static <T extends UniquelyIdentifyable> @Nullable EntityReference<T> of(@Nullable T var0) {
        return var0 != null ? new EntityReference<T>(var0) : null;
    }

    public static <T extends UniquelyIdentifyable> EntityReference<T> of(UUID var0) {
        return new EntityReference(var0);
    }

    public UUID getUUID() {
        return (UUID)this.entity.map(var0 -> var0, UniquelyIdentifyable::getUUID);
    }

    public @Nullable StoredEntityType getEntity(UUIDLookup<? extends UniquelyIdentifyable> var0, Class<StoredEntityType> var1) {
        StoredEntityType var4;
        Object var3;
        Optional var2 = this.entity.right();
        if (var2.isPresent()) {
            var3 = (UniquelyIdentifyable)var2.get();
            if (var3.isRemoved()) {
                this.entity = Either.left((Object)var3.getUUID());
            } else {
                return (StoredEntityType)var3;
            }
        }
        if (((Optional)(var3 = this.entity.left())).isPresent() && (var4 = this.resolve(var0.lookup((UUID)((Optional)var3).get()), var1)) != null && !var4.isRemoved()) {
            this.entity = Either.right(var4);
            return var4;
        }
        return null;
    }

    public @Nullable StoredEntityType getEntity(World var0, Class<StoredEntityType> var1) {
        if (EntityHuman.class.isAssignableFrom(var1)) {
            return this.getEntity(var0::getPlayerInAnyDimension, var1);
        }
        return this.getEntity(var0::getEntityInAnyDimension, var1);
    }

    private @Nullable StoredEntityType resolve(@Nullable UniquelyIdentifyable var0, Class<StoredEntityType> var1) {
        if (var0 != null && var1.isAssignableFrom(var0.getClass())) {
            return (StoredEntityType)((UniquelyIdentifyable)var1.cast(var0));
        }
        return null;
    }

    public boolean matches(StoredEntityType var0) {
        return this.getUUID().equals(var0.getUUID());
    }

    public void store(ValueOutput var0, String var1) {
        var0.store(var1, UUIDUtil.CODEC, this.getUUID());
    }

    public static void store(@Nullable EntityReference<?> var0, ValueOutput var1, String var2) {
        if (var0 != null) {
            var0.store(var1, var2);
        }
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable StoredEntityType get(@Nullable EntityReference<StoredEntityType> var0, World var1, Class<StoredEntityType> var2) {
        return var0 != null ? (StoredEntityType)var0.getEntity(var1, var2) : null;
    }

    public static @Nullable Entity getEntity(@Nullable EntityReference<Entity> var0, World var1) {
        return EntityReference.get(var0, var1, Entity.class);
    }

    public static @Nullable EntityLiving getLivingEntity(@Nullable EntityReference<EntityLiving> var0, World var1) {
        return EntityReference.get(var0, var1, EntityLiving.class);
    }

    public static @Nullable EntityHuman getPlayer(@Nullable EntityReference<EntityHuman> var0, World var1) {
        return EntityReference.get(var0, var1, EntityHuman.class);
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable EntityReference<StoredEntityType> read(ValueInput var0, String var1) {
        return var0.read(var1, EntityReference.codec()).orElse(null);
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable EntityReference<StoredEntityType> readWithOldOwnerConversion(ValueInput var0, String var12, World var2) {
        Optional<UUID> var3 = var0.read(var12, UUIDUtil.CODEC);
        if (var3.isPresent()) {
            return EntityReference.of(var3.get());
        }
        return var0.getString(var12).map(var1 -> NameReferencingFileConverter.convertMobOwnerIfNecessary(var2.getServer(), var1)).map(EntityReference::new).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (!(var0 instanceof EntityReference)) return false;
        EntityReference var1 = (EntityReference)var0;
        if (!this.getUUID().equals(var1.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }
}

